/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.model.ArmorModel;
import net.joefoxe.hexerei.item.custom.MushroomWitchArmorItem;
import net.joefoxe.hexerei.item.custom.WitchArmorItem;
import net.joefoxe.hexerei.util.ClientProxy;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorModels {
    private static Map<EquipmentSlot, ArmorModel> witchArmor = Collections.emptyMap();
    private static Map<EquipmentSlot, ArmorModel> mushroomWitchArmor = Collections.emptyMap();

    private static Map<EquipmentSlot, ArmorModel> make(EntityRendererProvider.Context ctx, ModelLayerLocation layer) {
        EnumMap<EquipmentSlot, ArmorModel> ret = new EnumMap<EquipmentSlot, ArmorModel>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ret.put(slot, new ArmorModel(ctx.m_174023_(layer), slot));
        }
        return ret;
    }

    public static void init(EntityRendererProvider.Context context) {
        witchArmor = ArmorModels.make(context, ClientProxy.WITCH_ARMOR_LAYER);
        mushroomWitchArmor = ArmorModels.make(context, ClientProxy.MUSHROOM_WITCH_ARMOR_LAYER);
    }

    @Nullable
    public static ArmorModel get(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof MushroomWitchArmorItem) {
            MushroomWitchArmorItem armor = (MushroomWitchArmorItem)item;
            return mushroomWitchArmor.get(armor.m_40402_());
        }
        if (item instanceof WitchArmorItem) {
            WitchArmorItem armor = (WitchArmorItem)item;
            return witchArmor.get(armor.m_40402_());
        }
        return null;
    }
}

