/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.data.books.BookImageEffect;
import net.joefoxe.hexerei.data.books.BookTooltipExtra;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.GsonHelper;

public class BookImage {
    public float x;
    public float y;
    public float z;
    public float u;
    public float v;
    public float width;
    public float height;
    public float imageWidth;
    public float imageHeight;
    public float scale;
    public String imageLoc;
    public int hyperlink_chapter;
    public int hyperlink_page;
    public String hyperlink_url;
    public ArrayList<BookImageEffect> effects;
    List<Component> extra_tooltips;
    List<BookTooltipExtra> extra_tooltips_raw;

    BookImage(float x, float y, float z, float u, float v, float width, float height, float imageWidth, float imageHeight, float scale, String imageLoc, ArrayList<BookImageEffect> effects) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.scale = scale;
        this.imageLoc = imageLoc;
        this.effects = effects;
        this.hyperlink_chapter = -1;
        this.hyperlink_page = -1;
        this.hyperlink_url = "";
    }

    BookImage(float x, float y, float z, float u, float v, float width, float height, float imageWidth, float imageHeight, float scale, String imageLoc, ArrayList<BookImageEffect> effects, int hyperlink_chapter, int hyperlink_page, String hyperlink_url, List<Component> extra_tooltips, List<BookTooltipExtra> extra_tooltips_raw) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.scale = scale;
        this.imageLoc = imageLoc;
        this.effects = effects;
        this.hyperlink_chapter = hyperlink_chapter;
        this.hyperlink_page = hyperlink_page;
        this.hyperlink_url = hyperlink_url;
        this.extra_tooltips = extra_tooltips;
        this.extra_tooltips_raw = extra_tooltips_raw;
    }

    public static CompoundTag serialize(BookImage bookImage) {
        int k;
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("image_texture", bookImage.imageLoc);
        compound.m_128350_("image_x", bookImage.x);
        compound.m_128350_("image_y", bookImage.y);
        compound.m_128350_("image_z", bookImage.z);
        compound.m_128350_("image_u", bookImage.u);
        compound.m_128350_("image_v", bookImage.v);
        compound.m_128350_("image_width", bookImage.width);
        compound.m_128350_("image_height", bookImage.height);
        compound.m_128350_("image_imageWidth", bookImage.imageWidth);
        compound.m_128350_("image_imageHeight", bookImage.imageHeight);
        compound.m_128350_("image_scale", bookImage.scale);
        compound.m_128405_("image_hyperlink_chapter", bookImage.hyperlink_chapter);
        compound.m_128405_("image_hyperlink_page", bookImage.hyperlink_page);
        compound.m_128359_("image_hyperlink_url", bookImage.hyperlink_url);
        compound.m_128405_("image_number_of_extra_tooltips", bookImage.extra_tooltips_raw.size());
        for (k = 0; k < bookImage.extra_tooltips_raw.size(); ++k) {
            compound.m_128405_("image_extra_tooltips_color" + k, bookImage.extra_tooltips_raw.get((int)k).color);
            compound.m_128359_("image_extra_tooltips_color_hex" + k, bookImage.extra_tooltips_raw.get((int)k).color_hex);
            compound.m_128359_("image_extra_tooltips_text" + k, bookImage.extra_tooltips_raw.get((int)k).text);
            compound.m_128359_("image_extra_tooltips_type" + k, bookImage.extra_tooltips_raw.get((int)k).type);
        }
        compound.m_128405_("image_numberOfImageEffects", bookImage.effects.size());
        for (k = 0; k < bookImage.effects.size(); ++k) {
            BookImageEffect effect = bookImage.effects.get(k);
            compound.m_128359_("image_type" + k, effect.type);
            compound.m_128350_("image_speed" + k, effect.speed);
            compound.m_128350_("image_amount" + k, effect.amount);
            compound.m_128365_("image_hoverImage" + k, (Tag)BookImage.serialize(effect.hoverImage));
        }
        return compound;
    }

    public static BookImage deserialize(CompoundTag image) {
        String texture = image.m_128461_("image_texture");
        float x = image.m_128457_("image_x");
        float y = image.m_128457_("image_y");
        float z = image.m_128457_("image_z");
        float u = image.m_128457_("image_u");
        float v = image.m_128457_("image_v");
        float width = image.m_128457_("image_width");
        float height = image.m_128457_("image_height");
        float imageWidth = image.m_128457_("image_imageWidth");
        float imageHeight = image.m_128457_("image_imageHeight");
        float scale = image.m_128457_("image_scale");
        int hyperlink_chapter = image.m_128451_("image_hyperlink_chapter");
        int hyperlink_page = image.m_128451_("image_hyperlink_page");
        String hyperlink_url = image.m_128461_("image_hyperlink_url");
        ArrayList<Component> extra_tooltips = new ArrayList<Component>();
        int item_number_of_extra_tooltips = image.m_128451_("image_number_of_extra_tooltips");
        MutableComponent component = Component.m_237115_((String)"");
        ArrayList<BookTooltipExtra> extra_tooltips_raw = new ArrayList<BookTooltipExtra>();
        for (int k = 0; k < item_number_of_extra_tooltips; ++k) {
            int color = image.m_128451_("image_extra_tooltips_color" + k);
            String color_hex = image.m_128461_("image_extra_tooltips_color_hex" + k);
            String text = image.m_128461_("image_extra_tooltips_text" + k);
            String text_type = image.m_128461_("image_extra_tooltips_type" + k);
            extra_tooltips_raw.add(new BookTooltipExtra(color, color_hex, text, text_type));
            if (!color_hex.equals("")) {
                color = (int)Long.parseLong(color_hex, 16);
            }
            if (text_type.equals("trail")) {
                extra_tooltips.add((Component)component);
                component = Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color));
            } else if (text_type.equals("append")) {
                component.m_7360_().add(Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color)));
            }
            if (k + 1 < item_number_of_extra_tooltips || component.getString().equals("")) continue;
            extra_tooltips.add((Component)component);
        }
        int num = image.m_128451_("image_numberOfImageEffects");
        ArrayList<BookImageEffect> effectList = new ArrayList<BookImageEffect>();
        for (int j = 0; j < num; ++j) {
            String type = image.m_128461_("image_type" + j);
            float speed = image.m_128457_("image_speed" + j);
            float amount = image.m_128457_("image_amount" + j);
            CompoundTag compoundTag = image.m_128469_("image_hoverImage" + j);
            BookImage bookImage = BookImage.deserialize(compoundTag);
            BookImageEffect bookImageEffect = new BookImageEffect(type, speed, amount, bookImage);
            effectList.add(bookImageEffect);
        }
        return new BookImage(x, y, z, u, v, width, height, imageWidth, imageHeight, scale, texture, effectList, hyperlink_chapter, hyperlink_page, hyperlink_url, extra_tooltips, extra_tooltips_raw);
    }

    public static BookImage deserialize(JsonObject object) throws CommandSyntaxException {
        float x = GsonHelper.m_13820_((JsonObject)object, (String)"x", (float)0.0f);
        float y = GsonHelper.m_13820_((JsonObject)object, (String)"y", (float)0.0f);
        float z = GsonHelper.m_13820_((JsonObject)object, (String)"z", (float)0.0f);
        float u = GsonHelper.m_13820_((JsonObject)object, (String)"u", (float)0.0f);
        float v = GsonHelper.m_13820_((JsonObject)object, (String)"v", (float)0.0f);
        float width = GsonHelper.m_13820_((JsonObject)object, (String)"width", (float)18.0f);
        float height = GsonHelper.m_13820_((JsonObject)object, (String)"height", (float)18.0f);
        float imageWidth = GsonHelper.m_13820_((JsonObject)object, (String)"imageWidth", (float)18.0f);
        float imageHeight = GsonHelper.m_13820_((JsonObject)object, (String)"imageHeight", (float)18.0f);
        float scale = GsonHelper.m_13820_((JsonObject)object, (String)"scale", (float)1.0f);
        JsonObject hyperlink = GsonHelper.m_13841_((JsonObject)object, (String)"hyperlink", (JsonObject)new JsonObject());
        int chapter = GsonHelper.m_13824_((JsonObject)hyperlink, (String)"chapter", (int)-1);
        int page = GsonHelper.m_13824_((JsonObject)hyperlink, (String)"page", (int)-1);
        String url = GsonHelper.m_13851_((JsonObject)hyperlink, (String)"url", (String)"");
        JsonArray yourJson = GsonHelper.m_13832_((JsonObject)object, (String)"effects", (JsonArray)new JsonArray());
        ArrayList<BookImageEffect> effectList = new ArrayList<BookImageEffect>();
        for (int i = 0; i < yourJson.size(); ++i) {
            JsonObject extraItemObject = yourJson.get(i).getAsJsonObject();
            effectList.add(BookImageEffect.deserialize(extraItemObject));
        }
        String itemLoc = GsonHelper.m_13851_((JsonObject)object, (String)"texture", (String)"");
        JsonArray textComp = GsonHelper.m_13832_((JsonObject)object, (String)"tooltip", (JsonArray)new JsonArray());
        ArrayList<Component> textComponentsList = new ArrayList<Component>();
        ArrayList<BookTooltipExtra> bookTooltipExtraList = new ArrayList<BookTooltipExtra>();
        MutableComponent component = Component.m_237115_((String)"");
        for (int i = 0; i < textComp.size(); ++i) {
            JsonObject extraItemObject = textComp.get(i).getAsJsonObject();
            int color = GsonHelper.m_13824_((JsonObject)extraItemObject, (String)"color", (int)0xFFFFFF);
            String string = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"text", (String)"empty");
            String type = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"type", (String)"append");
            String hex_color = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"color_hex", (String)"");
            if (!hex_color.equals("")) {
                color = (int)Long.parseLong(hex_color, 16);
            }
            if (type.equals("trail")) {
                textComponentsList.add((Component)component);
                component = Component.m_237115_((String)string).m_130948_(Style.f_131099_.m_178520_(color));
            } else if (type.equals("append")) {
                component.m_7360_().add(Component.m_237115_((String)string).m_130948_(Style.f_131099_.m_178520_(color)));
            }
            if (i + 1 >= textComp.size() && !component.getString().equals("")) {
                textComponentsList.add((Component)component);
            }
            bookTooltipExtraList.add(new BookTooltipExtra(color, hex_color, string, type));
        }
        return new BookImage(x, y, z, u, v, width, height, imageWidth, imageHeight, scale, itemLoc, effectList, chapter, page, url, textComponentsList, bookTooltipExtraList);
    }
}

