/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import java.util.LinkedHashMap;
import java.util.Map;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookHyperlink;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.BookEntriesPacket;
import net.joefoxe.hexerei.util.message.BookPagesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.PacketDistributor;

public class BookManager {
    private static final Map<ResourceLocation, BookPage> BOOK_PAGES = new LinkedHashMap<ResourceLocation, BookPage>();
    private static final Map<String, BookHyperlink> BOOK_ITEM_HYPERLINKS = new LinkedHashMap<String, BookHyperlink>();
    private static BookEntries BOOK_ENTRIES = null;

    public static void clearBookPages() {
        BOOK_PAGES.clear();
    }

    public static void clearBookEntries() {
        BOOK_ENTRIES = null;
    }

    public static void addBookPage(ResourceLocation loc, BookPage bookPage) {
        BOOK_PAGES.put(loc, bookPage);
    }

    public static void addBookItemHyperlink(String loc, BookHyperlink hyperlink) {
        BOOK_ITEM_HYPERLINKS.put(loc, hyperlink);
    }

    public static void addBookEntries(BookEntries bookEntry) {
        BOOK_ENTRIES = bookEntry;
    }

    public static void sendBookPagesToClient() {
        HexereiPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new BookPagesPacket(BOOK_PAGES));
    }

    public static void sendBookEntriesToClient() {
        HexereiPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new BookEntriesPacket(BOOK_ENTRIES));
    }

    public static BookPage getBookPages(ResourceLocation loc) {
        if (BOOK_PAGES.containsKey(loc)) {
            return BOOK_PAGES.get(loc);
        }
        return null;
    }

    public static BookEntries getBookEntries() {
        return BOOK_ENTRIES;
    }

    public static Map<String, BookHyperlink> getBookItemHyperlinks() {
        return BOOK_ITEM_HYPERLINKS;
    }
}

