/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookHoverOffset;
import net.joefoxe.hexerei.data.books.BookImage;
import net.joefoxe.hexerei.data.books.BookImageEffect;
import net.joefoxe.hexerei.data.books.BookItemsAndFluids;
import net.joefoxe.hexerei.data.books.BookNonItemTooltip;
import net.joefoxe.hexerei.data.books.BookParagraph;
import net.joefoxe.hexerei.data.books.BookParagraphElements;
import net.joefoxe.hexerei.data.books.BookTooltipExtra;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BookPage {
    public String showTitle;
    public String itemHyperlink;
    public ArrayList<BookParagraph> paragraph;
    public ArrayList<BookItemsAndFluids> itemList;
    public ArrayList<BookEntity> entityList;
    public ArrayList<BookImage> imageList;
    public ArrayList<BookNonItemTooltip> nonItemTooltipList;

    public BookPage(String showTitle, ArrayList<BookParagraph> paragraph, ArrayList<BookItemsAndFluids> itemList, ArrayList<BookEntity> entityList, ArrayList<BookImage> imageList, ArrayList<BookNonItemTooltip> nonItemTooltipList, String itemHyperlink) {
        this.showTitle = showTitle;
        this.itemHyperlink = itemHyperlink;
        this.paragraph = paragraph;
        this.itemList = itemList;
        this.entityList = entityList;
        this.imageList = imageList;
        this.nonItemTooltipList = nonItemTooltipList;
    }

    public static CompoundTag saveToTag(BookPage bookPage) {
        CompoundTag compound;
        int i;
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("showTitle", bookPage.showTitle);
        tag.m_128359_("item_hyperlink", bookPage.itemHyperlink);
        tag.m_128405_("numberOfPassages", bookPage.paragraph.size());
        for (i = 0; i < bookPage.paragraph.size(); ++i) {
            BookParagraph bookParagraph = bookPage.paragraph.get(i);
            CompoundTag compound2 = new CompoundTag();
            compound2.m_128359_("paragraph_text" + i, bookPage.paragraph.get((int)i).passage);
            compound2.m_128359_("align" + i, bookPage.paragraph.get((int)i).align);
            int num = bookParagraph.paragraphElements.size();
            compound2.m_128405_("numberOfBoxes" + i, num);
            for (int k = 0; k < num; ++k) {
                BookParagraphElements bookParagraphElements = (BookParagraphElements)bookParagraph.paragraphElements.toArray()[k];
                CompoundTag compoundBoxes = new CompoundTag();
                compoundBoxes.m_128350_("box_x" + i + k, bookParagraphElements.x);
                compoundBoxes.m_128350_("box_y" + i + k, bookParagraphElements.y);
                compoundBoxes.m_128350_("box_height" + i + k, bookParagraphElements.height);
                compoundBoxes.m_128350_("box_width" + i + k, bookParagraphElements.width);
                compound2.m_128365_("paragraph_box" + i + k, (Tag)compoundBoxes);
            }
            tag.m_128365_("paragraph" + i, (Tag)compound2);
        }
        tag.m_128405_("numberOfItems", bookPage.itemList.size());
        block12: for (i = 0; i < bookPage.itemList.size(); ++i) {
            compound = new CompoundTag();
            String type = ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).type;
            compound.m_128359_("item_type" + i, type);
            switch (type) {
                case "fluid": {
                    int k;
                    compound.m_128350_("item_x" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).x);
                    compound.m_128350_("item_y" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).y);
                    compound.m_128365_("item_fluid" + i, (Tag)((BookItemsAndFluids)bookPage.itemList.toArray()[i]).fluid.writeToNBT(new CompoundTag()));
                    compound.m_128350_("item_capacity" + i, (float)((BookItemsAndFluids)bookPage.itemList.toArray()[i]).capacity);
                    compound.m_128350_("item_amount" + i, (float)((BookItemsAndFluids)bookPage.itemList.toArray()[i]).amount);
                    compound.m_128350_("item_fluid_height" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).fluid_height);
                    compound.m_128350_("item_fluid_width" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).fluid_width);
                    compound.m_128350_("item_fluid_offset_x" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).fluid_offset_x);
                    compound.m_128350_("item_fluid_offset_y" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).fluid_offset_y);
                    compound.m_128359_("item_tag" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).tag);
                    compound.m_128379_("item_show_slot" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).show_slot);
                    List<BookTooltipExtra> extra_tooltips_raw = ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).extra_tooltips_raw;
                    compound.m_128405_("item_number_of_extra_tooltips" + i, extra_tooltips_raw.size());
                    for (k = 0; k < extra_tooltips_raw.size(); ++k) {
                        compound.m_128405_("item_extra_tooltips_color" + i + k, extra_tooltips_raw.get((int)k).color);
                        compound.m_128359_("item_extra_tooltips_color_hex" + i + k, extra_tooltips_raw.get((int)k).color_hex);
                        compound.m_128359_("item_extra_tooltips_text" + i + k, extra_tooltips_raw.get((int)k).text);
                        compound.m_128359_("item_extra_tooltips_type" + i + k, extra_tooltips_raw.get((int)k).type);
                    }
                    tag.m_128365_("items_and_fluids" + i, (Tag)compound);
                    continue block12;
                }
                case "item": {
                    int k;
                    ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).item.m_41739_(compound);
                    compound.m_128350_("item_x" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).x);
                    compound.m_128350_("item_y" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).y);
                    compound.m_128359_("item_tag" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).tag);
                    compound.m_128379_("item_show_slot" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).show_slot);
                    List<BookTooltipExtra> extra_tooltips_raw = ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).extra_tooltips_raw;
                    compound.m_128405_("item_number_of_extra_tooltips" + i, extra_tooltips_raw.size());
                    for (k = 0; k < extra_tooltips_raw.size(); ++k) {
                        compound.m_128405_("item_extra_tooltips_color" + i + k, extra_tooltips_raw.get((int)k).color);
                        compound.m_128359_("item_extra_tooltips_color_hex" + i + k, extra_tooltips_raw.get((int)k).color_hex);
                        compound.m_128359_("item_extra_tooltips_text" + i + k, extra_tooltips_raw.get((int)k).text);
                        compound.m_128359_("item_extra_tooltips_type" + i + k, extra_tooltips_raw.get((int)k).type);
                    }
                    tag.m_128365_("items_and_fluids" + i, (Tag)compound);
                    continue block12;
                }
                case "tag": {
                    int k;
                    ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).item.m_41739_(compound);
                    compound.m_128350_("item_x" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).x);
                    compound.m_128350_("item_y" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).y);
                    compound.m_128379_("item_show_slot" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).show_slot);
                    compound.m_128359_("item_tag" + i, ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).tag);
                    List<BookTooltipExtra> extra_tooltips_raw = ((BookItemsAndFluids)bookPage.itemList.toArray()[i]).extra_tooltips_raw;
                    compound.m_128405_("item_number_of_extra_tooltips" + i, extra_tooltips_raw.size());
                    for (k = 1; k < extra_tooltips_raw.size(); ++k) {
                        compound.m_128405_("item_extra_tooltips_color" + i + k, extra_tooltips_raw.get((int)k).color);
                        compound.m_128359_("item_extra_tooltips_color_hex" + i + k, extra_tooltips_raw.get((int)k).color_hex);
                        compound.m_128359_("item_extra_tooltips_text" + i + k, extra_tooltips_raw.get((int)k).text);
                        compound.m_128359_("item_extra_tooltips_type" + i + k, extra_tooltips_raw.get((int)k).type);
                    }
                    tag.m_128365_("items_and_fluids" + i, (Tag)compound);
                }
            }
        }
        tag.m_128405_("numberOfImages", bookPage.imageList.size());
        for (i = 0; i < bookPage.imageList.size(); ++i) {
            compound = new CompoundTag();
            BookImage bookImage = (BookImage)bookPage.imageList.toArray()[i];
            String texture = bookImage.imageLoc;
            float x = bookImage.x;
            float y = bookImage.y;
            float z = bookImage.z;
            float u = bookImage.u;
            float v = bookImage.v;
            float width = bookImage.width;
            float height = bookImage.height;
            float imageWidth = bookImage.imageWidth;
            float imageHeight = bookImage.imageHeight;
            float scale = bookImage.scale;
            int hyperlink_chapter = bookImage.hyperlink_chapter;
            int hyperlink_page = bookImage.hyperlink_page;
            String hyperlink_url = bookImage.hyperlink_url;
            compound.m_128359_("image_texture", texture);
            compound.m_128350_("image_x", x);
            compound.m_128350_("image_y", y);
            compound.m_128350_("image_z", z);
            compound.m_128350_("image_u", u);
            compound.m_128350_("image_v", v);
            compound.m_128350_("image_width", width);
            compound.m_128350_("image_height", height);
            compound.m_128350_("image_imageWidth", imageWidth);
            compound.m_128350_("image_imageHeight", imageHeight);
            compound.m_128350_("image_scale", scale);
            compound.m_128405_("image_hyperlink_chapter", hyperlink_chapter);
            compound.m_128405_("image_hyperlink_page", hyperlink_page);
            compound.m_128359_("image_hyperlink_url", hyperlink_url);
            List<BookTooltipExtra> extra_tooltips_raw = bookImage.extra_tooltips_raw;
            compound.m_128405_("image_number_of_extra_tooltips", extra_tooltips_raw.size());
            for (int k = 0; k < extra_tooltips_raw.size(); ++k) {
                compound.m_128405_("image_extra_tooltips_color" + k, extra_tooltips_raw.get((int)k).color);
                compound.m_128359_("image_extra_tooltips_color_hex" + k, extra_tooltips_raw.get((int)k).color_hex);
                compound.m_128359_("image_extra_tooltips_text" + k, extra_tooltips_raw.get((int)k).text);
                compound.m_128359_("image_extra_tooltips_type" + k, extra_tooltips_raw.get((int)k).type);
            }
            ArrayList<BookImageEffect> bookImageEffects = bookImage.effects;
            compound.m_128405_("image_numberOfImageEffects", bookImageEffects.size());
            for (int k = 0; k < bookImageEffects.size(); ++k) {
                BookImageEffect effect = (BookImageEffect)bookImageEffects.get(k);
                compound.m_128359_("image_type" + k, effect.type);
                compound.m_128350_("image_speed" + k, effect.speed);
                compound.m_128350_("image_amount" + k, effect.amount);
                compound.m_128365_("image_hoverImage" + k, (Tag)BookImage.serialize(effect.hoverImage));
            }
            tag.m_128365_("images" + i, (Tag)compound);
        }
        tag.m_128405_("numberOfNonItemTooltipList", bookPage.nonItemTooltipList.size());
        for (i = 0; i < bookPage.nonItemTooltipList.size(); ++i) {
            compound = new CompoundTag();
            BookNonItemTooltip nonItemTooltip = (BookNonItemTooltip)bookPage.nonItemTooltipList.toArray()[i];
            compound.m_128350_("x", nonItemTooltip.x);
            compound.m_128350_("y", nonItemTooltip.y);
            compound.m_128350_("width", nonItemTooltip.width);
            compound.m_128350_("height", nonItemTooltip.height);
            compound.m_128405_("hyperlink_chapter", nonItemTooltip.hyperlink_chapter);
            compound.m_128405_("hyperlink_page", nonItemTooltip.hyperlink_page);
            compound.m_128359_("hyperlink_url", nonItemTooltip.hyperlink_url);
            List<BookTooltipExtra> extra_tooltips_raw = nonItemTooltip.extra_tooltips_raw;
            compound.m_128405_("number_of_tooltips", extra_tooltips_raw.size());
            for (int k = 0; k < extra_tooltips_raw.size(); ++k) {
                compound.m_128405_("extra_tooltips_color" + k, extra_tooltips_raw.get((int)k).color);
                compound.m_128359_("extra_tooltips_color_hex" + k, extra_tooltips_raw.get((int)k).color_hex);
                compound.m_128359_("extra_tooltips_text" + k, extra_tooltips_raw.get((int)k).text);
                compound.m_128359_("extra_tooltips_type" + k, extra_tooltips_raw.get((int)k).type);
            }
            tag.m_128365_("nonItemTooltipList" + i, (Tag)compound);
        }
        tag.m_128405_("numberOfEntities", bookPage.entityList.size());
        for (i = 0; i < bookPage.entityList.size(); ++i) {
            compound = new CompoundTag();
            BookEntity bookEntity = (BookEntity)bookPage.entityList.toArray()[i];
            compound.m_128359_("entity", bookEntity.entityType);
            compound.m_128350_("x", bookEntity.x);
            compound.m_128350_("y", bookEntity.y);
            compound.m_128350_("scale", bookEntity.scale);
            compound.m_128359_("entityTags", bookEntity.entityTags);
            compound.m_128405_("entityTagsListSize", bookEntity.entityTagsList.size());
            for (int k = 0; k < bookEntity.entityTagsList.size(); ++k) {
                compound.m_128359_("entityTagsList" + k, bookEntity.entityTagsList.get(k));
            }
            tag.m_128365_("entities" + i, (Tag)compound);
        }
        return tag;
    }

    public static BookPage loadFromTag(CompoundTag tag) {
        float y;
        String show_title = tag.m_128461_("showTitle");
        String item_hyperlink = tag.m_128461_("item_hyperlink");
        int size = tag.m_128451_("numberOfPassages");
        ArrayList<BookParagraph> list = new ArrayList<BookParagraph>();
        for (int i = 0; i < size; ++i) {
            CompoundTag paragraph = tag.m_128469_("paragraph" + i);
            String string = paragraph.m_128461_("paragraph_text" + i);
            String align = paragraph.m_128461_("align" + i);
            int num = paragraph.m_128451_("numberOfBoxes" + i);
            Object boxList = new ArrayList();
            for (int k = 0; k < num; ++k) {
                CompoundTag boxes = paragraph.m_128469_("paragraph_box" + i + k);
                float x = boxes.m_128457_("box_x" + i + k);
                float y2 = boxes.m_128457_("box_y" + i + k);
                float height = boxes.m_128457_("box_height" + i + k);
                float width = boxes.m_128457_("box_width" + i + k);
                BookParagraphElements bookParagraphElements = new BookParagraphElements(x, y2, height, width);
                ((ArrayList)boxList).add(bookParagraphElements);
            }
            BookParagraph bookParagraph = new BookParagraph((ArrayList<BookParagraphElements>)boxList, string, align);
            list.add(bookParagraph);
        }
        int num = tag.m_128451_("numberOfItems");
        ArrayList<BookItemsAndFluids> itemList = new ArrayList<BookItemsAndFluids>();
        block12: for (int i = 0; i < num; ++i) {
            CompoundTag itemsAndFluids = tag.m_128469_("items_and_fluids" + i);
            String type = itemsAndFluids.m_128461_("item_type" + i);
            switch (type) {
                case "item": {
                    float x = itemsAndFluids.m_128457_("item_x" + i);
                    y = itemsAndFluids.m_128457_("item_y" + i);
                    boolean show_slot = itemsAndFluids.m_128471_("item_show_slot" + i);
                    ArrayList<Component> extra_tooltips = new ArrayList<Component>();
                    int item_number_of_extra_tooltips = itemsAndFluids.m_128451_("item_number_of_extra_tooltips" + i);
                    MutableComponent component = Component.m_237115_((String)"");
                    ArrayList<BookTooltipExtra> tooltipExtras = new ArrayList<BookTooltipExtra>();
                    for (int k = 0; k < item_number_of_extra_tooltips; ++k) {
                        int color = itemsAndFluids.m_128451_("item_extra_tooltips_color" + i + k);
                        String color_hex = itemsAndFluids.m_128461_("item_extra_tooltips_color_hex" + i + k);
                        String text = itemsAndFluids.m_128461_("item_extra_tooltips_text" + i + k);
                        String text_type = itemsAndFluids.m_128461_("item_extra_tooltips_type" + i + k);
                        tooltipExtras.add(new BookTooltipExtra(color, color_hex, text, text_type));
                        if (!color_hex.equals("")) {
                            color = (int)Long.parseLong(color_hex, 16);
                        }
                        if (text_type.equals("trail")) {
                            extra_tooltips.add((Component)component);
                            component = Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color));
                        } else if (text_type.equals("append")) {
                            component.m_7360_().add(Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color)));
                        }
                        if (k + 1 < item_number_of_extra_tooltips || component.getString().equals("")) continue;
                        extra_tooltips.add((Component)component);
                    }
                    BookItemsAndFluids bookItemStackInSlot = new BookItemsAndFluids(x, y, ItemStack.m_41712_((CompoundTag)itemsAndFluids), show_slot, extra_tooltips, tooltipExtras);
                    itemList.add(bookItemStackInSlot);
                    continue block12;
                }
                case "fluid": {
                    float x = itemsAndFluids.m_128457_("item_x" + i);
                    y = itemsAndFluids.m_128457_("item_y" + i);
                    float fluid_height = itemsAndFluids.m_128457_("item_fluid_height" + i);
                    float fluid_width = itemsAndFluids.m_128457_("item_fluid_width" + i);
                    float fluid_offset_x = itemsAndFluids.m_128457_("item_fluid_offset_x" + i);
                    float fluid_offset_y = itemsAndFluids.m_128457_("item_fluid_offset_y" + i);
                    int amount = itemsAndFluids.m_128451_("item_amount" + i);
                    int capacity = itemsAndFluids.m_128451_("item_capacity" + i);
                    boolean show_slot = itemsAndFluids.m_128471_("item_show_slot" + i);
                    int item_number_of_extra_tooltips = itemsAndFluids.m_128451_("item_number_of_extra_tooltips" + i);
                    CompoundTag compoundFluid = itemsAndFluids.m_128469_("item_fluid" + i);
                    FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)compoundFluid);
                    ArrayList<Component> extra_tooltips = new ArrayList<Component>();
                    MutableComponent component = Component.m_237115_((String)"");
                    ArrayList<BookTooltipExtra> tooltipExtras = new ArrayList<BookTooltipExtra>();
                    for (int k = 0; k < item_number_of_extra_tooltips; ++k) {
                        int color = itemsAndFluids.m_128451_("item_extra_tooltips_color" + i + k);
                        String color_hex = itemsAndFluids.m_128461_("item_extra_tooltips_color_hex" + i + k);
                        String text = itemsAndFluids.m_128461_("item_extra_tooltips_text" + i + k);
                        String text_type = itemsAndFluids.m_128461_("item_extra_tooltips_type" + i + k);
                        tooltipExtras.add(new BookTooltipExtra(color, color_hex, text, text_type));
                        if (!color_hex.equals("")) {
                            color = (int)Long.parseLong(color_hex, 16);
                        }
                        if (text_type.equals("trail")) {
                            extra_tooltips.add((Component)component);
                            component = Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color));
                        } else if (text_type.equals("append")) {
                            component.m_7360_().add(Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color)));
                        }
                        if (k + 1 < item_number_of_extra_tooltips || component.getString().equals("")) continue;
                        extra_tooltips.add((Component)component);
                    }
                    BookItemsAndFluids bookItemStackInSlot = new BookItemsAndFluids(x, y, fluid, amount, capacity, show_slot, fluid_height, fluid_width, fluid_offset_x, fluid_offset_y, extra_tooltips, tooltipExtras);
                    itemList.add(bookItemStackInSlot);
                    continue block12;
                }
                case "tag": {
                    float x = itemsAndFluids.m_128457_("item_x" + i);
                    y = itemsAndFluids.m_128457_("item_y" + i);
                    String item_tag = itemsAndFluids.m_128461_("item_tag" + i);
                    boolean show_slot = itemsAndFluids.m_128471_("item_show_slot" + i);
                    ArrayList<Component> extra_tooltips = new ArrayList<Component>();
                    int item_number_of_extra_tooltips = itemsAndFluids.m_128451_("item_number_of_extra_tooltips" + i);
                    MutableComponent component = Component.m_237115_((String)"");
                    ArrayList<BookTooltipExtra> tooltipExtras = new ArrayList<BookTooltipExtra>();
                    for (int k = 1; k < item_number_of_extra_tooltips; ++k) {
                        int color = itemsAndFluids.m_128451_("item_extra_tooltips_color" + i + k);
                        String color_hex = itemsAndFluids.m_128461_("item_extra_tooltips_color_hex" + i + k);
                        String text = itemsAndFluids.m_128461_("item_extra_tooltips_text" + i + k);
                        String text_type = itemsAndFluids.m_128461_("item_extra_tooltips_type" + i + k);
                        tooltipExtras.add(new BookTooltipExtra(color, color_hex, text, text_type));
                        if (!color_hex.equals("")) {
                            color = (int)Long.parseLong(color_hex, 16);
                        }
                        if (text_type.equals("trail")) {
                            extra_tooltips.add((Component)component);
                            component = Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color));
                        } else if (text_type.equals("append")) {
                            component.m_7360_().add(Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color)));
                        }
                        if (k + 1 < item_number_of_extra_tooltips || component.getString().equals("")) continue;
                        extra_tooltips.add((Component)component);
                    }
                    BookItemsAndFluids bookItemStackInSlot = new BookItemsAndFluids(x, y, item_tag, show_slot, extra_tooltips, tooltipExtras);
                    itemList.add(bookItemStackInSlot);
                }
            }
        }
        int numberOfImages = tag.m_128451_("numberOfImages");
        ArrayList<BookImage> imageList = new ArrayList<BookImage>();
        for (int i = 0; i < numberOfImages; ++i) {
            CompoundTag image = tag.m_128469_("images" + i);
            String texture = image.m_128461_("image_texture");
            float x = image.m_128457_("image_x");
            y = image.m_128457_("image_y");
            float z = image.m_128457_("image_z");
            float u = image.m_128457_("image_u");
            float v = image.m_128457_("image_v");
            float width = image.m_128457_("image_width");
            float height = image.m_128457_("image_height");
            float imageWidth = image.m_128457_("image_imageWidth");
            float imageHeight = image.m_128457_("image_imageHeight");
            float scale = image.m_128457_("image_scale");
            int hyperlink_chapter = image.m_128451_("image_hyperlink_chapter");
            int hyperlink_page = image.m_128451_("image_hyperlink_page");
            String hyperlink_url = image.m_128461_("image_hyperlink_url");
            ArrayList<Component> extra_tooltips = new ArrayList<Component>();
            int item_number_of_extra_tooltips = image.m_128451_("image_number_of_extra_tooltips");
            MutableComponent component = Component.m_237115_((String)"");
            ArrayList<BookTooltipExtra> extra_tooltips_raw = new ArrayList<BookTooltipExtra>();
            for (int k = 0; k < item_number_of_extra_tooltips; ++k) {
                int color = image.m_128451_("image_extra_tooltips_color" + k);
                String color_hex = image.m_128461_("image_extra_tooltips_color_hex" + k);
                String text = image.m_128461_("image_extra_tooltips_text" + k);
                String text_type = image.m_128461_("image_extra_tooltips_type" + k);
                extra_tooltips_raw.add(new BookTooltipExtra(color, color_hex, text, text_type));
                if (!color_hex.equals("")) {
                    color = (int)Long.parseLong(color_hex, 16);
                }
                if (text_type.equals("trail")) {
                    extra_tooltips.add((Component)component);
                    component = Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color));
                } else if (text_type.equals("append")) {
                    component.m_7360_().add(Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color)));
                }
                if (k + 1 < item_number_of_extra_tooltips || component.getString().equals("")) continue;
                extra_tooltips.add((Component)component);
            }
            int image_numberOfImageEffects = image.m_128451_("image_numberOfImageEffects");
            ArrayList<BookImageEffect> effectList = new ArrayList<BookImageEffect>();
            for (int j = 0; j < image_numberOfImageEffects; ++j) {
                String type = image.m_128461_("image_type" + j);
                float speed = image.m_128457_("image_speed" + j);
                float amount = image.m_128457_("image_amount" + j);
                CompoundTag compoundTag = image.m_128469_("image_hoverImage" + j);
                BookImage bookImage = BookImage.deserialize(compoundTag);
                BookImageEffect bookImageEffect = new BookImageEffect(type, speed, amount, bookImage);
                effectList.add(bookImageEffect);
            }
            BookImage bookImage = new BookImage(x, y, z, u, v, width, height, imageWidth, imageHeight, scale, texture, effectList, hyperlink_chapter, hyperlink_page, hyperlink_url, extra_tooltips, extra_tooltips_raw);
            imageList.add(bookImage);
        }
        int numberOfEntities = tag.m_128451_("numberOfEntities");
        ArrayList<BookEntity> entityList = new ArrayList<BookEntity>();
        for (int i = 0; i < numberOfEntities; ++i) {
            CompoundTag entity = tag.m_128469_("entities" + i);
            String stringEntity = entity.m_128461_("entity");
            float x = entity.m_128457_("x");
            float y3 = entity.m_128457_("y");
            float scale = entity.m_128457_("scale");
            String entityTags = entity.m_128461_("entityTags");
            int entityTagsListSize = entity.m_128451_("entityTagsListSize");
            ArrayList<String> tagList = new ArrayList<String>();
            for (int k = 0; k < entityTagsListSize; ++k) {
                tagList.add(entity.m_128461_("entityTagsList" + k));
            }
            BookEntity bookEntity = new BookEntity(scale, x, y3, stringEntity, null, entityTags, tagList, new BookHoverOffset(0.0f, 0.0f, 1.0f));
            entityList.add(bookEntity);
        }
        int numberOfNonItemTooltipList = tag.m_128451_("numberOfNonItemTooltipList");
        ArrayList<BookNonItemTooltip> nonItemTooltipList = new ArrayList<BookNonItemTooltip>();
        for (int i = 0; i < numberOfNonItemTooltipList; ++i) {
            CompoundTag nonItemTooltip = tag.m_128469_("nonItemTooltipList" + i);
            float x = nonItemTooltip.m_128457_("x");
            float y4 = nonItemTooltip.m_128457_("y");
            float width = nonItemTooltip.m_128457_("width");
            float height = nonItemTooltip.m_128457_("height");
            int hyperlink_chapter = nonItemTooltip.m_128451_("hyperlink_chapter");
            int hyperlink_page = nonItemTooltip.m_128451_("hyperlink_page");
            String hyperlink_url = nonItemTooltip.m_128461_("hyperlink_url");
            ArrayList<Component> extra_tooltips = new ArrayList<Component>();
            int number_of_tooltips = nonItemTooltip.m_128451_("number_of_tooltips");
            MutableComponent component = Component.m_237115_((String)"");
            ArrayList<BookTooltipExtra> extra_tooltips_raw = new ArrayList<BookTooltipExtra>();
            for (int k = 0; k < number_of_tooltips; ++k) {
                int color = nonItemTooltip.m_128451_("extra_tooltips_color" + k);
                String color_hex = nonItemTooltip.m_128461_("extra_tooltips_color_hex" + k);
                String text = nonItemTooltip.m_128461_("extra_tooltips_text" + k);
                String text_type = nonItemTooltip.m_128461_("extra_tooltips_type" + k);
                extra_tooltips_raw.add(new BookTooltipExtra(color, color_hex, text, text_type));
                if (!color_hex.equals("")) {
                    color = (int)Long.parseLong(color_hex, 16);
                }
                if (text_type.equals("trail")) {
                    extra_tooltips.add((Component)component);
                    component = Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color));
                } else if (text_type.equals("append")) {
                    component.m_7360_().add(Component.m_237115_((String)text).m_130948_(Style.f_131099_.m_178520_(color)));
                }
                if (k + 1 < number_of_tooltips || component.getString().equals("")) continue;
                extra_tooltips.add((Component)component);
            }
            BookNonItemTooltip bookNonItemTooltip = new BookNonItemTooltip(x, y4, width, height, hyperlink_chapter, hyperlink_page, extra_tooltips, hyperlink_url, extra_tooltips_raw);
            nonItemTooltipList.add(bookNonItemTooltip);
        }
        return new BookPage(show_title, list, itemList, entityList, imageList, nonItemTooltipList, item_hyperlink);
    }
}

