/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.fluid.FluidIngredient;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class DipperRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final FluidStack liquid;
    private final int fluidLevelsConsumed;
    private final int dippingTime;
    private final int dryingTime;
    private final int numberOfDips;
    private final boolean useInputItemAsOutput;
    protected static final List<Boolean> itemMatchesSlot = new ArrayList<Boolean>();

    public boolean m_5598_() {
        return true;
    }

    public DipperRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, FluidStack liquid, int fluidLevelsConsumed, int dippingTime, int dryingTime, int numberOfDips, boolean useInputItemAsOutput) {
        this.id = id;
        this.output = output;
        this.recipeItems = inputs;
        this.liquid = liquid;
        this.fluidLevelsConsumed = fluidLevelsConsumed;
        this.dippingTime = dippingTime;
        this.dryingTime = dryingTime;
        this.numberOfDips = numberOfDips;
        this.useInputItemAsOutput = useInputItemAsOutput;
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.add(false);
        }
    }

    public List<FluidIngredient> getFluidIngredients() {
        return new ArrayList<FluidIngredient>(List.of(FluidIngredient.fromFluidStack(this.liquid)));
    }

    public FluidIngredient getFluidIngredient() {
        return FluidIngredient.fromFluidStack(this.liquid);
    }

    public boolean matches(SimpleContainer inv, Level worldIn) {
        return ((Ingredient)this.recipeItems.get(0)).test(inv.m_8020_(0)) || ((Ingredient)this.recipeItems.get(0)).test(inv.m_8020_(1)) || ((Ingredient)this.recipeItems.get(0)).test(inv.m_8020_(2));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public ItemStack assemble(SimpleContainer inv) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public FluidStack getLiquid() {
        return this.liquid;
    }

    public int getFluidLevelsConsumed() {
        return this.fluidLevelsConsumed;
    }

    public int getDippingTime() {
        return this.dippingTime;
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    public int getNumberOfDips() {
        return this.numberOfDips;
    }

    public boolean getUseInputItemAsOutput() {
        return this.useInputItemAsOutput;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.CANDLE_DIPPER.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.DIPPER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<DipperRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "dipper";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<DipperRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("hexerei", "dipper");

        public DipperRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            ItemStack input = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            FluidStack liquid = Serializer.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"liquid"));
            boolean useInputItemAsOutput = GsonHelper.m_13855_((JsonObject)json, (String)"useInputItemAsOutput", (boolean)false);
            int fluidLevelsConsumed = GsonHelper.m_13927_((JsonObject)json, (String)"fluidLevelsConsumed");
            int dippingTime = GsonHelper.m_13927_((JsonObject)json, (String)"dippingTimeInTicks");
            int dryingTime = GsonHelper.m_13927_((JsonObject)json, (String)"dryingTimeInTicks");
            int numberOfDips = GsonHelper.m_13927_((JsonObject)json, (String)"numberOfDips");
            inputs.set(0, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}));
            return new DipperRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, liquid, fluidLevelsConsumed, dippingTime, dryingTime, numberOfDips, useInputItemAsOutput);
        }

        @Nullable
        public DipperRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList inputs = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new DipperRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, buffer.readFluidStack(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readBoolean());
        }

        public void toNetwork(FriendlyByteBuf buffer, DipperRecipe recipe) {
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeFluidStack(recipe.getLiquid());
            buffer.writeInt(recipe.getFluidLevelsConsumed());
            buffer.writeInt(recipe.getDippingTime());
            buffer.writeInt(recipe.getDryingTime());
            buffer.writeInt(recipe.getNumberOfDips());
            buffer.writeBoolean(recipe.getUseInputItemAsOutput());
        }

        public static FluidStack deserializeFluidStack(JsonObject json) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid '" + id + "'");
            }
            FluidStack stack = new FluidStack(fluid, 1);
            if (!json.has("nbt")) {
                return stack;
            }
            try {
                JsonElement element = json.get("nbt");
                stack.setTag(TagParser.m_129359_((String)(element.isJsonObject() ? Hexerei.GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            return stack;
        }
    }
}

