/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.items;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class JarHandler
extends ItemStackHandler {
    public final int stacklimit;

    public JarHandler(int size, int stacklimit) {
        super(size);
        this.stacklimit = stacklimit;
    }

    public boolean isEmpty() {
        return IntStream.range(0, this.getSlots()).allMatch(i -> this.getStackInSlot(i).m_41619_());
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.getSlots()).mapToObj(arg_0 -> ((JarHandler)this).getStackInSlot(arg_0)).allMatch(ItemStack::m_41619_);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
    }

    public int getSlotLimit(int slot) {
        return this.stacklimit;
    }

    public int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.stacklimit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, this.stacklimit);
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public NonNullList<ItemStack> getContents() {
        return this.stacks;
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.getContents().get(i)).m_41619_()) continue;
            int realCount = Math.min(this.stacklimit, ((ItemStack)this.getContents().get(i)).m_41613_());
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.getContents().get(i)).m_41739_(itemTag);
            itemTag.m_128405_("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.getContents().size());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.getContents().size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            ItemStack stack;
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            if (itemTags.m_128425_("StackList", 9)) {
                stack = ItemStack.f_41583_;
                ListTag stackTagList = itemTags.m_128437_("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundTag itemTag = stackTagList.m_128728_(j);
                    ItemStack temp = ItemStack.m_41712_((CompoundTag)itemTag);
                    if (temp.m_41619_()) continue;
                    if (stack.m_41619_()) {
                        stack = temp;
                        continue;
                    }
                    stack.m_41769_(temp.m_41613_());
                }
                if (stack.m_41619_()) continue;
                int count = stack.m_41613_();
                count = Math.min(count, this.getStackLimit(slot, stack));
                stack.m_41764_(count);
                this.stacks.set(slot, (Object)stack);
                continue;
            }
            stack = ItemStack.m_41712_((CompoundTag)itemTags);
            if (itemTags.m_128425_("ExtendedCount", 3)) {
                stack.m_41764_(itemTags.m_128451_("ExtendedCount"));
            }
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }
}

