/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin.light;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.joefoxe.hexerei.event.EventQueue;
import net.joefoxe.hexerei.event.FadeLightTimedEventHexerei;
import net.joefoxe.hexerei.light.DynamicLightUtil;
import net.joefoxe.hexerei.light.LambHexereiDynamicLight;
import net.joefoxe.hexerei.light.LightManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class HexereiLightEntityMixin
implements LambHexereiDynamicLight {
    @Shadow
    public Level f_19853_;
    @Shadow
    private ChunkPos f_185933_;
    @Unique
    protected int lambdynlights$luminance = 0;
    @Unique
    private int lambdynlights$lastLuminance = 0;
    @Unique
    private long lambdynlights$lastUpdate = 0L;
    @Unique
    private double lambdynlights$prevX;
    @Unique
    private double lambdynlights$prevY;
    @Unique
    private double lambdynlights$prevZ;
    @Unique
    private LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20188_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Shadow
    public abstract BlockPos m_20183_();

    @Shadow
    public abstract boolean m_213877_();

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract BlockPos m_20097_();

    @Shadow
    public abstract double m_20246_(double var1);

    @Shadow
    public abstract Vec3 m_20182_();

    @Shadow
    public abstract Component m_7755_();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        if (this.f_19853_.f_46443_ && !LightManager.shouldUpdateDynamicLight()) {
            this.lambdynlights$luminance = 0;
        }
        if (this.f_19853_.m_5776_() && LightManager.shouldUpdateDynamicLight()) {
            if (this.m_213877_()) {
                this.setHexereiDynamicLightEnabled(false);
            } else {
                this.dynamicLightTickH();
                LightManager.updateLightTracking(this);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    public void onRemove(CallbackInfo ci) {
        if (this.f_19853_.m_5776_()) {
            this.setHexereiDynamicLightEnabled(false);
        }
    }

    @Inject(method={"onClientRemoval"}, at={@At(value="HEAD")})
    public void removed(CallbackInfo ci) {
        if (this.f_19853_.m_5776_()) {
            this.setHexereiDynamicLightEnabled(false);
            if (this.lambdynlights$luminance > 0) {
                EventQueue.getClientQueue().addEvent(new FadeLightTimedEventHexerei(this.m_9236_(), this.m_20182_(), 8, this.lambdynlights$luminance));
            }
        }
    }

    @Override
    public double getDynamicLightXH() {
        return this.m_20185_();
    }

    @Override
    public double getDynamicLightYH() {
        return this.m_20188_();
    }

    @Override
    public double getDynamicLightZH() {
        return this.m_20189_();
    }

    @Override
    public Level getDynamicLightWorldH() {
        return this.f_19853_;
    }

    @Override
    public void resetDynamicLightH() {
        this.lambdynlights$lastLuminance = 0;
    }

    @Override
    public boolean shouldUpdateDynamicLightH() {
        return LightManager.shouldUpdateDynamicLight() && DynamicLightUtil.couldGiveLight((Entity)this);
    }

    @Override
    public void dynamicLightTickH() {
        this.lambdynlights$luminance = 0;
        int luminance = DynamicLightUtil.lightForEntity((Entity)this);
        if (luminance > this.lambdynlights$luminance) {
            this.lambdynlights$luminance = luminance;
        }
    }

    @Override
    public int getLuminanceH() {
        return this.lambdynlights$luminance;
    }

    @Override
    public boolean lambdynlights$updateDynamicLightH(LevelRenderer renderer) {
        if (!this.shouldUpdateDynamicLightH()) {
            return false;
        }
        double deltaX = this.m_20185_() - this.lambdynlights$prevX;
        double deltaY = this.m_20186_() - this.lambdynlights$prevY;
        double deltaZ = this.m_20189_() - this.lambdynlights$prevZ;
        int luminance = this.getLuminanceH();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.lambdynlights$lastLuminance) {
            this.lambdynlights$prevX = this.m_20185_();
            this.lambdynlights$prevY = this.m_20186_();
            this.lambdynlights$prevZ = this.m_20189_();
            this.lambdynlights$lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                ChunkPos entityChunkPos = this.f_185933_;
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(entityChunkPos.f_45578_, DynamicLightUtil.getSectionCoord(this.m_20188_()), entityChunkPos.f_45579_);
                LightManager.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                LightManager.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                Direction directionX = (this.m_20183_().m_123341_() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (Mth.m_14080_((double)this.m_20188_()) & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.m_20183_().m_123343_() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.m_122173_(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.m_122173_(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.m_122173_(directionX.m_122424_());
                    } else {
                        chunkPos.m_122173_(directionZ.m_122424_());
                        chunkPos.m_122173_(directionY);
                    }
                    LightManager.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                    LightManager.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                }
            }
            this.lambdynlights$scheduleTrackedChunksRebuildH(renderer);
            this.lambdynlights$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void lambdynlights$scheduleTrackedChunksRebuildH(LevelRenderer renderer) {
        if (Minecraft.m_91087_().f_91073_ == this.f_19853_) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LightManager.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

