/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.joefoxe.hexerei.block.custom.ModChest;
import net.joefoxe.hexerei.tileentity.ModChestBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private boolean xmasTextures;
    public static final ResourceLocation WILLOW_CHEST_LOCATION = new ResourceLocation("hexerei", "textures/entity/chest/willow.png");
    public static final ResourceLocation WITCH_HAZEL_CHEST_LOCATION = new ResourceLocation("hexerei", "textures/entity/chest/witch_hazel.png");
    public static final ResourceLocation MAHOGANY_CHEST_LOCATION = new ResourceLocation("hexerei", "textures/entity/chest/mahogany.png");
    public static final ResourceLocation HOOTY_LOCATION = new ResourceLocation("hexerei", "textures/entity/chest/hooty.png");
    public static final ResourceLocation HOOTLE_LOCATION = new ResourceLocation("hexerei", "textures/entity/chest/hootle.png");
    public static final ResourceLocation WILLOW_CHEST_LOCATION_LEFT = new ResourceLocation("hexerei", "textures/entity/chest/willow_left.png");
    public static final ResourceLocation WILLOW_CHEST_LOCATION_RIGHT = new ResourceLocation("hexerei", "textures/entity/chest/willow_right.png");
    public static final ResourceLocation WITCH_HAZEL_CHEST_LOCATION_LEFT = new ResourceLocation("hexerei", "textures/entity/chest/witch_hazel_left.png");
    public static final ResourceLocation WITCH_HAZEL_CHEST_LOCATION_RIGHT = new ResourceLocation("hexerei", "textures/entity/chest/witch_hazel_right.png");
    public static final ResourceLocation MAHOGANY_CHEST_LOCATION_LEFT = new ResourceLocation("hexerei", "textures/entity/chest/mahogany_left.png");
    public static final ResourceLocation MAHOGANY_CHEST_LOCATION_RIGHT = new ResourceLocation("hexerei", "textures/entity/chest/mahogany_right.png");

    public ModChestRenderer(BlockEntityRendererProvider.Context pContext) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart modelpart = pContext.m_173582_(new ModelLayerLocation(new ResourceLocation("hexerei", "chest/mahogany"), "main"));
        this.bottom = modelpart.m_171324_(BOTTOM);
        this.lid = modelpart.m_171324_(LID);
        this.lock = modelpart.m_171324_(LOCK);
        ModelPart modelpart1 = pContext.m_173582_(new ModelLayerLocation(new ResourceLocation("hexerei", "chest/mahogany_left"), "main"));
        this.doubleLeftBottom = modelpart1.m_171324_(BOTTOM);
        this.doubleLeftLid = modelpart1.m_171324_(LID);
        this.doubleLeftLock = modelpart1.m_171324_(LOCK);
        ModelPart modelpart2 = pContext.m_173582_(new ModelLayerLocation(new ResourceLocation("hexerei", "chest/mahogany_right"), "main"));
        this.doubleRightBottom = modelpart2.m_171324_(BOTTOM);
        this.doubleRightLid = modelpart2.m_171324_(LID);
        this.doubleRightLock = modelpart2.m_171324_(LOCK);
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6922_(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? pBlockEntity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            pPoseStack.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            pPoseStack.m_85837_(0.5, 0.5, 0.5);
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            pPoseStack.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.m_5641_(blockstate, level, pBlockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)neighborcombineresult.m_5649_(ChestBlock.m_51517_((LidBlockEntity)((LidBlockEntity)pBlockEntity)))).get(pPartialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(pPackedLight);
            VertexConsumer vertexConsumer = pBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.getLoc(chesttype, (BlockEntity)pBlockEntity)));
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(pPoseStack, vertexConsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, pPackedOverlay);
                } else {
                    this.render(pPoseStack, vertexConsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, pPackedOverlay);
                }
            } else {
                this.render(pPoseStack, vertexConsumer, this.lid, this.lock, this.bottom, f1, i, pPackedOverlay);
            }
            pPoseStack.m_85849_();
        }
    }

    private void render(PoseStack pPoseStack, VertexConsumer pConsumer, ModelPart pLidPart, ModelPart pLockPart, ModelPart pBottomPart, float pLidAngle, int pPackedLight, int pPackedOverlay) {
        pLockPart.f_104203_ = pLidPart.f_104203_ = -(pLidAngle * 1.5707964f);
        pLidPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pLockPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pBottomPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
    }

    protected ResourceLocation getLoc(ChestType chestType, BlockEntity block) {
        if (block instanceof ModChestBlockEntity) {
            ModChestBlockEntity blockEntity = (ModChestBlockEntity)block;
            if (blockEntity.m_8077_() && blockEntity.m_7770_().getString().equals("Hootle") && chestType == ChestType.SINGLE) {
                return HOOTLE_LOCATION;
            }
            if (blockEntity.m_8077_() && blockEntity.m_7770_().getString().equals("Hooty") && chestType == ChestType.SINGLE) {
                return HOOTY_LOCATION;
            }
        }
        ModChest.WoodType style = ModChest.WoodType.WILLOW;
        if (block.m_58900_().m_61138_(ModChest.WOOD_TYPE)) {
            style = (ModChest.WoodType)((Object)block.m_58900_().m_61143_(ModChest.WOOD_TYPE));
        }
        ResourceLocation left = this.getLeft(style);
        ResourceLocation right = this.getRight(style);
        ResourceLocation single = this.getSingle(style);
        return ModChestRenderer.chooseLoc(chestType, single, left, right);
    }

    public ResourceLocation getLeft(ModChest.WoodType style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ModChest.WoodType.MAHOGANY, ModChest.WoodType.POLISHED_MAHOGANY -> MAHOGANY_CHEST_LOCATION_LEFT;
            case ModChest.WoodType.POLISHED_WILLOW, ModChest.WoodType.WILLOW -> WILLOW_CHEST_LOCATION_LEFT;
            case ModChest.WoodType.POLISHED_WITCH_HAZEL, ModChest.WoodType.WITCH_HAZEL -> WITCH_HAZEL_CHEST_LOCATION_LEFT;
        };
    }

    public ResourceLocation getRight(ModChest.WoodType style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ModChest.WoodType.MAHOGANY, ModChest.WoodType.POLISHED_MAHOGANY -> MAHOGANY_CHEST_LOCATION_RIGHT;
            case ModChest.WoodType.POLISHED_WILLOW, ModChest.WoodType.WILLOW -> WILLOW_CHEST_LOCATION_RIGHT;
            case ModChest.WoodType.POLISHED_WITCH_HAZEL, ModChest.WoodType.WITCH_HAZEL -> WITCH_HAZEL_CHEST_LOCATION_RIGHT;
        };
    }

    public ResourceLocation getSingle(ModChest.WoodType style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case ModChest.WoodType.MAHOGANY, ModChest.WoodType.POLISHED_MAHOGANY -> MAHOGANY_CHEST_LOCATION;
            case ModChest.WoodType.POLISHED_WILLOW, ModChest.WoodType.WILLOW -> WILLOW_CHEST_LOCATION;
            case ModChest.WoodType.POLISHED_WITCH_HAZEL, ModChest.WoodType.WITCH_HAZEL -> WITCH_HAZEL_CHEST_LOCATION;
        };
    }

    public static ResourceLocation chooseLoc(ChestType pChestType, ResourceLocation pDoubleMaterial, ResourceLocation pLeftMaterial, ResourceLocation pRightMaterial) {
        return switch (pChestType) {
            case ChestType.LEFT -> pLeftMaterial;
            case ChestType.RIGHT -> pRightMaterial;
            default -> pDoubleMaterial;
        };
    }
}

