/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import net.joefoxe.hexerei.tileentity.ModSignBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModSignRenderer
implements BlockEntityRenderer<ModSignBlockEntity> {
    public static final int MAX_LINE_WIDTH = 90;
    private static final int LINE_HEIGHT = 10;
    private static final String STICK = "stick";
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Map<WoodType, SignModel> signModels = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(p_173645_ -> p_173645_, p_173651_ -> new SignModel(pContext.m_173582_(ModelLayers.m_171291_((WoodType)p_173651_)))));
    private final Font font;

    public ModSignRenderer(BlockEntityRendererProvider.Context pContext) {
        this.font = pContext.m_173586_();
    }

    public void render(ModSignBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        int l;
        boolean flag;
        int k;
        BlockState blockstate = pBlockEntity.m_58900_();
        pPoseStack.m_85836_();
        float f = 0.6666667f;
        WoodType woodtype = ModSignRenderer.getWoodType(blockstate.m_60734_());
        SignModel signrenderer$signmodel = this.signModels.get(woodtype);
        if (blockstate.m_60734_() instanceof StandingSignBlock) {
            pPoseStack.m_85837_(0.5, 0.5, 0.5);
            float f1 = -((float)((Integer)blockstate.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            signrenderer$signmodel.stick.f_104207_ = true;
        } else {
            pPoseStack.m_85837_(0.5, 0.5, 0.5);
            float f4 = -((Direction)blockstate.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_();
            pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(f4));
            pPoseStack.m_85837_(0.0, -0.3125, -0.4375);
            signrenderer$signmodel.stick.f_104207_ = false;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        Material material = Sheets.m_173381_((WoodType)woodtype);
        VertexConsumer vertexconsumer = material.m_119194_(pBufferSource, arg_0 -> ((SignModel)signrenderer$signmodel).m_103119_(arg_0));
        signrenderer$signmodel.root.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
        float f2 = 0.010416667f;
        pPoseStack.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        pPoseStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        int i = ModSignRenderer.getDarkColor(pBlockEntity);
        int j = 20;
        FormattedCharSequence[] aformattedcharsequence = pBlockEntity.m_155717_(Minecraft.m_91087_().m_167974_(), p_173653_ -> {
            List list = this.font.m_92923_((FormattedText)p_173653_, 90);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (pBlockEntity.m_155727_()) {
            k = pBlockEntity.m_59753_().m_41071_();
            flag = ModSignRenderer.isOutlineVisible(pBlockEntity, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = pPackedLight;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f3 = -this.font.m_92724_(formattedcharsequence) / 2;
            if (flag) {
                this.font.m_168645_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, i, pPoseStack.m_85850_().m_85861_(), pBufferSource, l);
                continue;
            }
            this.font.m_92733_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, false, pPoseStack.m_85850_().m_85861_(), pBufferSource, false, 0, l);
        }
        pPoseStack.m_85849_();
    }

    private static boolean isOutlineVisible(ModSignBlockEntity pBlockEntity, int pTextColor) {
        if (pTextColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)pBlockEntity.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static int getDarkColor(ModSignBlockEntity pBlockEntity) {
        int i = pBlockEntity.m_59753_().m_41071_();
        double d0 = 0.4;
        int j = (int)((double)NativeImage.m_85085_((int)i) * 0.4);
        int k = (int)((double)NativeImage.m_85103_((int)i) * 0.4);
        int l = (int)((double)NativeImage.m_85119_((int)i) * 0.4);
        return i == DyeColor.BLACK.m_41071_() && pBlockEntity.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)l, (int)k, (int)j);
    }

    public static WoodType getWoodType(Block pBlock) {
        WoodType woodtype = pBlock instanceof SignBlock ? ((SignBlock)pBlock).m_56297_() : WoodType.f_61830_;
        return woodtype;
    }

    public static SignModel createSignModel(EntityModelSet pEntityModelSet, WoodType pWoodType) {
        return new SignModel(pEntityModelSet.m_171103_(ModelLayers.m_171291_((WoodType)pWoodType)));
    }

    public static LayerDefinition createSignLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), PartPose.f_171404_);
        partdefinition.m_171599_(STICK, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart stick;

        public SignModel(ModelPart pRoot) {
            super(RenderType::m_110458_);
            this.root = pRoot;
            this.stick = pRoot.m_171324_(ModSignRenderer.STICK);
        }

        public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            this.root.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
    }
}

