/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.api.recipes.botania;

import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BlockStateIngredient;
import vazkii.botania.common.crafting.BlocksStateIngredient;
import vazkii.botania.common.crafting.ManaInfusionRecipe;
import vazkii.botania.common.crafting.TagStateIngredient;

public class ManaPoolRecipeBuilder
extends RecipeBuilder<ManaPoolRecipeBuilder, Recipe<?>> {
    private int mana;
    private Ingredient ingredient = Ingredient.f_43901_;
    private StateIngredient catalyst;

    public ManaPoolRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
        super(event);
    }

    public ManaPoolRecipeBuilder mana(int mana) {
        this.mana = mana;
        return this;
    }

    public ManaPoolRecipeBuilder input(Object ingredient) {
        this.ingredient = RecipeHelper.fromComponent((Object)ingredient);
        return this;
    }

    public ManaPoolRecipeBuilder catalyst(Block block) {
        this.catalyst = new BlockStateIngredient(block);
        return this;
    }

    public ManaPoolRecipeBuilder catalyst(Block ... block) {
        this.catalyst = new BlocksStateIngredient(List.of(block));
        return this;
    }

    public ManaPoolRecipeBuilder catalyst(Collection<Block> block) {
        this.catalyst = new BlocksStateIngredient(block);
        return this;
    }

    public ManaPoolRecipeBuilder catalyst(TagKey<Block> tag) {
        this.catalyst = new TagStateIngredient(tag.f_203868_());
        return this;
    }

    public ManaPoolRecipeBuilder catalyst(StateIngredient custom) {
        this.catalyst = custom;
        return this;
    }

    protected void validate() {
        if (this.ingredient.m_43947_()) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " does not have any defined ingredient!");
        }
        super.validate();
    }

    public void register() {
        this.validate();
        ResourceLocation id = this.getIdentifier();
        this.event.register(id, (Object)new ManaInfusionRecipe(id, this.result, this.ingredient, this.mana, this.group, this.catalyst));
    }
}

