/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.init.TilesBA;
import org.zeith.botanicadds.mixins.RunicAltarBlockEntityAccessor;
import org.zeith.botanicadds.util.SparkUtil;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.util.java.Cast;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;

public class TileElvenAltar
extends RunicAltarBlockEntity
implements SparkAttachable {
    private final LazyOptional<SparkAttachable> spark = LazyOptional.of(() -> this);

    public TileElvenAltar(BlockPos pos, BlockState state) {
        super(pos, state);
        BlockAPI.spoofBlockEntityType((BlockEntity)this, TilesBA.ELVEN_ALTAR);
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.getTargetMana() - this.getCurrentMana());
    }

    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            return (ManaSpark)Cast.cast(sparks.get(0));
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return !this.canReceiveManaFromBursts();
    }

    public void receiveMana(int mana) {
        super.receiveMana(mana);
        if (mana != 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeCapabilities.SPARK_ATTACHABLE) {
            return BotaniaForgeCapabilities.SPARK_ATTACHABLE.orEmpty(cap, this.spark);
        }
        return super.getCapability(cap, side);
    }

    public static void serverTickElven(Level level, BlockPos worldPosition, BlockState state, TileElvenAltar self) {
        TileElvenAltar.serverTick((Level)level, (BlockPos)worldPosition, (BlockState)state, (RunicAltarBlockEntity)self);
        if (self.manaToGet > 0) {
            SparkUtil.startRequestingMana((BlockEntity)self, self.getAttachedSpark());
        }
    }

    public static class ElvenHud {
        public static void render(TileElvenAltar altar, PoseStack ms, Minecraft mc) {
            RunicAltarBlockEntityAccessor a;
            int xc = mc.m_91268_().m_85445_() / 2;
            int yc = mc.m_91268_().m_85446_() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().m_8020_(i).m_41619_(); ++i) {
                ++amt;
            }
            if (amt > 0) {
                float anglePer = 360.0f / (float)amt;
                altar.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.RUNE_TYPE, altar.getItemHandler(), altar.f_58857_).ifPresent(recipe -> {
                    RenderSystem.m_69478_();
                    RenderSystem.m_69405_((int)770, (int)771);
                    float progress = (float)altar.getCurrentMana() / (float)altar.manaToGet;
                    progress = Float.isFinite(progress) ? Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f) : 0.0f;
                    RenderSystem.m_157456_((int)0, (ResourceLocation)HUDHandler.manaBar);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.drawTexturedModalRect((PoseStack)ms, (int)(xc + radius + 9), (int)(yc - 8), (int)(progress == 1.0f ? 0 : 22), (int)8, (int)22, (int)15);
                    if (progress == 1.0f) {
                        mc.m_91291_().m_115123_(new ItemStack((ItemLike)BotaniaBlocks.livingrock), xc + radius + 16, yc + 8);
                        PoseStack pose = RenderSystem.m_157191_();
                        pose.m_85836_();
                        pose.m_85837_(0.0, 0.0, 100.0);
                        RenderSystem.m_157182_();
                        ItemStack playerWand = PlayerHelper.getFirstHeldItemClass((LivingEntity)mc.f_91074_, WandOfTheForestItem.class);
                        if (playerWand.m_41619_()) {
                            playerWand = PlayerHelper.getItemClassFromInventory((Player)mc.f_91074_, WandOfTheForestItem.class);
                        }
                        ItemStack wandToRender = playerWand.m_41619_() ? new ItemStack((ItemLike)BotaniaItems.twigWand) : playerWand;
                        mc.m_91291_().m_115123_(wandToRender, xc + radius + 24, yc + 8);
                        pose.m_85849_();
                        RenderSystem.m_157182_();
                    }
                    RenderHelper.renderProgressPie((PoseStack)ms, (int)(xc + radius + 32), (int)(yc - 8), (float)progress, (ItemStack)recipe.m_5874_(altar.getItemHandler()));
                    if (progress == 1.0f) {
                        mc.f_91062_.m_92883_(ms, "+", (float)(xc + radius + 14), (float)(yc + 12), 0xFFFFFF);
                    }
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    PoseStack pose = RenderSystem.m_157191_();
                    pose.m_85836_();
                    pose.m_85837_(xPos, yPos, 0.0);
                    RenderSystem.m_157182_();
                    mc.m_91291_().m_115123_(altar.getItemHandler().m_8020_(i), 0, 0);
                    pose.m_85849_();
                    RenderSystem.m_157182_();
                    angle += anglePer;
                }
            }
            if (altar instanceof RunicAltarBlockEntityAccessor && (a = (RunicAltarBlockEntityAccessor)((Object)altar)).botanicAdditions_recipeKeepTicks() > 0 && altar.canAddLastRecipe()) {
                String s = I18n.m_118938_((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                mc.f_91062_.m_92750_(ms, s, (float)(xc - mc.f_91062_.m_92895_(s) / 2), (float)(yc + 10), 0xFFFFFF);
                s = I18n.m_118938_((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                mc.f_91062_.m_92750_(ms, s, (float)(xc - mc.f_91062_.m_92895_(s) / 2), (float)(yc + 20), 0xFFFFFF);
            }
        }
    }
}

