/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.me.helpers.PlayerSource;
import appeng.menu.locator.MenuLocators;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.curio.CurioLocator;
import de.mari_023.ae2wtlib.networking.ServerNetworkManager;
import de.mari_023.ae2wtlib.networking.s2c.UpdateRestockPacket;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="ae2wtlib")
@Mod.EventBusSubscriber
public class AE2wtlibForge {
    public static final HashMap<String, Item> ITEMS = new HashMap();
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"ae2wtlib");

    public AE2wtlibForge() {
        AE2wtlibConfig.init();
        if (Platform.trinketsPresent()) {
            MenuLocators.register(CurioLocator.class, CurioLocator::writeToPacket, CurioLocator::readFromPacket);
        }
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RECIPES.register(modEventBus);
        modEventBus.addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registry.f_122913_)) {
                AE2wtlib.registerMenus();
            } else if (event.getRegistryKey().equals((Object)Registry.f_122904_)) {
                AE2wtlib.createItems();
                for (Map.Entry<String, Item> entry : ITEMS.entrySet()) {
                    ForgeRegistries.ITEMS.register(entry.getKey(), (Object)entry.getValue());
                }
                AE2wtlib.onAe2Initialized();
            }
        });
    }

    @SubscribeEvent
    public static void handle(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack item = event.getItem();
        if (AE2wtlibForge.restock(player, item, event.getResultStack().m_41613_())) {
            return;
        }
        event.setResultStack(item);
        ServerNetworkManager.sendToClient(player, new UpdateRestockPacket(player.m_150109_().m_36043_(item), item.m_41613_()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handle(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        block5: {
            block4: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)player2;
                if (!event.isCanceled()) break block5;
            }
            return;
        }
        ItemStack item = event.getItemStack();
        if (AE2wtlibForge.restock(player, item, item.m_41613_())) {
            return;
        }
        player.m_21008_(event.getHand(), item);
        ServerNetworkManager.sendToClient(player, new UpdateRestockPacket(player.m_150109_().m_36043_(item), item.m_41613_()));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handle(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(AE2wtlibForge.insertStackInME(event.getItem().m_32055_(), event.getEntity()));
    }

    private static boolean restock(ServerPlayer player, ItemStack item, int count) {
        if (player.m_7500_() || item.m_41619_()) {
            return true;
        }
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)player);
        if (!cTHandler.inRange() || !ItemWT.getBoolean(cTHandler.getCraftingTerminal(), "restock") || cTHandler.getTargetGrid() == null || cTHandler.getTargetGrid().getStorageService() == null) {
            return true;
        }
        int toAdd = item.m_41741_() / 2 - count;
        if (toAdd == 0) {
            return true;
        }
        long changed = toAdd > 0 ? cTHandler.getTargetGrid().getStorageService().getInventory().extract((AEKey)AEItemKey.of((ItemStack)item), (long)toAdd, Actionable.MODULATE, (IActionSource)new PlayerSource((Player)player, cTHandler.getSecurityStation())) : -cTHandler.getTargetGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)item), (long)(-toAdd), Actionable.MODULATE, (IActionSource)new PlayerSource((Player)player, cTHandler.getSecurityStation()));
        item.m_41764_(count + (int)changed);
        return false;
    }

    private static boolean insertStackInME(ItemStack stack, Player player) {
        if (stack.m_41619_()) {
            return false;
        }
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        ItemStack terminal = cTHandler.getCraftingTerminal();
        if (MagnetHandler.getMagnetSettings((ItemStack)terminal).magnetMode != MagnetMode.PICKUP_ME) {
            return false;
        }
        if (!cTHandler.inRange()) {
            return false;
        }
        MagnetHost magnetHost = cTHandler.getMagnetHost();
        if (magnetHost == null) {
            return false;
        }
        if (!magnetHost.getInsertFilter().matchesFilter((AEKey)AEItemKey.of((ItemStack)stack), magnetHost.getInsertMode())) {
            return false;
        }
        if (cTHandler.getTargetGrid() == null) {
            return false;
        }
        if (cTHandler.getTargetGrid().getStorageService() == null) {
            return false;
        }
        long inserted = cTHandler.getTargetGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_(), Actionable.MODULATE, (IActionSource)new PlayerSource(player, null));
        int leftover = (int)((long)stack.m_41613_() - inserted);
        if (leftover == 0) {
            stack.m_41764_(0);
            return true;
        }
        stack.m_41764_(leftover);
        return false;
    }
}

