/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.effects;

import com.mojang.authlib.GameProfile;
import net.acetheeldritchking.art_of_forging.effects.gui.EffectGuiStats;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class BeheadingEffect {
    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        StatGetterEffectLevel effectStatGetter = new StatGetterEffectLevel(EffectGuiStats.beheadingEffect, 1.0);
        GuiStatBar effectBar = new GuiStatBar(0, 0, 59, "art_of_forging.effect.beheading.name", 0.0, 30.0, false, (IStatGetter)effectStatGetter, LabelGetterBasic.percentageLabel, (ITooltipGetter)new TooltipGetterInteger("art_of_forging.effect.beheading.tooltip", (IStatGetter)effectStatGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)effectBar);
        HoloStatsGui.addBar((GuiStatBase)effectBar);
    }

    @SubscribeEvent
    public void onLivingDropEvent(LivingDropsEvent event) {
        LivingEntity attacker;
        ItemStack heldStack;
        Item item;
        LivingEntity target = event.getEntity();
        Entity attackingEntity = event.getSource().m_7639_();
        if (attackingEntity instanceof LivingEntity && (item = (heldStack = (attacker = (LivingEntity)attackingEntity).m_21205_()).m_41720_()) instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            float level = item2.getEffectLevel(heldStack, EffectGuiStats.beheadingEffect);
            float chance = level / 100.0f;
            if (level > 0.0f) {
                ItemStack headDrop = ItemStack.f_41583_;
                if (target instanceof Zombie) {
                    headDrop = new ItemStack((ItemLike)Items.f_42681_);
                } else if (target instanceof Creeper) {
                    headDrop = new ItemStack((ItemLike)Items.f_42682_);
                } else if (target instanceof Skeleton) {
                    headDrop = new ItemStack((ItemLike)Items.f_42678_);
                } else if (target instanceof WitherSkeleton || target instanceof WitherBoss) {
                    headDrop = new ItemStack((ItemLike)Items.f_42679_);
                } else if (target instanceof EnderDragon) {
                    headDrop = new ItemStack((ItemLike)Items.f_42683_);
                } else if (target instanceof Player) {
                    Player player = (Player)target;
                    headDrop = new ItemStack((ItemLike)Items.f_42680_);
                    GameProfile profile = player.m_36316_();
                    headDrop.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile));
                }
                if (!headDrop.m_41619_()) {
                    boolean drop;
                    boolean bl = drop = target.f_19853_.f_46441_.m_188501_() < chance;
                    if (drop) {
                        ItemEntity itemDrop = new ItemEntity(target.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), headDrop);
                        itemDrop.m_32060_();
                        event.getDrops().add(itemDrop);
                    }
                }
            }
        }
    }
}

