/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FilterLogicContainerBase<T extends FilterLogicBase, S extends Slot> {
    private static final String DATA_IS_ALLOW_LIST = "isAllowList";
    private static final String DATA_MATCH_DURABILITY = "matchDurability";
    private static final String DATA_MATCH_NBT = "matchNbt";
    private static final String DATA_PRIMARY_MATCH = "primaryMatch";
    private static final String DATA_ADD_TAG_NAME = "addTagName";
    private static final String DATA_REMOVE_TAG_NAME = "removeTagName";
    private static final String DATA_MATCH_ANY_TAG = "matchAnyTag";
    private static final String DATA_PARENT_TAG_KEY = "parentTagKey";
    protected final List<S> filterSlots = new ArrayList<S>();
    protected final IServerUpdater serverUpdater;
    protected final Supplier<T> filterLogic;
    private final TagSelectionSlot tagSelectionSlot;
    private int selectedTagToAdd = 0;
    private int selectedTagToRemove = 0;
    private final Set<TagKey<Item>> tagsToAdd = new TreeSet<TagKey>(Comparator.comparing(TagKey::f_203868_));

    public FilterLogicContainerBase(IServerUpdater serverUpdater, Supplier<T> filterLogic, Consumer<Slot> addSlot) {
        this.serverUpdater = serverUpdater;
        this.filterLogic = filterLogic;
        this.tagSelectionSlot = new TagSelectionSlot();
        addSlot.accept(this.tagSelectionSlot);
    }

    public int getSelectedTagToAdd() {
        return this.selectedTagToAdd;
    }

    public int getSelectedTagToRemove() {
        return this.selectedTagToRemove;
    }

    public TagSelectionSlot getTagSelectionSlot() {
        return this.tagSelectionSlot;
    }

    public List<S> getFilterSlots() {
        return this.filterSlots;
    }

    public Set<TagKey<Item>> getTagNames() {
        return ((FilterLogicBase)this.filterLogic.get()).getTagKeys();
    }

    public Set<TagKey<Item>> getTagsToAdd() {
        return this.tagsToAdd;
    }

    public void addSelectedTag() {
        this.getTagAtIndex(this.tagsToAdd, this.selectedTagToAdd).ifPresent(tagName -> {
            this.addTagName((TagKey<Item>)tagName);
            this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), DATA_ADD_TAG_NAME, tagName.f_203868_().toString()));
            this.selectedTagToRemove = 0;
            this.tagsToAdd.remove(tagName);
            this.selectedTagToAdd = Math.max(0, this.selectedTagToAdd - 1);
        });
    }

    private void addTagName(TagKey<Item> tagName) {
        ((FilterLogicBase)this.filterLogic.get()).addTag(tagName);
    }

    public void removeSelectedTag() {
        this.getTagAtIndex(this.getTagNames(), this.selectedTagToRemove).ifPresent(tagName -> {
            this.removeSelectedTag((TagKey<Item>)tagName);
            this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), DATA_REMOVE_TAG_NAME, tagName.f_203868_().toString()));
            if (this.tagSelectionSlot.m_7993_().m_204117_(tagName)) {
                this.tagsToAdd.add((TagKey<Item>)tagName);
            }
            this.selectedTagToRemove = Math.max(0, this.selectedTagToRemove - 1);
        });
    }

    private void removeSelectedTag(TagKey<Item> tagName) {
        ((FilterLogicBase)this.filterLogic.get()).removeTagName(tagName);
    }

    public void selectNextTagToRemove() {
        this.selectedTagToRemove = this.getNextIndex(this.getTagNames().size(), this.selectedTagToRemove);
    }

    private int getNextIndex(int colSize, int selectedIndex) {
        return selectedIndex + 1 >= colSize ? 0 : selectedIndex + 1;
    }

    private int getPreviousIndex(int colSize, int selectedIndex) {
        return selectedIndex == 0 ? colSize - 1 : selectedIndex - 1;
    }

    public void selectPreviousTagToRemove() {
        this.selectedTagToRemove = this.getPreviousIndex(this.getTagNames().size(), this.selectedTagToRemove);
    }

    public void selectNextTagToAdd() {
        this.selectedTagToAdd = this.getNextIndex(this.tagsToAdd.size(), this.selectedTagToAdd);
    }

    public void selectPreviousTagToAdd() {
        this.selectedTagToAdd = this.getPreviousIndex(this.tagsToAdd.size(), this.selectedTagToAdd);
    }

    private Optional<TagKey<Item>> getTagAtIndex(Set<TagKey<Item>> col, int index) {
        int curIndex = 0;
        for (TagKey<Item> tagName : col) {
            if (curIndex == index) {
                return Optional.of(tagName);
            }
            ++curIndex;
        }
        return Optional.empty();
    }

    public boolean isAllowList() {
        return ((FilterLogicBase)this.filterLogic.get()).isAllowList();
    }

    public boolean shouldMatchDurability() {
        return ((FilterLogicBase)this.filterLogic.get()).shouldMatchDurability();
    }

    public boolean shouldMatchNbt() {
        return ((FilterLogicBase)this.filterLogic.get()).shouldMatchNbt();
    }

    public PrimaryMatch getPrimaryMatch() {
        return ((FilterLogicBase)this.filterLogic.get()).getPrimaryMatch();
    }

    public boolean shouldMatchAnyTag() {
        return ((FilterLogicBase)this.filterLogic.get()).shouldMatchAnyTag();
    }

    public void setAllowList(boolean isAllowList) {
        ((FilterLogicBase)this.filterLogic.get()).setAllowList(isAllowList);
        this.sendBooleanToServer(DATA_IS_ALLOW_LIST, isAllowList);
    }

    private void sendBooleanToServer(String dataId, boolean value) {
        if (((FilterLogicBase)this.filterLogic.get()).getParentTagKey().isEmpty()) {
            this.serverUpdater.sendBooleanToServer(dataId, value);
        } else {
            this.serverUpdater.sendDataToServer(() -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128379_(dataId, value);
                tag.m_128359_(DATA_PARENT_TAG_KEY, ((FilterLogicBase)this.filterLogic.get()).getParentTagKey());
                return tag;
            });
        }
    }

    protected void sendDataToServer(Supplier<CompoundTag> dataSupplier) {
        if (((FilterLogicBase)this.filterLogic.get()).getParentTagKey().isEmpty()) {
            this.serverUpdater.sendDataToServer(dataSupplier);
        } else {
            this.serverUpdater.sendDataToServer(() -> {
                CompoundTag tag = (CompoundTag)dataSupplier.get();
                tag.m_128359_(DATA_PARENT_TAG_KEY, ((FilterLogicBase)this.filterLogic.get()).getParentTagKey());
                return tag;
            });
        }
    }

    public void setMatchDurability(boolean matchDurability) {
        ((FilterLogicBase)this.filterLogic.get()).setMatchDurability(matchDurability);
        this.sendBooleanToServer(DATA_MATCH_DURABILITY, matchDurability);
    }

    public void setMatchNbt(boolean matchNbt) {
        ((FilterLogicBase)this.filterLogic.get()).setMatchNbt(matchNbt);
        this.sendBooleanToServer(DATA_MATCH_NBT, matchNbt);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        ((FilterLogicBase)this.filterLogic.get()).setPrimaryMatch(primaryMatch);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundTag(), DATA_PRIMARY_MATCH, primaryMatch));
    }

    public void setMatchAnyTag(boolean matchAnyTag) {
        ((FilterLogicBase)this.filterLogic.get()).setMatchAnyTag(matchAnyTag);
        this.sendBooleanToServer(DATA_MATCH_ANY_TAG, matchAnyTag);
    }

    public boolean handleMessage(CompoundTag data) {
        if (this.isDifferentFilterLogicsData(data)) {
            return false;
        }
        Iterator iterator = data.m_128431_().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "isAllowList": {
                    this.setAllowList(data.m_128471_(DATA_IS_ALLOW_LIST));
                    return true;
                }
                case "matchDurability": {
                    this.setMatchDurability(data.m_128471_(DATA_MATCH_DURABILITY));
                    return true;
                }
                case "matchNbt": {
                    this.setMatchNbt(data.m_128471_(DATA_MATCH_NBT));
                    return true;
                }
                case "primaryMatch": {
                    this.setPrimaryMatch(PrimaryMatch.fromName(data.m_128461_(DATA_PRIMARY_MATCH)));
                    return true;
                }
                case "addTagName": {
                    this.addTagName((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(data.m_128461_(DATA_ADD_TAG_NAME))));
                    return true;
                }
                case "removeTagName": {
                    this.removeSelectedTag((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(data.m_128461_(DATA_REMOVE_TAG_NAME))));
                    return true;
                }
                case "matchAnyTag": {
                    this.setMatchAnyTag(data.m_128471_(DATA_MATCH_ANY_TAG));
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isDifferentFilterLogicsData(CompoundTag data) {
        return data.m_128441_(DATA_PARENT_TAG_KEY) && !((FilterLogicBase)this.filterLogic.get()).getParentTagKey().equals(data.m_128461_(DATA_PARENT_TAG_KEY));
    }

    public class TagSelectionSlot
    extends Slot
    implements IFilterSlot {
        private ItemStack stack;
        private Runnable onUpdate;

        public TagSelectionSlot() {
            super((Container)new SimpleContainer(0), 0, -1, -1);
            this.stack = ItemStack.f_41583_;
            this.onUpdate = () -> {};
        }

        public void setOnUpdate(Runnable onUpdate) {
            this.onUpdate = onUpdate;
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41619_() || stack.m_204131_().findAny().isPresent();
        }

        public boolean m_8010_(Player pPlayer) {
            return false;
        }

        public ItemStack m_7993_() {
            return this.stack;
        }

        public int m_6641_() {
            return 1;
        }

        public ItemStack m_6201_(int pAmount) {
            this.stack = ItemStack.f_41583_;
            return this.stack;
        }

        public boolean isSameInventory(Slot other) {
            return false;
        }

        public void m_5852_(ItemStack stack) {
            this.stack = stack;
            FilterLogicContainerBase.this.tagsToAdd.clear();
            FilterLogicContainerBase.this.tagsToAdd.addAll(stack.m_204131_().toList());
            FilterLogicContainerBase.this.getTagNames().forEach(FilterLogicContainerBase.this.tagsToAdd::remove);
            FilterLogicContainerBase.this.selectedTagToAdd = 0;
            this.onUpdate.run();
        }

        public void m_219996_(ItemStack stack) {
            this.m_5852_(stack);
        }

        public void m_6654_() {
        }
    }
}

