/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.casting.actions.spells.gates;

import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.OperatorUtils;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.mishaps.MishapLocationTooFarAway;
import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.common.network.MsgBlinkAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.spell.VarargSpellAction;
import ram.talia.hexal.api.spell.iota.GateIota;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J@\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0018\u00010\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0018"}, d2={"Lram/talia/hexal/common/casting/actions/spells/gates/OpCloseGate;", "Lram/talia/hexal/api/spell/VarargSpellAction;", "()V", "argc", "", "stack", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "teleportRespectSticky", "", "teleportee", "Lnet/minecraft/world/entity/Entity;", "allTeleportees", "", "delta", "Lnet/minecraft/world/phys/Vec3;", "Spell", "hexal-forge-1.19.2"})
public final class OpCloseGate
implements VarargSpellAction {
    @NotNull
    public static final OpCloseGate INSTANCE = new OpCloseGate();

    private OpCloseGate() {
    }

    @Override
    public int argc(@NotNull List<? extends Iota> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        if (stack.isEmpty()) {
            return 1;
        }
        Iota top = stack.get(0);
        if (top instanceof GateIota && !((GateIota)top).isDrifting()) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends Iota> args, int argc, @NotNull CastingContext ctx) {
        void $this$mapTo$iv$iv;
        Iterable element$iv2;
        Vec3 vec3;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GateIota gate = OperatorUtilsKt.getGate(args, 0, argc);
        if (gate.isDrifting()) {
            vec3 = OperatorUtils.getVec3(args, (int)1, (int)argc);
        } else {
            vec3 = gate.getTargetPos(ctx.getWorld());
            if (vec3 == null) {
                return null;
            }
        }
        Vec3 targetPos = vec3;
        if (gate.isDrifting()) {
            ctx.assertVecInRange(targetPos);
        }
        Vec3 vec32 = targetPos.m_82492_(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"targetPos.subtract(0.0, 1.0, 0.0)");
        if (!ctx.isVecInWorld(vec32)) {
            throw new MishapLocationTooFarAway(targetPos, "too_close_to_out");
        }
        Set<Entity> gatees = gate.getMarked(ctx.getWorld());
        gate.clearMarked();
        int cost = HexalConfig.getServer().getCloseGateCost();
        if (gate.isDrifting()) {
            void $this$fold$iv;
            Intrinsics.checkNotNullExpressionValue(gatees, (String)"gatees");
            Iterable iterable = gatees;
            int initial$iv = cost;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Iterable element$iv2 : $this$fold$iv) {
                void gatee;
                Entity entity = (Entity)element$iv2;
                int cumCost = accumulator$iv;
                boolean bl = false;
                accumulator$iv = cumCost + (int)((double)HexalConfig.getServer().getCloseGateDistanceCostFactor() * gatee.m_20182_().m_82554_(targetPos));
            }
            cost = accumulator$iv;
        }
        double meanEyeHeight = 0.0;
        Intrinsics.checkNotNullExpressionValue(gatees, (String)"gatees");
        Iterable $this$map$iv = gatees;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            meanEyeHeight += (double)it.m_20192_();
            Vec3 vec33 = it.m_20182_().m_82520_(0.0, (double)it.m_20192_() / 2.0, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"it.position().add(0.0, it.eyeHeight / 2.0, 0.0)");
            collection.add(ParticleSpray.Companion.cloud$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec33, (double)2.0, (int)0, (int)4, null));
        }
        List burst = TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
        Vec3 vec34 = targetPos.m_82520_(0.0, (meanEyeHeight /= (double)burst.size()) / 2.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"targetPos.add(0.0, meanEyeHeight / 2.0, 0.0)");
        burst.add(ParticleSpray.Companion.burst$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec34, (double)2.0, (int)0, (int)4, null));
        return new Triple((Object)new Spell(gatees, targetPos, gate.isDrifting()), (Object)cost, (Object)burst);
    }

    /*
     * WARNING - void declaration
     */
    public final void teleportRespectSticky(@NotNull Entity teleportee, @NotNull Set<? extends Entity> allTeleportees, @NotNull Vec3 delta) {
        boolean cannotSticky;
        boolean sticky;
        boolean allGated;
        Iterable indirect;
        List playersToUpdate;
        Entity base;
        block19: {
            boolean bl;
            block18: {
                boolean bl2;
                block17: {
                    Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
                    Intrinsics.checkNotNullParameter(allTeleportees, (String)"allTeleportees");
                    Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
                    base = teleportee.m_20201_();
                    playersToUpdate = new ArrayList();
                    indirect = base.m_146897_();
                    Intrinsics.checkNotNullExpressionValue((Object)indirect, (String)"indirect");
                    Iterable $this$all$iv = indirect;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            Entity it = (Entity)element$iv;
                            boolean bl3 = false;
                            if (allTeleportees.contains(it)) continue;
                            bl2 = false;
                            break block17;
                        }
                        bl2 = true;
                    }
                }
                allGated = bl2;
                Iterable $this$any$iv = indirect;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl4 = false;
                        if (!it.m_6095_().m_204039_(HexTags.Entities.STICKY_TELEPORTERS)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            sticky = bl;
            Iterable $this$none$iv = indirect;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl5 = false;
                    if (!it.m_6095_().m_204039_(HexTags.Entities.CANNOT_TELEPORT)) continue;
                    v2 = false;
                    break block19;
                }
                v2 = cannotSticky = true;
            }
        }
        if (sticky && cannotSticky) {
            return;
        }
        if (cannotSticky || !allGated) {
            teleportee.m_8127_();
            List list = teleportee.m_20197_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"teleportee.passengers");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity p0 = (Entity)element$iv;
                boolean bl = false;
                p0.m_8127_();
            }
            teleportee.m_146884_(teleportee.m_20182_().m_82549_(delta));
            if (teleportee instanceof ServerPlayer) {
                playersToUpdate.add(teleportee);
            }
        } else {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Vec3 target = base.m_20182_().m_82549_(delta);
            base.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
            Iterable $i$f$forEach = indirect;
            boolean $i$f$filterIsInstance = false;
            void element$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ServerPlayer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ServerPlayer p0 = (ServerPlayer)element$iv2;
                boolean bl = false;
                playersToUpdate.add(p0);
            }
        }
        for (ServerPlayer player : playersToUpdate) {
            player.f_8906_.m_9953_();
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, (IMessage)new MsgBlinkAck(delta));
        }
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        return VarargSpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return VarargSpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        return VarargSpellAction.DefaultImpls.operate(this, continuation, stack, ravenmind, ctx);
    }

    public boolean getAlwaysProcessGreatSpell() {
        return VarargSpellAction.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    public boolean getCausesBlindDiversion() {
        return VarargSpellAction.DefaultImpls.getCausesBlindDiversion(this);
    }

    @NotNull
    public Component getDisplayName() {
        return VarargSpellAction.DefaultImpls.getDisplayName(this);
    }

    public boolean isGreat() {
        return VarargSpellAction.DefaultImpls.isGreat(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J-\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J,\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lram/talia/hexal/common/casting/actions/spells/gates/OpCloseGate$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "gatees", "", "Lnet/minecraft/world/entity/Entity;", "targetPos", "Lnet/minecraft/world/phys/Vec3;", "dropItems", "", "(Ljava/util/Set;Lnet/minecraft/world/phys/Vec3;Z)V", "getDropItems", "()Z", "getGatees", "()Ljava/util/Set;", "getTargetPos", "()Lnet/minecraft/world/phys/Vec3;", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "teleport", "teleportee", "allTeleportees", "delta", "toString", "", "hexal-forge-1.19.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Set<Entity> gatees;
        @NotNull
        private final Vec3 targetPos;
        private final boolean dropItems;

        public Spell(@NotNull Set<? extends Entity> gatees, @NotNull Vec3 targetPos, boolean dropItems) {
            Intrinsics.checkNotNullParameter(gatees, (String)"gatees");
            Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
            this.gatees = gatees;
            this.targetPos = targetPos;
            this.dropItems = dropItems;
        }

        @NotNull
        public final Set<Entity> getGatees() {
            return this.gatees;
        }

        @NotNull
        public final Vec3 getTargetPos() {
            return this.targetPos;
        }

        public final boolean getDropItems() {
            return this.dropItems;
        }

        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            for (Entity gatee : this.gatees) {
                Vec3 vec3 = gatee.m_20182_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"gatee.position()");
                this.teleport(gatee, this.gatees, OperatorUtilsKt.minus(this.targetPos, vec3), ctx);
            }
        }

        public final void teleport(@NotNull Entity teleportee, @NotNull Set<? extends Entity> allTeleportees, @NotNull Vec3 delta, @NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
            Intrinsics.checkNotNullParameter(allTeleportees, (String)"allTeleportees");
            Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            double distance = delta.m_82553_();
            if (distance < 32768.0) {
                INSTANCE.teleportRespectSticky(teleportee, allTeleportees, delta);
            }
            if (teleportee instanceof ServerPlayer && Intrinsics.areEqual((Object)teleportee, (Object)ctx.getCaster()) && distance < 32.0 && this.dropItems) {
                double baseDropChance = distance / 10000.0;
                for (ItemStack armorItem : ((ServerPlayer)teleportee).m_150109_().f_35975_) {
                    if (EnchantmentHelper.m_44920_((ItemStack)armorItem) || !(Math.random() < baseDropChance * 0.25)) continue;
                    ((ServerPlayer)teleportee).m_7197_(armorItem.m_41777_(), true, false);
                    armorItem.m_41774_(armorItem.m_41613_());
                }
                Iterator iterator = ((ServerPlayer)teleportee).m_150109_().f_35974_.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    double dropChance;
                    int pos2 = n++;
                    ItemStack invItem = (ItemStack)iterator.next();
                    if (Intrinsics.areEqual((Object)invItem, (Object)((ServerPlayer)teleportee).m_21205_())) continue;
                    double d = dropChance = pos2 < 9 ? baseDropChance * 0.5 : baseDropChance;
                    if (!(Math.random() < dropChance)) continue;
                    ((ServerPlayer)teleportee).m_7197_(invItem.m_41777_(), true, false);
                    invItem.m_41774_(invItem.m_41613_());
                }
            }
        }

        @NotNull
        public final Set<Entity> component1() {
            return this.gatees;
        }

        @NotNull
        public final Vec3 component2() {
            return this.targetPos;
        }

        public final boolean component3() {
            return this.dropItems;
        }

        @NotNull
        public final Spell copy(@NotNull Set<? extends Entity> gatees, @NotNull Vec3 targetPos, boolean dropItems) {
            Intrinsics.checkNotNullParameter(gatees, (String)"gatees");
            Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
            return new Spell(gatees, targetPos, dropItems);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Set set, Vec3 vec3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                set = spell.gatees;
            }
            if ((n & 2) != 0) {
                vec3 = spell.targetPos;
            }
            if ((n & 4) != 0) {
                bl = spell.dropItems;
            }
            return spell.copy(set, vec3, bl);
        }

        @NotNull
        public String toString() {
            return "Spell(gatees=" + this.gatees + ", targetPos=" + this.targetPos + ", dropItems=" + this.dropItems + ")";
        }

        public int hashCode() {
            int result = ((Object)this.gatees).hashCode();
            result = result * 31 + this.targetPos.hashCode();
            int n = this.dropItems ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual(this.gatees, spell.gatees)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.targetPos, (Object)spell.targetPos)) {
                return false;
            }
            return this.dropItems == spell.dropItems;
        }
    }
}

