/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.casting.actions.spells.motes;

import at.petrak.hexcasting.api.spell.Action;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.casting.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.spell.iota.EntityIota;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.spell.mishaps.MishapNotEnoughArgs;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.mediafieditems.MediafiedItemManager;
import ram.talia.hexal.api.spell.casting.IMixinCastingContext;
import ram.talia.hexal.api.spell.iota.MoteIota;
import ram.talia.hexal.api.spell.mishaps.MishapNoBoundStorage;
import ram.talia.hexal.api.spell.mishaps.MishapStorageFull;
import ram.talia.hexal.common.casting.actions.spells.motes.OpMakeMote;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lram/talia/hexal/common/casting/actions/spells/motes/OpMakeMote;", "Lat/petrak/hexcasting/api/spell/Action;", "()V", "mediaCost", "", "getMediaCost", "()I", "argc", "stack", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "operate", "Lat/petrak/hexcasting/api/spell/OperationResult;", "continuation", "Lat/petrak/hexcasting/api/spell/casting/eval/SpellContinuation;", "", "ravenmind", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "Spell", "hexal-forge-1.19.2"})
public final class OpMakeMote
implements Action {
    @NotNull
    public static final OpMakeMote INSTANCE = new OpMakeMote();

    private OpMakeMote() {
    }

    public final int argc(@NotNull List<? extends Iota> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        if (stack.isEmpty()) {
            return 1;
        }
        Iota top = stack.get(0);
        if (top instanceof EntityIota) {
            return 1;
        }
        return 2;
    }

    private final int getMediaCost() {
        return HexalConfig.getServer().getMakeItemCost();
    }

    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        MoteIota mote;
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        int argc = this.argc(CollectionsKt.reversed((Iterable)stack));
        if (argc > stack.size()) {
            throw new MishapNotEnoughArgs(argc, stack.size());
        }
        List args = CollectionsKt.takeLast(stack, (int)argc);
        int n = 0;
        while (n < argc) {
            int it = n++;
            boolean bl = false;
            CollectionsKt.removeLast(stack);
        }
        Either<ItemEntity, ItemFrame> iEntityEither = OperatorUtilsKt.getItemEntityOrItemFrame(args, 0, argc);
        Entity iEntity2 = (Entity)iEntityEither.map(arg_0 -> OpMakeMote.operate$lambda$1(operate.iEntity.1.INSTANCE, arg_0), arg_0 -> OpMakeMote.operate$lambda$2(operate.iEntity.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iEntity2, (String)"iEntity");
        ctx.assertEntityInRange(iEntity2);
        ItemStack itemStack2 = (ItemStack)iEntityEither.map(arg_0 -> OpMakeMote.operate$lambda$3(operate.itemStack.1.INSTANCE, arg_0), arg_0 -> OpMakeMote.operate$lambda$4(operate.itemStack.2.INSTANCE, arg_0));
        MoteIota moteIota = mote = argc == 2 ? OperatorUtilsKt.getMote(args, 1, argc) : null;
        if (!itemStack2.m_41619_()) {
            if (mote != null) {
                if (!mote.typeMatches(itemStack2)) {
                    throw MishapInvalidIota.Companion.of((Iota)mote, 0, "cant_combine_motes", new Object[0]);
                }
                int countRemaining = mote.absorb(itemStack2);
                if (countRemaining == 0) {
                    iEntityEither.map(arg_0 -> OpMakeMote.operate$lambda$5(operate.2.INSTANCE, arg_0), arg_0 -> OpMakeMote.operate$lambda$6(operate.3.INSTANCE, arg_0));
                } else {
                    iEntityEither.map(arg_0 -> OpMakeMote.operate$lambda$7((Function1)new Function1<ItemEntity, Unit>(countRemaining){
                        final /* synthetic */ int $countRemaining;
                        {
                            this.$countRemaining = $countRemaining;
                            super(1);
                        }

                        public final void invoke(ItemEntity it) {
                            it.m_32055_().m_41764_(this.$countRemaining);
                        }
                    }, arg_0), arg_0 -> OpMakeMote.operate$lambda$8((Function1)new Function1<ItemFrame, Unit>(countRemaining){
                        final /* synthetic */ int $countRemaining;
                        {
                            this.$countRemaining = $countRemaining;
                            super(1);
                        }

                        public final void invoke(ItemFrame it) {
                            it.m_31822_().m_41764_(this.$countRemaining);
                        }
                    }, arg_0));
                }
                stack.add(mote);
            } else {
                UUID uUID = ((IMixinCastingContext)ctx).getBoundStorage();
                if (uUID == null) {
                    Vec3 vec3 = iEntity2.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"iEntity.position()");
                    throw new MishapNoBoundStorage(vec3, null, 2, null);
                }
                UUID storage = uUID;
                if (!MediafiedItemManager.isStorageLoaded(storage)) {
                    Vec3 vec3 = iEntity2.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"iEntity.position()");
                    throw new MishapNoBoundStorage(vec3, "storage_unloaded");
                }
                if (!Intrinsics.areEqual((Object)MediafiedItemManager.isStorageFull(storage), (Object)false)) {
                    Vec3 vec3 = iEntity2.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"iEntity.position()");
                    throw new MishapStorageFull(vec3);
                }
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"itemStack");
                Iota itemIota = OperatorUtilsKt.asActionResult(itemStack2, storage).get(0);
                if (!(itemIota instanceof NullIota)) {
                    iEntityEither.map(arg_0 -> OpMakeMote.operate$lambda$9(operate.6.INSTANCE, arg_0), arg_0 -> OpMakeMote.operate$lambda$10(operate.7.INSTANCE, arg_0));
                }
                stack.add(itemIota);
            }
        }
        Object[] objectArray = new OperatorSideEffect[3];
        objectArray[0] = (OperatorSideEffect)new OperatorSideEffect.ConsumeMedia(this.getMediaCost());
        objectArray[1] = (OperatorSideEffect)new OperatorSideEffect.AttemptSpell((RenderedSpell)Spell.INSTANCE, true, true);
        Vec3 vec3 = iEntity2.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"iEntity.position()");
        objectArray[2] = (OperatorSideEffect)new OperatorSideEffect.Particles(ParticleSpray.Companion.burst$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec3, (double)0.4, (int)0, (int)4, null));
        List sideEffects = CollectionsKt.mutableListOf((Object[])objectArray);
        return new OperationResult(continuation, stack, ravenmind, sideEffects);
    }

    public boolean getAlwaysProcessGreatSpell() {
        return Action.DefaultImpls.getAlwaysProcessGreatSpell((Action)this);
    }

    public boolean getCausesBlindDiversion() {
        return Action.DefaultImpls.getCausesBlindDiversion((Action)this);
    }

    @NotNull
    public Component getDisplayName() {
        return Action.DefaultImpls.getDisplayName((Action)this);
    }

    public boolean isGreat() {
        return Action.DefaultImpls.isGreat((Action)this);
    }

    private static final Entity operate$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Entity)$tmp0.invoke(p0);
    }

    private static final Entity operate$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Entity)$tmp0.invoke(p0);
    }

    private static final ItemStack operate$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ItemStack)$tmp0.invoke(p0);
    }

    private static final ItemStack operate$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ItemStack)$tmp0.invoke(p0);
    }

    private static final Unit operate$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit operate$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit operate$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit operate$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit operate$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit operate$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lram/talia/hexal/common/casting/actions/spells/motes/OpMakeMote$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "()V", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "hexal-forge-1.19.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        public static final Spell INSTANCE = new Spell();

        private Spell() {
        }

        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        }
    }
}

