/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookAdvancementCondition
extends BookCondition {
    protected ResourceLocation advancementId;

    public BookAdvancementCondition(Component component, ResourceLocation advancementId) {
        super(component);
        this.advancementId = advancementId;
    }

    public static BookAdvancementCondition fromJson(JsonObject json) {
        ResourceLocation advancementId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"advancement_id"));
        MutableComponent tooltip = Component.m_237110_((String)"tooltip.modonomicon..condition.advancement", (Object[])new Object[]{"advancements." + advancementId.toString().replace(":", ".") + ".title"});
        if (json.has("tooltip")) {
            tooltip = BookAdvancementCondition.tooltipFromJson(json);
        }
        return new BookAdvancementCondition((Component)tooltip, advancementId);
    }

    public static BookAdvancementCondition fromNetwork(FriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? buffer.m_130238_() : null;
        ResourceLocation advancementId = buffer.m_130281_();
        return new BookAdvancementCondition(tooltip, advancementId);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.ADVANCEMENT;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.m_130083_(this.tooltip);
        }
        buffer.m_130085_(this.advancementId);
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement advancement = serverPlayer.m_20194_().m_129889_().m_136041_(this.advancementId);
            return advancement != null && serverPlayer.m_8960_().m_135996_(advancement).m_8193_();
        }
        return false;
    }
}

