/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.capability.BookStateCapability;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import com.klikli_dev.modonomicon.capability.bookstate.BookState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookCategoryScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookSearchScreen;
import com.klikli_dev.modonomicon.client.gui.book.EntryConnectionRenderer;
import com.klikli_dev.modonomicon.client.gui.book.button.CategoryButton;
import com.klikli_dev.modonomicon.client.gui.book.button.ReadAllButton;
import com.klikli_dev.modonomicon.client.gui.book.button.SearchButton;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.network.messages.ClickReadAllButtonMessage;
import com.klikli_dev.modonomicon.network.messages.SaveBookStateMessage;
import com.klikli_dev.modonomicon.network.messages.SyncBookUnlockCapabilityMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.gui.ScreenUtils;
import org.jetbrains.annotations.Nullable;

public class BookOverviewScreen
extends Screen {
    private final Book book;
    private final EntryConnectionRenderer connectionRenderer = new EntryConnectionRenderer();
    private final List<BookCategory> categories;
    private final List<BookCategoryScreen> categoryScreens;
    private final int frameThicknessW = 14;
    private final int frameThicknessH = 14;
    private int currentCategory = 0;
    private boolean hasUnreadEntries;
    private boolean hasUnreadUnlockedEntries;

    public BookOverviewScreen(Book book) {
        super((Component)Component.m_237113_((String)""));
        this.f_96541_ = Minecraft.m_91087_();
        this.book = book;
        this.categories = book.getCategoriesSorted();
        this.categoryScreens = this.categories.stream().map(c -> new BookCategoryScreen(this, (BookCategory)c)).toList();
    }

    public void onDisplay() {
        this.loadBookState();
        this.updateUnreadEntriesState();
        BookCategoryScreen currentScreen = this.categoryScreens.get(this.currentCategory);
        currentScreen.onDisplay();
    }

    protected void updateUnreadEntriesState() {
        this.hasUnreadEntries = this.book.getEntries().values().stream().anyMatch(e -> !BookUnlockCapability.isReadFor((Player)this.f_96541_.f_91074_, e));
        this.hasUnreadUnlockedEntries = this.book.getEntries().values().stream().anyMatch(e -> BookUnlockCapability.isUnlockedFor((Player)this.f_96541_.f_91074_, e) && !BookUnlockCapability.isReadFor((Player)this.f_96541_.f_91074_, e));
    }

    public EntryConnectionRenderer getConnectionRenderer() {
        return this.connectionRenderer;
    }

    public BookCategoryScreen getCurrentCategoryScreen() {
        return this.categoryScreens.get(this.currentCategory);
    }

    public int getCurrentCategory() {
        return this.currentCategory;
    }

    public Book getBook() {
        return this.book;
    }

    public ResourceLocation getBookOverviewTexture() {
        return this.book.getBookOverviewTexture();
    }

    public int getInnerX() {
        int n = (this.f_96543_ - this.getFrameWidth()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerY() {
        int n = (this.f_96544_ - this.getFrameHeight()) / 2;
        Objects.requireNonNull(this);
        return n + 14 / 2;
    }

    public int getInnerWidth() {
        int n = this.getFrameWidth();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getInnerHeight() {
        int n = this.getFrameHeight();
        Objects.requireNonNull(this);
        return n - 14;
    }

    public int getFrameThicknessW() {
        Objects.requireNonNull(this);
        return 14;
    }

    public int getFrameThicknessH() {
        Objects.requireNonNull(this);
        return 14;
    }

    public void changeCategory(BookCategory category) {
        int index = this.categories.indexOf(category);
        if (index != -1) {
            this.changeCategory(index);
        } else {
            Modonomicon.LOGGER.warn("Tried to change to a category ({}) that does not exist in this book ({}).", (Object)this.book.getId(), (Object)category.getId());
        }
    }

    public void changeCategory(int categoryIndex) {
        int oldIndex = this.currentCategory;
        this.currentCategory = categoryIndex;
        this.onCategoryChanged(oldIndex, this.currentCategory);
    }

    public void onCategoryChanged(int oldIndex, int newIndex) {
        BookCategoryScreen oldScreen = this.categoryScreens.get(oldIndex);
        oldScreen.onClose();
        BookCategoryScreen newScreen = this.categoryScreens.get(newIndex);
        newScreen.onDisplay();
    }

    protected int getFrameWidth() {
        return this.f_96543_ - 60;
    }

    protected int getFrameHeight() {
        return this.f_96544_ - 20;
    }

    protected void renderFrame(PoseStack poseStack) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.book.getFrameTexture());
        int width = this.getFrameWidth();
        int height = this.getFrameHeight();
        int x = (this.f_96543_ - width) / 2;
        int y = (this.f_96544_ - height) / 2;
        int blitOffset = this.m_93252_();
        ScreenUtils.blitWithBorder((PoseStack)poseStack, (int)x, (int)y, (int)0, (int)0, (int)width, (int)height, (int)140, (int)140, (int)50, (int)50, (int)50, (int)50, (float)blitOffset);
        this.renderFrameOverlay(this.book.getTopFrameOverlay(), x + width / 2, y, blitOffset);
        this.renderFrameOverlay(this.book.getBottomFrameOverlay(), x + width / 2, y + height, blitOffset);
        this.renderFrameOverlay(this.book.getLeftFrameOverlay(), x, y + height / 2, blitOffset);
        this.renderFrameOverlay(this.book.getRightFrameOverlay(), x + width, y + height / 2, blitOffset);
    }

    protected void renderFrameOverlay(BookFrameOverlay overlay, int x, int y, int blitOffset) {
        if (overlay.getFrameWidth() > 0 && overlay.getFrameHeight() > 0) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)overlay.getTexture());
            ScreenUtils.drawTexturedModalRect((PoseStack)new PoseStack(), (int)overlay.getFrameX(x), (int)overlay.getFrameY(y), (int)overlay.getFrameU(), (int)overlay.getFrameV(), (int)overlay.getFrameWidth(), (int)overlay.getFrameHeight(), (float)blitOffset);
        }
    }

    protected void onBookCategoryButtonClick(CategoryButton button) {
        this.changeCategory(button.getCategoryIndex());
    }

    protected void onBookCategoryButtonTooltip(CategoryButton button, PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)button.getCategory().getName()), pMouseX, pMouseY);
    }

    protected void onReadAllButtonClick(ReadAllButton button) {
        if (this.hasUnreadUnlockedEntries && !Screen.m_96638_()) {
            Networking.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), false));
            this.hasUnreadUnlockedEntries = false;
        } else if (this.hasUnreadEntries && Screen.m_96638_()) {
            Networking.sendToServer(new ClickReadAllButtonMessage(this.book.getId(), true));
            this.hasUnreadEntries = false;
        }
    }

    protected void onReadAllButtonTooltip(ReadAllButton button, PoseStack poseStack, int mouseX, int mouseY) {
        this.m_96617_(poseStack, button.getTooltips().stream().map(MutableComponent::m_7532_).toList(), mouseX, mouseY);
    }

    protected boolean canSeeReadAllButton() {
        return this.hasUnreadEntries || this.hasUnreadUnlockedEntries;
    }

    private void loadBookState() {
        BookCategory openCategory;
        BookState state = BookStateCapability.getBookStateFor((Player)this.f_96541_.f_91074_, this.book);
        if (state != null && state.openCategory != null && (openCategory = this.book.getCategory(state.openCategory)) != null) {
            this.currentCategory = this.categories.indexOf(openCategory);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.getCurrentCategoryScreen().mouseClicked(pMouseX, pMouseY, pButton);
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.getCurrentCategoryScreen().mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.getCurrentCategoryScreen().zoom(pDelta);
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.m_69465_();
        this.m_7333_(pPoseStack);
        this.getCurrentCategoryScreen().renderBackground(pPoseStack);
        this.getCurrentCategoryScreen().render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderFrame(pPoseStack);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.getCurrentCategoryScreen().onClose();
        Networking.sendToServer(new SaveBookStateMessage(this.book, this.getCurrentCategoryScreen().getCategory().getId()));
        BookGuiManager.get().resetHistory();
        BookGuiManager.get().openOverviewScreen = null;
        super.m_7379_();
    }

    public boolean m_5561_(@Nullable Style pStyle) {
        return super.m_5561_(pStyle);
    }

    public void onSyncBookUnlockCapabilityMessage(SyncBookUnlockCapabilityMessage message) {
        this.m_232761_();
        this.updateUnreadEntriesState();
    }

    protected void m_7856_() {
        super.m_7856_();
        BookGuiManager.get().openOverviewScreen = this;
        int buttonXOffset = -11;
        int buttonYOffset = 30 + this.getBook().getCategoryButtonYOffset();
        int buttonX = (this.f_96543_ - this.getFrameWidth()) / 2 - this.getFrameThicknessW() + buttonXOffset;
        int buttonY = (this.f_96544_ - this.getFrameHeight()) / 2 - this.getFrameThicknessH() + buttonYOffset;
        int buttonWidth = (this.f_96543_ - this.getFrameWidth()) / 2 + buttonXOffset + 6;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonCount = 0;
        int size = this.categories.size();
        for (int i = 0; i < size; ++i) {
            if (!this.categories.get(i).showCategoryButton() || !BookUnlockCapability.isUnlockedFor((Player)this.f_96541_.f_91074_, this.categories.get(i))) continue;
            CategoryButton button = new CategoryButton(this, this.categories.get(i), i, buttonX, buttonY + (buttonHeight + buttonSpacing) * buttonCount, buttonWidth, buttonHeight, b -> this.onBookCategoryButtonClick((CategoryButton)b), (b, stack, x, y) -> this.onBookCategoryButtonTooltip((CategoryButton)b, stack, x, y));
            this.m_142416_((GuiEventListener)button);
            ++buttonCount;
        }
        int readAllButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 - 3;
        int readAllButtonYOffset = 30 + this.getBook().getReadAllButtonYOffset();
        int readAllButtonY = (this.f_96544_ - this.getFrameHeight()) / 2 + 7 + readAllButtonYOffset;
        ReadAllButton readAllButton = new ReadAllButton(this, readAllButtonX, readAllButtonY, () -> this.hasUnreadUnlockedEntries, this::canSeeReadAllButton, b -> this.onReadAllButtonClick((ReadAllButton)b), (b, stack, x, y) -> this.onReadAllButtonTooltip((ReadAllButton)b, stack, x, y));
        this.m_142416_((GuiEventListener)readAllButton);
        int searchButtonXOffset = 7;
        int searchButtonYOffset = -30 + this.getBook().getSearchButtonYOffset();
        int searchButtonX = this.getFrameWidth() + this.getFrameThicknessW() + 8 + searchButtonXOffset;
        int searchButtonY = this.getFrameHeight() + this.getFrameThicknessH() - 7 + searchButtonYOffset;
        int searchButtonWidth = 44;
        int scissorX = this.getFrameWidth() + this.getFrameThicknessW() * 2 + 2;
        SearchButton searchButton = new SearchButton(this, searchButtonX, searchButtonY, scissorX, searchButtonWidth, buttonHeight, b -> this.onSearchButtonClick((SearchButton)b), (b, stack, x, y) -> this.onSearchButtonTooltip((SearchButton)b, stack, x, y));
        this.m_142416_((GuiEventListener)searchButton);
    }

    protected void onSearchButtonClick(SearchButton button) {
        ForgeHooksClient.pushGuiLayer((Minecraft)this.getMinecraft(), (Screen)new BookSearchScreen(this));
    }

    protected void onSearchButtonTooltip(SearchButton button, PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"modonomicon.gui.open_search"), pMouseX, pMouseY);
    }

    public boolean m_7043_() {
        return false;
    }
}

