/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.integration;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModonomiconJeiIntegration {
    public static boolean isJeiLoaded() {
        return ModList.get().isLoaded("jei");
    }

    public static boolean isJEIRecipesGuiOpen() {
        if (ModonomiconJeiIntegration.isJeiLoaded()) {
            return ModonomiconJeiHelper.isJEIRecipesGuiOpen();
        }
        Modonomicon.LOGGER.warn("Attempted check if JEI recipes GUI is open without JEI installed!");
        return false;
    }

    public static void showRecipe(ItemStack stack) {
        if (ModonomiconJeiIntegration.isJeiLoaded()) {
            ModonomiconJeiHelper.showRecipe(stack);
        } else {
            Modonomicon.LOGGER.warn("Attempted to show JEI recipe for {} without JEI installed!", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }
    }

    public static void showUses(ItemStack stack) {
        if (ModonomiconJeiIntegration.isJeiLoaded()) {
            ModonomiconJeiHelper.showUses(stack);
        } else {
            Modonomicon.LOGGER.warn("Attempted to show JEI usages for {} without JEI installed!", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }
    }

    public static class ModonomiconJeiHelper {
        public static void showRecipe(ItemStack stack) {
            IFocus focus = ModonomiconJeiPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            ModonomiconJeiPlugin.jeiRuntime.getRecipesGui().show(focus);
        }

        public static void showUses(ItemStack stack) {
            IFocus focus = ModonomiconJeiPlugin.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.INPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            ModonomiconJeiPlugin.jeiRuntime.getRecipesGui().show(focus);
        }

        public static boolean isJEIRecipesGuiOpen() {
            return Minecraft.m_91087_().f_91080_ instanceof IRecipesGui;
        }
    }

    @JeiPlugin
    public static class ModonomiconJeiPlugin
    implements IModPlugin {
        private static final ResourceLocation UID = new ResourceLocation("modonomicon", "modonomicon");
        private static IJeiRuntime jeiRuntime;

        @NotNull
        public ResourceLocation getPluginUid() {
            return UID;
        }

        public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
            ModonomiconJeiPlugin.jeiRuntime = jeiRuntime;
        }

        public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ItemRegistry.MODONOMICON.get()), (stack, context) -> {
                if (!stack.m_41782_() || !stack.m_41783_().m_128441_("modonomicon:book_id")) {
                    return "";
                }
                return stack.m_41783_().m_128461_("modonomicon:book_id");
            });
        }
    }
}

