/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.GuiTools;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.BaseScreen;
import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardType;
import mcjty.rftoolsbuilder.modules.builder.network.PacketOpenBuilderGui;
import mcjty.rftoolsbuilder.modules.builder.network.PacketUpdateNBTItemInventoryShape;
import mcjty.rftoolsbuilder.modules.builder.network.PacketUpdateNBTShapeCard;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.IShapeParentGui;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import mcjty.rftoolsbuilder.shapes.ShapeRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.lwjgl.opengl.GL11;

public class GuiShapeCard
extends BaseScreen
implements IShapeParentGui,
IKeyReceiver {
    protected int xSize = 360;
    protected int ySize = 160;
    private int guiLeft;
    private int guiTop;
    private boolean isQuarryCard;
    private ChoiceLabel shapeLabel;
    private ChoiceLabel solidLabel;
    private TextField dimX;
    private TextField dimY;
    private TextField dimZ;
    private TextField offsetX;
    private TextField offsetY;
    private TextField offsetZ;
    private Window window = null;
    private Label blocksLabel;
    private Panel voidPanel;
    private ToggleButton stone;
    private ToggleButton cobble;
    private ToggleButton dirt;
    private ToggleButton gravel;
    private ToggleButton sand;
    private ToggleButton netherrack;
    private ToggleButton endstone;
    private ToggleButton tagMatching;
    public final boolean fromTE;
    public static BlockPos fromTEPos = null;
    public static int fromTEStackSlot = 0;
    private ShapeID shapeID = null;
    private ShapeRenderer shapeRenderer = null;
    private final boolean[] buttons = new boolean[10];
    private static int updateCounter = 20;

    public GuiShapeCard(boolean fromTE) {
        super((Component)ComponentFactory.literal((String)"Shapecard"));
        this.fromTE = fromTE;
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.fromTE) {
            RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketOpenBuilderGui(fromTEPos));
        }
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeID == null) {
            this.shapeID = this.getShapeID();
        } else if (!this.shapeID.equals(this.getShapeID())) {
            this.shapeID = this.getShapeID();
            this.shapeRenderer = null;
        }
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.shapeID);
            this.shapeRenderer.initView(this.getPreviewLeft(), this.guiTop);
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        ItemStack stackToEdit = this.getStackToEdit();
        return new ShapeID((ResourceKey<Level>)Level.f_46428_, null, ShapeCardItem.getScanId(stackToEdit), false, ShapeCardItem.isSolid(stackToEdit));
    }

    public boolean m_7043_() {
        return false;
    }

    private ItemStack getStackToEdit() {
        if (this.fromTE) {
            BlockEntity te = this.f_96541_.f_91073_.m_7702_(fromTEPos);
            return te.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h.getStackInSlot(fromTEStackSlot)).orElse(ItemStack.f_41583_);
        }
        return this.f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
    }

    @Override
    public int getPreviewLeft() {
        return this.guiLeft + 104;
    }

    @Override
    public int getPreviewTop() {
        return this.guiTop - 5 + (this.isQuarryCard ? 0 : 10);
    }

    public void m_7856_() {
        Panel toplevel;
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        ItemStack heldItem = this.getStackToEdit();
        if (heldItem.m_41619_()) {
            return;
        }
        ShapeCardType type = ShapeCardItem.getType(heldItem);
        this.isQuarryCard = type.isQuarry();
        if (this.isQuarryCard) {
            this.ySize = 188;
        }
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.guiTop);
        this.shapeLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(100)).desiredHeight(16)).choices(new String[]{Shape.SHAPE_BOX.getDescription(), Shape.SHAPE_TOPDOME.getDescription(), Shape.SHAPE_BOTTOMDOME.getDescription(), Shape.SHAPE_SPHERE.getDescription(), Shape.SHAPE_CYLINDER.getDescription(), Shape.SHAPE_CAPPEDCYLINDER.getDescription(), Shape.SHAPE_PRISM.getDescription(), Shape.SHAPE_TORUS.getDescription(), Shape.SHAPE_CONE.getDescription(), Shape.SHAPE_HEART.getDescription(), Shape.SHAPE_COMPOSITION.getDescription(), Shape.SHAPE_SCAN.getDescription()}).event(newChoice -> this.updateSettings());
        this.solidLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().desiredWidth(50)).desiredHeight(16)).choices(new String[]{"Hollow", "Solid"}).event(newChoice -> this.updateSettings());
        Panel shapePanel = (Panel)Widgets.horizontal().children(new Widget[]{this.shapeLabel, this.solidLabel});
        Shape shape = ShapeCardItem.getShape(heldItem);
        this.shapeLabel.choice(shape.getDescription());
        boolean solid = ShapeCardItem.isSolid(heldItem);
        this.solidLabel.choice(solid ? "Solid" : "Hollow");
        this.blocksLabel = (Label)Widgets.label((String)"# ").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.blocksLabel.desiredWidth(100)).desiredHeight(16);
        Panel modePanel = (Panel)((Panel)Widgets.vertical().desiredWidth(170)).children(new Widget[]{shapePanel, this.blocksLabel});
        BlockPos dim = ShapeCardItem.getDimension(heldItem);
        BlockPos offset = ShapeCardItem.getOffset(heldItem);
        this.dimX = new TextField().event(newText -> {
            if (this.isTorus()) {
                this.dimZ.text(newText);
            }
            this.updateSettings();
        }).text(String.valueOf(dim.m_123341_()));
        this.dimY = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(dim.m_123342_()));
        this.dimZ = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(dim.m_123343_()));
        Panel dimPanel = (Panel)((Panel)Widgets.horizontal((int)0, (int)5).desiredHeight(18)).children(new Widget[]{((Label)Widgets.label((String)"Dim:").horizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).desiredWidth(40), this.dimX, this.dimY, this.dimZ});
        this.offsetX = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(offset.m_123341_()));
        this.offsetY = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(offset.m_123342_()));
        this.offsetZ = new TextField().event(newText -> this.updateSettings()).text(String.valueOf(offset.m_123343_()));
        Panel offsetPanel = (Panel)((Panel)Widgets.horizontal((int)0, (int)5).desiredHeight(18)).children(new Widget[]{((Label)Widgets.label((String)"Offset:").horizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).desiredWidth(40), this.offsetX, this.offsetY, this.offsetZ});
        Panel settingsPanel = (Panel)new Panel().layout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(1)).setHorizontalMargin(0)).children(new Widget[]{dimPanel, offsetPanel});
        int k = (this.f_96543_ - this.xSize) / 2;
        int l = (this.f_96544_ - this.ySize) / 2;
        Panel modeSettingsPanel = (Panel)new Panel().layout((Layout)new VerticalLayout().setHorizontalMargin(0)).children(new Widget[]{modePanel, settingsPanel});
        modeSettingsPanel.hint(0, 0, 180, 160);
        if (this.isQuarryCard) {
            this.setupVoidPanel(heldItem);
            toplevel = (Panel)((Panel)Widgets.positional().filledRectThickness(2)).children(new Widget[]{modeSettingsPanel, this.voidPanel});
        } else {
            toplevel = (Panel)((Panel)Widgets.positional().filledRectThickness(2)).children(new Widget[]{modeSettingsPanel});
        }
        toplevel.bounds(k, l, this.xSize, this.ySize);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void setupVoidPanel(ItemStack heldItem) {
        this.voidPanel = (Panel)((Panel)((Panel)Widgets.horizontal().desiredHeight(26)).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground);
        this.voidPanel.hint(5, 155, 350, 26);
        Label label = Widgets.label((String)"Void:");
        this.stone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void stone"})).event(this::updateVoidSettings);
        this.cobble = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void cobble"})).event(this::updateVoidSettings);
        this.dirt = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void dirt"})).event(this::updateVoidSettings);
        this.gravel = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void gravel"})).event(this::updateVoidSettings);
        this.sand = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void sand"})).event(this::updateVoidSettings);
        this.netherrack = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void netherrack"})).event(this::updateVoidSettings);
        this.endstone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(20)).desiredHeight(20)).tooltips(new String[]{"Void end stone"})).event(this::updateVoidSettings);
        this.tagMatching = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().desiredWidth(60)).desiredHeight(15)).tooltips(new String[]{"Enable tag matching"})).text("Tags")).checkMarker(true).event(this::updateVoidSettings);
        this.stone.pressed(ShapeCardItem.isVoiding(heldItem, "stone"));
        this.cobble.pressed(ShapeCardItem.isVoiding(heldItem, "cobble"));
        this.dirt.pressed(ShapeCardItem.isVoiding(heldItem, "dirt"));
        this.gravel.pressed(ShapeCardItem.isVoiding(heldItem, "gravel"));
        this.sand.pressed(ShapeCardItem.isVoiding(heldItem, "sand"));
        this.netherrack.pressed(ShapeCardItem.isVoiding(heldItem, "netherrack"));
        this.endstone.pressed(ShapeCardItem.isVoiding(heldItem, "endstone"));
        this.tagMatching.pressed(ShapeCardItem.isTagMatching(heldItem));
        this.voidPanel.children(new Widget[]{label, this.stone, this.cobble, this.dirt, this.gravel, this.sand, this.netherrack, this.endstone, this.tagMatching});
    }

    private boolean isTorus() {
        Shape shape = this.getCurrentShape();
        return Shape.SHAPE_TORUS.equals((Object)shape);
    }

    private Shape getCurrentShape() {
        return Shape.getShape(this.shapeLabel.getCurrentChoice());
    }

    private boolean isSolid() {
        return "Solid".equals(this.solidLabel.getCurrentChoice());
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void updateSettings() {
        int dx = GuiShapeCard.parseInt(this.dimX.getText());
        int dy = GuiShapeCard.parseInt(this.dimY.getText());
        int dz = GuiShapeCard.parseInt(this.dimZ.getText());
        int max = Math.max((Integer)ScannerConfiguration.maxScannerDimension.get(), (Integer)BuilderConfiguration.maxBuilderDimension.get());
        if (dx < 0) {
            dx = 0;
        } else if (dx > max) {
            dx = max;
        }
        this.dimX.text(Integer.toString(dx));
        if (dz < 0) {
            dz = 0;
        } else if (dz > max) {
            dz = max;
        }
        this.dimZ.text(Integer.toString(dz));
        if (dy < 0) {
            dy = 0;
        }
        this.dimY.text(Integer.toString(dy));
        if (this.isTorus()) {
            this.dimZ.text(this.dimX.getText());
        }
        if (this.fromTE) {
            ItemStack stack = this.getStackToEdit();
            if (!stack.m_41619_()) {
                CompoundTag tag = stack.m_41783_();
                if (tag == null) {
                    tag = new CompoundTag();
                }
                ShapeCardItem.setShape(stack, this.getCurrentShape(), this.isSolid());
                ShapeCardItem.setDimension(stack, dx, dy, dz);
                ShapeCardItem.setOffset(stack, GuiShapeCard.parseInt(this.offsetX.getText()), GuiShapeCard.parseInt(this.offsetY.getText()), GuiShapeCard.parseInt(this.offsetZ.getText()));
                RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketUpdateNBTItemInventoryShape(fromTEPos, fromTEStackSlot, tag));
            }
        } else {
            RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketUpdateNBTShapeCard(TypedMap.builder().put(new Key("shape", Type.STRING), (Object)this.getCurrentShape().getDescription()).put(new Key("solid", Type.BOOLEAN), (Object)this.isSolid()).put(new Key("dimX", Type.INTEGER), (Object)dx).put(new Key("dimY", Type.INTEGER), (Object)dy).put(new Key("dimZ", Type.INTEGER), (Object)dz).put(new Key("offsetX", Type.INTEGER), (Object)GuiShapeCard.parseInt(this.offsetX.getText())).put(new Key("offsetY", Type.INTEGER), (Object)GuiShapeCard.parseInt(this.offsetY.getText())).put(new Key("offsetZ", Type.INTEGER), (Object)GuiShapeCard.parseInt(this.offsetZ.getText())).build()));
        }
    }

    private void updateVoidSettings() {
        if (this.fromTE) {
            ItemStack stack = this.getStackToEdit();
            if (!stack.m_41619_()) {
                CompoundTag tag = stack.m_41783_();
                if (tag == null) {
                    tag = new CompoundTag();
                }
                tag.m_128379_("voidstone", this.stone.isPressed());
                tag.m_128379_("voidcobble", this.cobble.isPressed());
                tag.m_128379_("voiddirt", this.dirt.isPressed());
                tag.m_128379_("voidgravel", this.gravel.isPressed());
                tag.m_128379_("voidsand", this.sand.isPressed());
                tag.m_128379_("voidnetherrack", this.netherrack.isPressed());
                tag.m_128379_("voidendstone", this.endstone.isPressed());
                tag.m_128379_("tagMatching", this.tagMatching.isPressed());
                RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketUpdateNBTItemInventoryShape(fromTEPos, fromTEStackSlot, tag));
            }
        } else {
            RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketUpdateNBTShapeCard(TypedMap.builder().put(new Key("voidstone", Type.BOOLEAN), (Object)this.stone.isPressed()).put(new Key("voidcobble", Type.BOOLEAN), (Object)this.cobble.isPressed()).put(new Key("voiddirt", Type.BOOLEAN), (Object)this.dirt.isPressed()).put(new Key("voidgravel", Type.BOOLEAN), (Object)this.gravel.isPressed()).put(new Key("voidsand", Type.BOOLEAN), (Object)this.sand.isPressed()).put(new Key("voidnetherrack", Type.BOOLEAN), (Object)this.netherrack.isPressed()).put(new Key("voidendstone", Type.BOOLEAN), (Object)this.endstone.isPressed()).put(new Key("tagMatching", Type.BOOLEAN), (Object)this.tagMatching.isPressed()).build()));
        }
    }

    public void m_94757_(double xx, double yy) {
        if (this.window == null) {
            return;
        }
        this.window.mouseDragged(xx, yy, 0);
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        this.getShapeRenderer().handleShapeDragging(x -= this.guiLeft, y -= this.guiTop, this.buttons);
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.window == null) {
            return false;
        }
        if (button < this.buttons.length) {
            this.buttons[button] = true;
        }
        boolean rc = super.m_6375_(x, y, button);
        this.window.mouseClicked(x, y, button);
        return rc;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.window == null) {
            return false;
        }
        if (button < this.buttons.length) {
            this.buttons[button] = false;
        }
        boolean rc = super.m_6348_(mouseX, mouseY, button);
        this.window.mouseReleased(mouseX, mouseY, button);
        return rc;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.window == null) {
            return false;
        }
        boolean rc = false;
        if (!this.window.keyTyped(keyCode, scanCode)) {
            rc = super.m_7933_(keyCode, scanCode, modifiers);
        }
        return rc;
    }

    public Window getWindow() {
        return this.window;
    }

    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.window != null && this.window.keyTyped(keyCode, scanCode)) {
            super.m_7933_(keyCode, scanCode, 0);
        }
    }

    public void charTypedFromEvent(char codePoint) {
        if (this.window != null && this.window.charTyped(codePoint)) {
            super.m_5534_(codePoint, 0);
        }
    }

    public boolean mouseClickedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseClicked(x, y, button);
        return true;
    }

    public boolean mouseReleasedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseReleased(x, y, button);
        return true;
    }

    public boolean mouseScrolledFromEvent(double x, double y, double amount) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseScrolled(x, y, amount);
        return true;
    }

    public boolean m_6050_(double x, double y, double wheel) {
        if (this.window == null) {
            return false;
        }
        this.getShapeRenderer().handleMouseWheel(wheel);
        return super.m_6050_(x, y, wheel);
    }

    protected void renderInternal(PoseStack matrixStack, int pMouseX, int pMouseY, float pPartialTick) {
        List tooltips;
        ItemStack stack;
        if (this.window == null) {
            return;
        }
        this.dimZ.enabled(!this.isTorus());
        if (--updateCounter <= 0) {
            updateCounter = 10;
            int count = this.getShapeRenderer().getCount();
            if (count >= 50000000) {
                this.blocksLabel.text("#Blocks: ++" + count);
            } else {
                this.blocksLabel.text("#Blocks: " + count);
            }
        }
        this.window.draw(matrixStack);
        if (this.isQuarryCard) {
            int x = (int)(this.window.getToplevel().getBounds().getX() + this.voidPanel.getBounds().getX()) + 1;
            int y = (int)(this.window.getToplevel().getBounds().getY() + this.voidPanel.getBounds().getY() + this.stone.getBounds().getY()) + 1;
            this.renderVoidBlock(matrixStack, x, y, this.stone, Blocks.f_50069_);
            this.renderVoidBlock(matrixStack, x, y, this.cobble, Blocks.f_50652_);
            this.renderVoidBlock(matrixStack, x, y, this.dirt, Blocks.f_50493_);
            this.renderVoidBlock(matrixStack, x, y, this.gravel, Blocks.f_49994_);
            this.renderVoidBlock(matrixStack, x, y, this.sand, Blocks.f_49992_);
            this.renderVoidBlock(matrixStack, x, y, this.netherrack, Blocks.f_50134_);
            this.renderVoidBlock(matrixStack, x, y, this.endstone, Blocks.f_50259_);
        }
        if (!(stack = this.getStackToEdit()).m_41619_()) {
            // empty if block
        }
        if ((tooltips = this.window.getTooltips()) != null) {
            int guiLeft = (this.f_96543_ - this.xSize) / 2;
            int guiTop = (this.f_96544_ - this.ySize) / 2;
            int x = GuiTools.getRelativeX((Screen)this);
            int y = GuiTools.getRelativeY((Screen)this);
            List properties = tooltips.stream().map(ComponentFactory::literal).collect(Collectors.toList());
            List processors = Language.m_128107_().m_128112_(properties);
            this.m_96617_(matrixStack, processors, x - guiLeft, y - guiTop);
        }
    }

    private void renderVoidBlock(PoseStack matrixStack, int x, int y, ToggleButton button, Block block) {
        RenderHelper.renderObject((PoseStack)matrixStack, (int)(x += (int)button.getBounds().getX()), (int)y, (Object)new ItemStack((ItemLike)block), (boolean)button.isPressed());
        if (button.isPressed()) {
            GuiShapeCard.drawLine(x - 1, y - 1, x + 18, y + 18, -65536);
            GuiShapeCard.drawLine(x + 18, y - 1, x - 1, y + 18, -65536);
        }
    }

    private static void drawLine(int x1, int y1, int x2, int y2, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85814_);
        GlStateManager.m_84525_();
        GlStateManager.m_84507_();
        GL11.glLineWidth((float)2.0f);
        GlStateManager.m_84335_((int)770, (int)771, (int)1, (int)0);
        buffer.m_5483_((double)x1, (double)y1, 0.0).m_5752_();
        buffer.m_5483_((double)x2, (double)y2, 0.0).m_5752_();
        tessellator.m_85914_();
        GlStateManager.m_84513_();
        GlStateManager.m_84519_();
    }

    public static void open(boolean fromTE) {
        Minecraft.m_91087_().m_91152_((Screen)new GuiShapeCard(fromTE));
    }
}

