/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.items;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Check32;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RLE;
import mcjty.lib.varia.TagTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.client.GuiShapeCard;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardType;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeModifier;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ShapeCardItem
extends Item
implements INBTPreservingIngredient,
ITooltipSettings {
    private final ShapeCardType type;
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.warning(stack -> this.isDisabledInConfig()), TooltipBuilder.header(), TooltipBuilder.parameter((String)"shape", this::getShapeDescription), TooltipBuilder.parameter((String)"dimension", this::getShapeDimension), TooltipBuilder.parameter((String)"offset", this::getShapeOffset), TooltipBuilder.parameter((String)"formulas", stack -> ShapeCardItem.getShape(stack).isComposition(), stack -> {
        CompoundTag card = stack.m_41783_();
        if (card != null) {
            ListTag children = card.m_128437_("children", 10);
            return Integer.toString(children.size());
        }
        return "<none>";
    }), TooltipBuilder.parameter((String)"scan", stack -> ShapeCardItem.getShape(stack).isScan(), stack -> {
        CompoundTag card = stack.m_41783_();
        if (card != null) {
            int scanid = card.m_128451_("scanid");
            return Integer.toString(scanid);
        }
        return "<none>";
    })});
    public static final int MAXIMUM_COUNT = 50000000;
    public static final int MODE_NONE = 0;
    public static final int MODE_CORNER1 = 1;
    public static final int MODE_CORNER2 = 2;

    public ShapeCardItem(ShapeCardType type) {
        super(RFToolsBuilder.setup.defaultProperties().m_41487_(1).m_41499_(0));
        this.type = type;
    }

    public boolean isDisabledInConfig() {
        if (!((Boolean)BuilderConfiguration.shapeCardAllowed.get()).booleanValue()) {
            return true;
        }
        if (this.type != ShapeCardType.CARD_SHAPE) {
            if (!((Boolean)BuilderConfiguration.quarryAllowed.get()).booleanValue()) {
                return true;
            }
            if (this.type.isQuarry() && this.type.isClearing() && !((Boolean)BuilderConfiguration.clearingQuarryAllowed.get()).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public String getShapeDescription(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return shape.getDescription() + " (" + (issolid ? "Solid" : "Hollow") + ")";
    }

    public String getShapeDimension(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return BlockPosTools.toString((BlockPos)ShapeCardItem.getDimension(itemStack));
    }

    public String getShapeOffset(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return BlockPosTools.toString((BlockPos)ShapeCardItem.getOffset(itemStack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        if (world.f_46443_ || player == null) return InteractionResult.SUCCESS;
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        int mode = ShapeCardItem.getMode(stack);
        if (mode == 0) {
            if (!player.m_6144_()) return InteractionResult.SUCCESS;
            if (world.m_7702_(pos) instanceof BuilderTileEntity) {
                ShapeCardItem.setCurrentBlock(stack, GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
                Logging.message((Player)player, (String)(ChatFormatting.GREEN + "Now select the first corner"));
                ShapeCardItem.setMode(stack, 1);
                ShapeCardItem.setCorner1(stack, null);
                return InteractionResult.SUCCESS;
            } else {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "You can only do this on a builder!"));
            }
            return InteractionResult.SUCCESS;
        } else if (mode == 1) {
            GlobalPos currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock == null) {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "There is no Builder selected!"));
                return InteractionResult.SUCCESS;
            } else if (!currentBlock.m_122640_().equals((Object)world.m_46472_())) {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "The Builder is in another dimension!"));
                return InteractionResult.SUCCESS;
            } else if (currentBlock.m_122646_().equals((Object)pos)) {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return InteractionResult.SUCCESS;
            } else {
                Logging.message((Player)player, (String)(ChatFormatting.GREEN + "Now select the second corner"));
                ShapeCardItem.setMode(stack, 2);
                ShapeCardItem.setCorner1(stack, pos);
            }
            return InteractionResult.SUCCESS;
        } else {
            GlobalPos currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock == null) {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "There is no Builder selected!"));
                return InteractionResult.SUCCESS;
            } else if (!currentBlock.m_122640_().equals((Object)world.m_46472_())) {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "The Builder is in another dimension!"));
                return InteractionResult.SUCCESS;
            } else if (currentBlock.m_122646_().equals((Object)pos)) {
                Logging.message((Player)player, (String)(ChatFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return InteractionResult.SUCCESS;
            } else {
                CompoundTag tag = stack.m_41784_();
                BlockPos c1 = ShapeCardItem.getCorner1(stack);
                if (c1 == null) {
                    Logging.message((Player)player, (String)(ChatFormatting.RED + "Cleared area selection mode!"));
                    ShapeCardItem.setMode(stack, 0);
                    return InteractionResult.SUCCESS;
                } else {
                    Logging.message((Player)player, (String)(ChatFormatting.GREEN + "New settings copied to the shape card!"));
                    BlockPos center = new BlockPos((int)Math.ceil((float)(c1.m_123341_() + pos.m_123341_()) / 2.0f), (int)Math.ceil((float)(c1.m_123342_() + pos.m_123342_()) / 2.0f), (int)Math.ceil((float)(c1.m_123343_() + pos.m_123343_()) / 2.0f));
                    ShapeCardItem.setDimension(stack, Math.abs(c1.m_123341_() - pos.m_123341_()) + 1, Math.abs(c1.m_123342_() - pos.m_123342_()) + 1, Math.abs(c1.m_123343_() - pos.m_123343_()) + 1);
                    ShapeCardItem.setOffset(stack, center.m_123341_() - currentBlock.m_122646_().m_123341_(), center.m_123342_() - currentBlock.m_122646_().m_123342_(), center.m_123343_() - currentBlock.m_122646_().m_123343_());
                    ShapeCardItem.setMode(stack, 0);
                    ShapeCardItem.setCorner1(stack, null);
                    ShapeCardItem.setShape(stack, Shape.SHAPE_BOX, true);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Collection<String> getTagsToPreserve() {
        return Arrays.asList("mod_op", "mod_flipy", "mod_rot", "ghost_block", "children", "dimX", "dimY", "dimZ", "offsetX", "offsetY", "offsetZ", "mode", "selectedX", "selectedY", "selectedZ", "selectedDim", "corner1x", "corner1y", "corner1z");
    }

    public static void setData(CompoundTag tagCompound, int scanID) {
        tagCompound.m_128405_("scanid", scanID);
    }

    public static void setModifier(CompoundTag tag, ShapeModifier modifier) {
        tag.m_128359_("mod_op", modifier.getOperation().getCode());
        tag.m_128379_("mod_flipy", modifier.isFlipY());
        tag.m_128359_("mod_rot", modifier.getRotation().getCode());
    }

    public static void setGhostMaterial(CompoundTag tag, ItemStack materialGhost) {
        if (materialGhost.m_41619_()) {
            tag.m_128473_("ghost_block");
        } else {
            Block block = Block.m_49814_((Item)materialGhost.m_41720_());
            tag.m_128359_("ghost_block", Tools.getId((Block)block).toString());
        }
    }

    public static void setChildren(ItemStack itemStack, ListTag list) {
        CompoundTag tagCompound = itemStack.m_41784_();
        tagCompound.m_128365_("children", (Tag)list);
    }

    public static void setDimension(ItemStack itemStack, int x, int y, int z) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (tagCompound.m_128451_("dimX") == x && tagCompound.m_128451_("dimY") == y && tagCompound.m_128451_("dimZ") == z) {
            return;
        }
        tagCompound.m_128405_("dimX", x);
        tagCompound.m_128405_("dimY", y);
        tagCompound.m_128405_("dimZ", z);
    }

    public static void setOffset(ItemStack itemStack, int x, int y, int z) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (tagCompound.m_128451_("offsetX") == x && tagCompound.m_128451_("offsetY") == y && tagCompound.m_128451_("offsetZ") == z) {
            return;
        }
        tagCompound.m_128405_("offsetX", x);
        tagCompound.m_128405_("offsetY", y);
        tagCompound.m_128405_("offsetZ", z);
    }

    public static void setCorner1(ItemStack itemStack, BlockPos corner) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (corner == null) {
            tagCompound.m_128473_("corner1x");
            tagCompound.m_128473_("corner1y");
            tagCompound.m_128473_("corner1z");
        } else {
            tagCompound.m_128405_("corner1x", corner.m_123341_());
            tagCompound.m_128405_("corner1y", corner.m_123342_());
            tagCompound.m_128405_("corner1z", corner.m_123343_());
        }
    }

    public static BlockPos getCorner1(ItemStack stack1) {
        CompoundTag tagCompound = stack1.m_41783_();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.m_128441_("corner1x")) {
            return null;
        }
        return new BlockPos(tagCompound.m_128451_("corner1x"), tagCompound.m_128451_("corner1y"), tagCompound.m_128451_("corner1z"));
    }

    public static int getMode(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound != null) {
            int mode = tagCompound.m_128451_("mode");
            GlobalPos block = ShapeCardItem.getCurrentBlock(itemStack);
            if (block == null) {
                return 0;
            }
            return mode;
        }
        return 0;
    }

    public static void setMode(ItemStack itemStack, int mode) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (tagCompound.m_128451_("mode") == mode) {
            return;
        }
        tagCompound.m_128405_("mode", mode);
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalPos c) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (c == null) {
            tagCompound.m_128473_("selectedX");
            tagCompound.m_128473_("selectedY");
            tagCompound.m_128473_("selectedZ");
            tagCompound.m_128473_("selectedDim");
        } else {
            tagCompound.m_128405_("selectedX", c.m_122646_().m_123341_());
            tagCompound.m_128405_("selectedY", c.m_122646_().m_123342_());
            tagCompound.m_128405_("selectedZ", c.m_122646_().m_123343_());
            tagCompound.m_128359_("selectedDim", c.m_122640_().m_135782_().toString());
        }
    }

    @Nullable
    private static GlobalPos getCurrentBlock(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound != null && tagCompound.m_128441_("selectedX")) {
            int x = tagCompound.m_128451_("selectedX");
            int y = tagCompound.m_128451_("selectedY");
            int z = tagCompound.m_128451_("selectedZ");
            String dim = tagCompound.m_128461_("selectedDim");
            return GlobalPos.m_122643_((ResourceKey)LevelTools.getId((String)dim), (BlockPos)new BlockPos(x, y, z));
        }
        return null;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(new ResourceLocation("rftoolsbuilder", "shape_card"), itemStack, list, flag);
    }

    public static boolean isNormalShapeCard(ItemStack stack) {
        ShapeCardType type = ShapeCardItem.getType(stack);
        return type == ShapeCardType.CARD_SHAPE || type == ShapeCardType.CARD_PUMP_LIQUID;
    }

    public static ShapeCardType getType(ItemStack stack) {
        if (stack.m_41720_() instanceof ShapeCardItem) {
            return ((ShapeCardItem)stack.m_41720_()).type;
        }
        if (stack.m_41720_() == BuilderModule.SPACE_CHAMBER_CARD.get()) {
            return ShapeCardType.CARD_SPACE;
        }
        return ShapeCardType.CARD_UNKNOWN;
    }

    private static void addBlocks(Set<Block> blocks, Block block, TagKey<Block> tag, boolean tagMatching) {
        blocks.add(block);
        if (tagMatching && tag != null) {
            TagTools.getBlocksForTag(tag).forEach(b -> blocks.add((Block)b.m_203334_()));
        }
    }

    public static Set<Block> getVoidedBlocks(ItemStack stack) {
        HashSet<Block> blocks = new HashSet<Block>();
        boolean tagMatching = ShapeCardItem.isTagMatching(stack);
        if (ShapeCardItem.isVoiding(stack, "stone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.f_50069_, (TagKey<Block>)Tags.Blocks.STONE, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "cobble")) {
            ShapeCardItem.addBlocks(blocks, Blocks.f_50652_, (TagKey<Block>)Tags.Blocks.COBBLESTONE, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "dirt")) {
            ShapeCardItem.addBlocks(blocks, Blocks.f_50493_, (TagKey<Block>)BlockTags.f_144274_, tagMatching);
            ShapeCardItem.addBlocks(blocks, Blocks.f_50034_, null, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "sand")) {
            ShapeCardItem.addBlocks(blocks, Blocks.f_49992_, (TagKey<Block>)Tags.Blocks.SAND, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "gravel")) {
            ShapeCardItem.addBlocks(blocks, Blocks.f_49994_, (TagKey<Block>)Tags.Blocks.GRAVEL, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "netherrack")) {
            ShapeCardItem.addBlocks(blocks, Blocks.f_50134_, (TagKey<Block>)Tags.Blocks.NETHERRACK, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "endstone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.f_50259_, (TagKey<Block>)Tags.Blocks.END_STONES, tagMatching);
        }
        return blocks;
    }

    public static boolean isTagMatching(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.m_128471_("tagMatching");
    }

    public static boolean isVoiding(ItemStack stack, String material) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.m_128471_("void" + material);
    }

    public static Shape getShape(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        return ShapeCardItem.getShape(tagCompound);
    }

    public static Shape getShape(CompoundTag tagCompound) {
        if (tagCompound == null) {
            return Shape.SHAPE_BOX;
        }
        if (!tagCompound.m_128441_("shape")) {
            return Shape.SHAPE_BOX;
        }
        String sn = tagCompound.m_128461_("shape");
        Shape shape = Shape.getShape(sn);
        if (shape == null) {
            return Shape.SHAPE_BOX;
        }
        return shape;
    }

    public static boolean isSolid(ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        CompoundTag tagCompound = stack.m_41783_();
        return ShapeCardItem.isSolid(tagCompound);
    }

    public static boolean isSolid(CompoundTag tagCompound) {
        if (tagCompound == null) {
            return true;
        }
        if (tagCompound.m_128441_("shape")) {
            return tagCompound.m_128471_("solid");
        }
        return false;
    }

    public static IFormula createCorrectFormula(CompoundTag tagCompound) {
        Shape shape = ShapeCardItem.getShape(tagCompound);
        boolean solid = ShapeCardItem.isSolid(tagCompound);
        IFormula formula = shape.getFormulaFactory().get();
        return formula.correctFormula(solid);
    }

    public static int getScanId(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        CompoundTag tagCompound = stack.m_41784_();
        Shape shape = ShapeCardItem.getShape(tagCompound);
        if (shape != Shape.SHAPE_SCAN) {
            return 0;
        }
        return tagCompound.m_128451_("scanid");
    }

    public static int getScanIdRecursive(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return ShapeCardItem.getScanIdRecursive(stack.m_41784_());
    }

    private static int getScanIdRecursive(CompoundTag tagCompound) {
        Shape shape = ShapeCardItem.getShape(tagCompound);
        if (tagCompound.m_128441_("scanid") && shape == Shape.SHAPE_SCAN) {
            return tagCompound.m_128451_("scanid");
        }
        if (shape == Shape.SHAPE_COMPOSITION) {
            ListTag children = tagCompound.m_128437_("children", 10);
            for (int i = 0; i < children.size(); ++i) {
                CompoundTag childTag = children.m_128728_(i);
                int id = ShapeCardItem.getScanIdRecursive(childTag);
                if (id == 0) continue;
                return id;
            }
        }
        return 0;
    }

    public static int getFormulaCheckClient(ItemStack stack) {
        Check32 crc = new Check32();
        ShapeCardItem.getFormulaCheckClient(stack, crc);
        return crc.get();
    }

    public static void getFormulaCheckClient(ItemStack stack, Check32 crc) {
        Shape shape = ShapeCardItem.getShape(stack);
        IFormula formula = shape.getFormulaFactory().get();
        formula.getCheckSumClient(stack.m_41783_(), crc);
    }

    public static void getLocalChecksum(CompoundTag tagCompound, Check32 crc) {
        if (tagCompound == null) {
            return;
        }
        crc.add(ShapeCardItem.getShape(tagCompound).ordinal());
        BlockPos dim = ShapeCardItem.getDimension(tagCompound);
        crc.add(dim.m_123341_());
        crc.add(dim.m_123342_());
        crc.add(dim.m_123343_());
        crc.add(ShapeCardItem.isSolid(tagCompound) ? 1 : 0);
    }

    public static void setShape(ItemStack stack, Shape shape, boolean solid) {
        CompoundTag tagCompound = stack.m_41784_();
        if (ShapeCardItem.isSolid(tagCompound) == solid && ShapeCardItem.getShape(tagCompound).equals((Object)shape)) {
            return;
        }
        tagCompound.m_128359_("shape", shape.getDescription());
        tagCompound.m_128379_("solid", solid);
    }

    public static BlockPos getDimension(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        return ShapeCardItem.getDimension(tagCompound);
    }

    public static BlockPos getDimension(CompoundTag tagCompound) {
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        if (!tagCompound.m_128441_("dimX")) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.m_128451_("dimX");
        int dimY = tagCompound.m_128451_("dimY");
        int dimZ = tagCompound.m_128451_("dimZ");
        return new BlockPos(dimX, ShapeCardItem.clampDimension(dimY, 4096), dimZ);
    }

    public static BlockPos getClampedDimension(ItemStack stack, int maximum) {
        CompoundTag tagCompound = stack.m_41783_();
        return ShapeCardItem.getClampedDimension(tagCompound, maximum);
    }

    public static BlockPos getClampedDimension(CompoundTag tagCompound, int maximum) {
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.m_128451_("dimX");
        int dimY = tagCompound.m_128451_("dimY");
        int dimZ = tagCompound.m_128451_("dimZ");
        return new BlockPos(ShapeCardItem.clampDimension(dimX, maximum), ShapeCardItem.clampDimension(dimY, maximum), ShapeCardItem.clampDimension(dimZ, maximum));
    }

    private static int clampDimension(int o, int maximum) {
        if (o > maximum) {
            o = maximum;
        } else if (o < 0) {
            o = 0;
        }
        return o;
    }

    public static BlockPos getOffset(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.m_128451_("offsetX");
        int offsetY = tagCompound.m_128451_("offsetY");
        int offsetZ = tagCompound.m_128451_("offsetZ");
        return new BlockPos(offsetX, offsetY, offsetZ);
    }

    public static BlockPos getClampedOffset(ItemStack stack, int maximum) {
        CompoundTag tagCompound = stack.m_41783_();
        return ShapeCardItem.getClampedOffset(tagCompound, maximum);
    }

    public static BlockPos getClampedOffset(CompoundTag tagCompound, int maximum) {
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.m_128451_("offsetX");
        int offsetY = tagCompound.m_128451_("offsetY");
        int offsetZ = tagCompound.m_128451_("offsetZ");
        return new BlockPos(ShapeCardItem.clampOffset(offsetX, maximum), ShapeCardItem.clampOffset(offsetY, maximum), ShapeCardItem.clampOffset(offsetZ, maximum));
    }

    private static int clampOffset(int o, int maximum) {
        if (o < -maximum) {
            o = -maximum;
        } else if (o > maximum) {
            o = maximum;
        }
        return o;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            GuiShapeCard.open(false);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static BlockPos getMinCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int xCoord = thisCoord.m_123341_();
        int yCoord = thisCoord.m_123342_();
        int zCoord = thisCoord.m_123343_();
        int dx = dimension.m_123341_();
        int dy = dimension.m_123342_();
        int dz = dimension.m_123343_();
        return new BlockPos(xCoord - dx / 2 + offset.m_123341_(), yCoord - dy / 2 + offset.m_123342_(), zCoord - dz / 2 + offset.m_123343_());
    }

    public static BlockPos getMaxCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int dx = dimension.m_123341_();
        int dy = dimension.m_123342_();
        int dz = dimension.m_123343_();
        BlockPos minCorner = ShapeCardItem.getMinCorner(thisCoord, dimension, offset);
        return new BlockPos(minCorner.m_123341_() + dx, minCorner.m_123342_() + dy, minCorner.m_123343_() + dz);
    }

    public static boolean xInChunk(int x, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.f_45578_ == x >> 4;
    }

    public static boolean zInChunk(int z, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.f_45579_ == z >> 4;
    }

    private static void placeBlockIfPossible(Level worldObj, Map<BlockPos, BlockState> blocks, int maxSize, int x, int y, int z, BlockState state, boolean forquarry) {
        BlockPos c = new BlockPos(x, y, z);
        if (worldObj == null) {
            blocks.put(c, state);
            return;
        }
        if (forquarry) {
            if (worldObj.m_46859_(c)) {
                return;
            }
            blocks.put(c, state);
        } else if (BuilderTileEntity.isEmptyOrReplacable(worldObj, c) && blocks.size() < maxSize) {
            blocks.put(c, state);
        }
    }

    public static int getRenderPositions(ItemStack stack, boolean solid, RLE positions, StatePalette statePalette, IFormula formula, int oy) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.m_123341_(), 512), Math.min(dimension.m_123342_(), 4096), Math.min(dimension.m_123343_(), 512));
        int dx = clamped.m_123341_();
        int dy = clamped.m_123342_();
        int dz = clamped.m_123343_();
        int cnt = 0;
        int y = oy - dy / 2;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                int v = 255;
                if (formula.isInside(x, y, z)) {
                    ++cnt;
                    BlockState lastState = formula.getLastState();
                    if (solid) {
                        if (ox == 0 || ox == dx - 1 || oy == 0 || oy == dy - 1 || oz == 0 || oz == dz - 1) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        } else if (formula.isVisible(x, y, z)) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        }
                    } else {
                        v = statePalette.alloc(lastState, -1) + 1;
                    }
                }
                positions.add(v);
            }
        }
        return cnt;
    }

    public static int getDataPositions(Level world, ItemStack stack, Shape shape, boolean solid, RLE positions, StatePalette statePalette) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.m_123341_(), 512), Math.min(dimension.m_123342_(), 4096), Math.min(dimension.m_123343_(), 512));
        IFormula formula = shape.getFormulaFactory().get();
        int dx = clamped.m_123341_();
        int dy = clamped.m_123342_();
        int dz = clamped.m_123343_();
        formula = formula.correctFormula(solid);
        formula.setup(world, new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), !stack.m_41619_() ? stack.m_41783_() : null);
        int cnt = 0;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = oy - dy / 2;
                    int v = 255;
                    if (formula.isInside(x, y, z)) {
                        ++cnt;
                        BlockState lastState = formula.getLastState();
                        if (lastState == null) {
                            lastState = Blocks.f_50069_.m_49966_();
                        }
                        v = statePalette.alloc(lastState, 0) + 1;
                    }
                    positions.add(v);
                }
            }
        }
        return cnt;
    }

    public static void composeFormula(ItemStack shapeCard, IFormula formula, Level worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Map<BlockPos, BlockState> blocks, int maxSize, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.m_123341_();
        int yCoord = thisCoord.m_123342_();
        int zCoord = thisCoord.m_123343_();
        int dx = dimension.m_123341_();
        int dy = dimension.m_123342_();
        int dz = dimension.m_123343_();
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.m_123341_(), yCoord - dy / 2 + offset.m_123342_(), zCoord - dz / 2 + offset.m_123343_());
        formula = formula.correctFormula(solid);
        formula.setup(worldObj, thisCoord, dimension, offset, shapeCard != null ? shapeCard.m_41783_() : null);
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.m_123341_() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.m_123343_() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = tl.m_123342_() + oy;
                    if (!formula.isInside(x, y, z)) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, formula.getLastState(), forquarry);
                }
            }
        }
    }

    private static boolean validFile(Player player, String filename) {
        if (filename.contains("\\") || filename.contains("/") || filename.contains(":")) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Invalid filename '" + filename + "'! Cannot be a path!")), false);
            return false;
        }
        return true;
    }

    public static void save(Player player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        boolean solid = ShapeCardItem.isSolid(card);
        BlockPos offset = ShapeCardItem.getOffset(card);
        BlockPos dimension = ShapeCardItem.getDimension(card);
        RLE positions = new RLE();
        StatePalette statePalette = new StatePalette();
        int cnt = ShapeCardItem.getDataPositions(player.m_20193_(), card, shape, solid, positions, statePalette);
        byte[] data = positions.getData();
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(file));){
            writer.println("SHAPE");
            writer.println("DIM:" + dimension.m_123341_() + "," + dimension.m_123342_() + "," + dimension.m_123343_());
            writer.println("OFF:" + offset.m_123341_() + "," + offset.m_123342_() + "," + offset.m_123343_());
            for (BlockState state : statePalette.getPalette()) {
                String r = Tools.getId((BlockState)state).toString();
                writer.println(r);
            }
            writer.println("DATA");
            byte[] encoded = Base64.getEncoder().encode(data);
            writer.write(new String(encoded));
        }
        catch (FileNotFoundException e) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Cannot write to file '" + filename + "'!")), false);
            return;
        }
        player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Saved shape to file '" + file.getPath() + "'")), false);
    }

    public static void load(Player player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        if (shape != Shape.SHAPE_SCAN) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "To load a file into this card you need a linked 'scan' type card!")), false);
            return;
        }
        CompoundTag compound = card.m_41784_();
        int scanId = compound.m_128451_("scanid");
        if (scanId == 0) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "This card is not linked to scan data!")), false);
            return;
        }
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String s = reader.readLine();
            if (!"SHAPE".equals(s)) {
                player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "This does not appear to be a valid shapecard file!")), false);
                return;
            }
            s = reader.readLine();
            if (!s.startsWith("DIM:")) {
                player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "This does not appear to be a valid shapecard file!")), false);
                return;
            }
            BlockPos dim = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            if (!s.startsWith("OFF:")) {
                player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "This does not appear to be a valid shapecard file!")), false);
                return;
            }
            BlockPos off = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            StatePalette statePalette = new StatePalette();
            while (!"DATA".equals(s)) {
                String[] split = StringUtils.split((String)s, (char)'@');
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
                int meta = Integer.parseInt(split[1]);
                if (block == null) {
                    player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "Could not find block '" + split[0] + "'!")), false);
                    block = Blocks.f_50069_;
                    meta = 0;
                }
                statePalette.add(block.m_49966_());
                s = reader.readLine();
            }
            s = reader.readLine();
            byte[] decoded = Base64.getDecoder().decode(s.getBytes());
            ShapeCardItem.setDataFromFile(scanId, card, dim, off, decoded, statePalette);
        }
        catch (IOException e) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Cannot read from file '" + filename + "'!")), false);
            return;
        }
        catch (NullPointerException e) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "File '" + filename + "' is too short!")), false);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "File '" + filename + "' contains invalid entries!")), false);
            return;
        }
        player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Loaded shape from file '" + file.getPath() + "'")), false);
    }

    private static void setDataFromFile(int scanId, ItemStack card, BlockPos dimension, BlockPos offset, byte[] data, StatePalette palette) {
    }

    private static BlockPos parse(String s) {
        String[] split = StringUtils.split((String)s, (char)',');
        return new BlockPos(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }
}

