/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateNBTShapeCard {
    private TypedMap args;

    public void toBytes(FriendlyByteBuf buf) {
        TypedMapTools.writeArguments((FriendlyByteBuf)buf, (TypedMap)this.args);
    }

    public PacketUpdateNBTShapeCard() {
    }

    public PacketUpdateNBTShapeCard(FriendlyByteBuf buf) {
        this.args = TypedMapTools.readArguments((FriendlyByteBuf)buf);
    }

    public PacketUpdateNBTShapeCard(TypedMap arguments) {
        this.args = arguments;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer playerEntity = ctx.getSender();
            ItemStack heldItem = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
            if (heldItem.m_41619_()) {
                return;
            }
            CompoundTag tagCompound = heldItem.m_41783_();
            if (tagCompound == null) {
                tagCompound = new CompoundTag();
                heldItem.m_41751_(tagCompound);
            }
            for (Key akey : this.args.getKeys()) {
                String key = akey.name();
                if (Type.STRING.equals(akey.type())) {
                    tagCompound.m_128359_(key, (String)this.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.type())) {
                    tagCompound.m_128405_(key, ((Integer)this.args.get(akey)).intValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.type())) {
                    tagCompound.m_128347_(key, ((Double)this.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.type())) {
                    tagCompound.m_128379_(key, ((Boolean)this.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.type())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (!Type.ITEMSTACK.equals(akey.type())) continue;
                throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

