/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.sound;

import com.google.common.collect.Maps;
import java.util.Map;
import mcjty.rftoolsbuilder.modules.mover.sound.MoverSound;
import mcjty.rftoolsbuilder.modules.mover.sound.Sounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public final class MoverSoundController {
    private static final Map<Pair<BlockPos, GlobalPos>, MoverSound> SOUNDS = Maps.newHashMap();

    private static Pair<BlockPos, GlobalPos> key(Level level, BlockPos controllerPos, BlockPos mover) {
        return Pair.of((Object)mover, (Object)GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)controllerPos));
    }

    public static void stop(Level level, BlockPos controllerPos, BlockPos mover) {
        Pair<BlockPos, GlobalPos> g = MoverSoundController.key(level, controllerPos, mover);
        if (SOUNDS.containsKey(g)) {
            AbstractTickableSoundInstance movingSound = SOUNDS.get(g);
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)movingSound);
            SOUNDS.remove(g);
        }
    }

    public static void move(Level level, BlockPos controllerPos, BlockPos mover, Vec3 pos) {
        Pair<BlockPos, GlobalPos> g = MoverSoundController.key(level, controllerPos, mover);
        if (SOUNDS.containsKey(g)) {
            SOUNDS.get(g).setPosition(pos);
        }
    }

    public static void play(Level level, BlockPos controllerPos, BlockPos mover, Vec3 pos) {
        MoverSound sound = new MoverSound((SoundEvent)Sounds.MOVER_LOOP.get(), level, mover);
        sound.setPosition(pos);
        MoverSoundController.stop(level, controllerPos, mover);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        SOUNDS.put(MoverSoundController.key(level, controllerPos, mover), sound);
    }

    public static boolean isPlaying(Level worldObj, BlockPos controllerPos, BlockPos mover) {
        MoverSound s = SOUNDS.get(MoverSoundController.key(worldObj, controllerPos, mover));
        return s != null && s.isSoundType((SoundEvent)Sounds.MOVER_LOOP.get());
    }
}

