/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt;

import cc.tweaked.internal.cobalt.Buffer;
import cc.tweaked.internal.cobalt.CachedMetamethod;
import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaInteger;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaUserdata;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.OperationHelper;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.lib.LuaLibrary;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class LuaTable
extends LuaValue {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Node[] EMPTY_NODES = new Node[0];
    private static final LuaString N = ValueFactory.valueOf("n");
    private Object[] array = EMPTY_ARRAY;
    private Node[] nodes = EMPTY_NODES;
    private int lastFree = 0;
    private boolean weakKeys;
    private boolean weakValues;
    private int metatableFlags;
    private LuaTable metatable;

    public LuaTable() {
        super(5);
        this.array = Constants.NOVALS;
    }

    public LuaTable(int narray, int nhash) {
        super(5);
        this.resize(narray, nhash, false);
    }

    public LuaTable(LuaValue[] named, LuaValue[] unnamed, Varargs lastarg) {
        super(5);
        int i;
        int nn = named != null ? named.length : 0;
        int nu = unnamed != null ? unnamed.length : 0;
        int nl = lastarg != null ? lastarg.count() : 0;
        this.resize(nu + nl, nn >> 1, false);
        for (i = 0; i < nu; ++i) {
            this.rawset(i + 1, unnamed[i]);
        }
        if (lastarg != null) {
            int n = lastarg.count();
            for (i = 1; i <= n; ++i) {
                this.rawset(nu + i, lastarg.arg(i));
            }
        }
        for (i = 0; i < nn; i += 2) {
            if (named[i + 1].isNil()) continue;
            this.rawset(named[i], named[i + 1]);
        }
    }

    public LuaTable(Varargs varargs) {
        this(varargs, 1);
    }

    public LuaTable(Varargs varargs, int firstarg) {
        super(5);
        int nskip = firstarg - 1;
        int n = Math.max(varargs.count() - nskip, 0);
        this.resize(n, 1, false);
        this.rawset(N, (LuaValue)ValueFactory.valueOf(n));
        for (int i = 1; i <= n; ++i) {
            this.rawset(i, varargs.arg(i + nskip));
        }
    }

    @Override
    public LuaTable checkTable() {
        return this;
    }

    @Override
    public LuaTable optTable(LuaTable defval) {
        return this;
    }

    public void presize(int nArray) {
        if (nArray > this.array.length) {
            this.resize(this.getHashLength(), 1 << LuaTable.log2(nArray), false);
        }
    }

    public int getArrayLength() {
        return this.array.length;
    }

    public int getHashLength() {
        return this.nodes.length;
    }

    @Override
    public LuaTable getMetatable(LuaState state) {
        return this.metatable;
    }

    public void setMetatable(LuaTable mt) {
        LuaValue mode;
        this.metatable = mt;
        boolean newWeakKeys = false;
        boolean newWeakValues = false;
        if (mt != null && (mode = mt.rawget(Constants.MODE)).isString()) {
            String m = mode.toString();
            if (m.indexOf(107) >= 0) {
                newWeakKeys = true;
            }
            if (m.indexOf(118) >= 0) {
                newWeakValues = true;
            }
        }
        if (newWeakKeys != this.weakKeys || newWeakValues != this.weakValues) {
            this.weakKeys = newWeakKeys;
            this.weakValues = newWeakValues;
            this.rehash(null, true);
        }
    }

    public void useWeak(boolean newWeakKeys, boolean newWeakValues) {
        if (newWeakKeys != this.weakKeys || newWeakValues != this.weakValues) {
            this.weakKeys = newWeakKeys;
            this.weakValues = newWeakValues;
            this.rehash(null, true);
        }
    }

    @Override
    public void setMetatable(LuaState state, LuaTable metatable) {
        this.setMetatable(metatable);
    }

    public LuaValue rawget(String key) {
        return this.rawget(ValueFactory.valueOf(key));
    }

    public void rawset(String key, LuaValue value) {
        this.rawset(ValueFactory.valueOf(key), value);
    }

    public LuaValue remove(int pos) {
        LuaValue v;
        int n = this.length();
        if (pos == 0) {
            pos = n;
        } else if (pos > n) {
            return Constants.NONE;
        }
        LuaValue r = v = this.rawget(pos);
        while (!r.isNil()) {
            r = this.rawget(pos + 1);
            this.rawset(pos++, r);
        }
        return v.isNil() ? Constants.NONE : v;
    }

    public void insert(int pos, LuaValue value) {
        if (pos == 0) {
            pos = this.length() + 1;
        }
        while (!value.isNil()) {
            LuaValue v = this.rawget(pos);
            this.rawset(pos++, value);
            value = v;
        }
    }

    public LuaValue concat(LuaString sep, int i, int j) throws LuaError {
        Buffer sb = new Buffer();
        if (i <= j) {
            sb.append(this.rawget(i).checkLuaString());
            while (++i <= j) {
                sb.append(sep);
                sb.append(this.rawget(i).checkLuaString());
            }
        }
        return sb.toLuaString();
    }

    public int length() {
        int a = this.getArrayLength();
        if (a > 0 && this.rawget(a).isNil()) {
            int n = a + 1;
            int m = 0;
            while (n - m > 1) {
                int k = (m + n) / 2;
                if (this.rawget(k).isNil()) {
                    n = k;
                    continue;
                }
                m = k;
            }
            return m;
        }
        if (this.nodes.length == 0) {
            return a;
        }
        long i = a;
        long j = i + 1L;
        while (!this.rawget((int)j).isNil()) {
            i = j;
            if ((j *= 2L) <= 0xFFFFFFFCL) continue;
            i = 1L;
            while (!this.rawget((int)i).isNil()) {
                ++i;
            }
            return (int)i - 1;
        }
        while (j - i > 1L) {
            int k = ((int)i + (int)j) / 2;
            if (!this.rawget(k).isNil()) {
                i = k;
                continue;
            }
            j = k;
        }
        return (int)i;
    }

    public double maxn() {
        double n = 0.0;
        for (int i = 0; i < this.array.length; ++i) {
            if (LuaTable.strengthen(this.array[i]).isNil()) continue;
            n = i + 1;
        }
        for (Node node : this.nodes) {
            double key;
            LuaValue value = node.key();
            if (value.type() != 3 || !((key = value.toDouble()) > n)) continue;
            n = key;
        }
        return n;
    }

    public Varargs next(LuaValue key) throws LuaError {
        int i = this.findIndex(key);
        if (i < 0) {
            throw new LuaError("invalid key to 'next'");
        }
        while (i < this.array.length) {
            LuaValue value = LuaTable.strengthen(this.array[i]);
            if (!value.isNil()) {
                return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(i + 1), (Varargs)value);
            }
            ++i;
        }
        i -= this.array.length;
        while (i < this.nodes.length) {
            Node node = this.nodes[i];
            LuaValue value = node.value();
            if (!node.key().isNil() && !value.isNil()) {
                return ValueFactory.varargsOf(node.key(), (Varargs)value);
            }
            ++i;
        }
        return Constants.NIL;
    }

    private int findIndex(LuaValue key) {
        if (key.isNil()) {
            return 0;
        }
        int arrayIndex = LuaTable.arraySlot(key);
        if (arrayIndex > 0 && arrayIndex <= this.array.length) {
            return arrayIndex;
        }
        if (this.nodes.length == 0) {
            return -1;
        }
        int idx = this.hashSlot(key);
        Node node = this.nodes[idx];
        while (true) {
            if (node.key().equals(key)) {
                return idx + this.array.length + 1;
            }
            if (node.next < 0) break;
            idx = node.next;
            node = this.nodes[node.next];
        }
        return -1;
    }

    public Varargs inext(LuaValue key) throws LuaError {
        int k = key.checkInteger() + 1;
        LuaValue v = this.rawget(k);
        return v.isNil() ? Constants.NONE : ValueFactory.varargsOf((LuaValue)LuaInteger.valueOf(k), (Varargs)v);
    }

    private static int hashpow2(int hashCode, int mask) {
        return hashCode & mask;
    }

    private static int hashmod(int hashCode, int mask) {
        return (hashCode & Integer.MAX_VALUE) % (mask | 1);
    }

    private static int hashSlot(LuaValue key, int hashMask) {
        switch (key.type()) {
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                return LuaTable.hashmod(key.hashCode(), hashMask);
            }
        }
        return LuaTable.hashpow2(key.hashCode(), hashMask);
    }

    private static int arraySlot(LuaValue value) {
        int val;
        if (value instanceof LuaInteger && (val = ((LuaInteger)value).v) > 0) {
            return val;
        }
        return 0;
    }

    private int hashSlot(LuaValue key) {
        return LuaTable.hashSlot(key, this.nodes.length - 1);
    }

    private void dropWeakArrayValues() {
        for (int i = 0; i < this.array.length; ++i) {
            Object x = this.array[i];
            if (x == Constants.NIL || !LuaTable.strengthen(x).isNil()) continue;
            this.array[i] = Constants.NIL;
        }
    }

    private static int log2(int x) {
        int lg = 0;
        if (--x < 0) {
            return Integer.MIN_VALUE;
        }
        if ((x & 0xFFFF0000) != 0) {
            lg = 16;
            x >>>= 16;
        }
        if ((x & 0xFF00) != 0) {
            lg += 8;
            x >>>= 8;
        }
        if ((x & 0xF0) != 0) {
            lg += 4;
            x >>>= 4;
        }
        switch (x) {
            case 0: {
                return 0;
            }
            case 1: {
                ++lg;
                break;
            }
            case 2: {
                lg += 2;
                break;
            }
            case 3: {
                lg += 2;
                break;
            }
            case 4: {
                lg += 3;
                break;
            }
            case 5: {
                lg += 3;
                break;
            }
            case 6: {
                lg += 3;
                break;
            }
            case 7: {
                lg += 3;
                break;
            }
            case 8: {
                lg += 4;
                break;
            }
            case 9: {
                lg += 4;
                break;
            }
            case 10: {
                lg += 4;
                break;
            }
            case 11: {
                lg += 4;
                break;
            }
            case 12: {
                lg += 4;
                break;
            }
            case 13: {
                lg += 4;
                break;
            }
            case 14: {
                lg += 4;
                break;
            }
            case 15: {
                lg += 4;
            }
        }
        return lg;
    }

    public boolean compare(LuaState state, int i, int j, LuaValue cmpfunc) throws LuaError, UnwindThrowable {
        LuaValue a = LuaTable.strengthen(this.rawget(i));
        LuaValue b = LuaTable.strengthen(this.rawget(j));
        if (!cmpfunc.isNil()) {
            return OperationHelper.call(state, cmpfunc, a, b).toBoolean();
        }
        if (a.isNil() || b.isNil()) {
            return false;
        }
        return OperationHelper.lt(state, a, b);
    }

    public void swap(int i, int j) {
        LuaValue a = this.rawget(i);
        this.rawset(i, this.rawget(j));
        this.rawset(j, a);
    }

    public int keyCount() throws LuaError {
        LuaValue k = Constants.NIL;
        int i = 0;
        Varargs n;
        while (!(k = (n = this.next(k)).first()).isNil()) {
            ++i;
        }
        return i;
    }

    public LuaValue[] keys() throws LuaError {
        Varargs n;
        ArrayList<LuaValue> l = new ArrayList<LuaValue>();
        LuaValue k = Constants.NIL;
        while (!(k = (n = this.next(k)).first()).isNil()) {
            l.add(k);
        }
        return l.toArray(new LuaValue[l.size()]);
    }

    public LuaValue load(LuaState state, LuaLibrary library) {
        return library.add(state, this);
    }

    private static Object[] setArrayVector(Object[] oldArray, int n, boolean metaChange, boolean weakValues) {
        int i;
        Object[] newArray = new Object[n];
        int len = Math.min(n, oldArray.length);
        if (metaChange) {
            for (i = 0; i < len; ++i) {
                LuaValue value = LuaTable.strengthen(oldArray[i]);
                newArray[i] = weakValues ? LuaTable.weaken(value) : value;
            }
        } else {
            System.arraycopy(oldArray, 0, newArray, 0, Math.min(n, oldArray.length));
        }
        for (i = oldArray.length; i < newArray.length; ++i) {
            newArray[i] = Constants.NIL;
        }
        return newArray;
    }

    private static int countInt(LuaValue key, int[] nums) {
        int idx = LuaTable.arraySlot(key);
        if (idx != 0) {
            int n = LuaTable.log2(idx);
            nums[n] = nums[n] + 1;
            return 1;
        }
        return 0;
    }

    private int numUseArray(int[] nums) {
        int ause = 0;
        int i = 1;
        int lg = 0;
        int ttlg = 1;
        while (lg <= 31) {
            int lc = 0;
            int lim = ttlg;
            if (lim > this.array.length && i > (lim = this.array.length)) break;
            while (i <= lim) {
                LuaValue value = LuaTable.strengthen(this.array[i - 1]);
                if (!value.isNil()) {
                    ++lc;
                }
                ++i;
            }
            int n = lg++;
            nums[n] = nums[n] + lc;
            ause += lc;
            ttlg *= 2;
        }
        return ause;
    }

    private void setNodeVector(int size) {
        if (size == 0) {
            this.nodes = EMPTY_NODES;
            this.lastFree = 0;
        } else {
            int lsize = LuaTable.log2(size);
            size = 1 << lsize;
            this.nodes = new Node[size];
            Node[] nodes = this.nodes;
            for (int i = 0; i < size; ++i) {
                nodes[i] = new Node(this.weakKeys, this.weakValues);
            }
            this.lastFree = size - 1;
        }
    }

    private void resize(int newArraySize, int newHashSize, boolean modeChange) {
        LuaValue value;
        int i;
        int oldArraySize = this.array.length;
        int oldHashSize = this.nodes.length;
        if (newArraySize != 0 && newHashSize != 0 && newArraySize == oldArraySize && newHashSize == oldHashSize && !modeChange) {
            throw new IllegalStateException("Attempting to resize with no change");
        }
        if (newArraySize > oldArraySize) {
            this.array = LuaTable.setArrayVector(this.array, newArraySize, modeChange, this.weakValues);
        }
        Node[] oldNode = this.nodes;
        this.setNodeVector(newHashSize);
        if (newArraySize < oldArraySize) {
            Object[] oldArray = this.array;
            this.array = LuaTable.setArrayVector(oldArray, newArraySize, modeChange, this.weakValues);
            for (i = newArraySize; i < oldArraySize; ++i) {
                value = LuaTable.strengthen(oldArray[i]);
                if (value.isNil()) continue;
                this.rawset(i + 1, value);
            }
        } else if (newArraySize == oldArraySize && modeChange) {
            Object[] values = this.array;
            for (i = 0; i < oldArraySize; ++i) {
                value = LuaTable.strengthen(values[i]);
                values[i] = this.weakValues ? LuaTable.weaken(value) : value;
            }
        }
        for (int i2 = oldHashSize - 1; i2 >= 0; --i2) {
            Node old = oldNode[i2];
            LuaValue key = old.key();
            LuaValue value2 = old.value();
            if (key.isNil() || value2.isNil()) continue;
            this.rawset(key, value2);
        }
    }

    private void rehash(LuaValue extraKey, boolean mode) {
        int arrayCount;
        if (this.weakValues) {
            this.dropWeakArrayValues();
        }
        int[] nums = new int[32];
        int arraySize = 0;
        int totalCount = arrayCount = this.numUseArray(nums);
        int i = this.nodes.length;
        while (--i >= 0) {
            Node node = this.nodes[i];
            LuaValue key = node.key();
            if (key.isNil()) continue;
            arrayCount += LuaTable.countInt(key, nums);
            ++totalCount;
        }
        if (extraKey != null) {
            arrayCount += LuaTable.countInt(extraKey, nums);
            ++totalCount;
        }
        int sum = 0;
        int numArray = 0;
        int i1 = 0;
        int twoPow = 1;
        while (arrayCount > twoPow / 2) {
            if (nums[i1] > 0 && (sum += nums[i1]) > twoPow / 2) {
                arraySize = twoPow;
                numArray = sum;
            }
            ++i1;
            twoPow *= 2;
        }
        assert ((arraySize == 0 || arraySize / 2 < numArray) && numArray <= arraySize);
        arrayCount = numArray;
        this.resize(arraySize, totalCount - arrayCount, mode);
    }

    private int getFreePos() {
        if (this.nodes.length == 0) {
            return -1;
        }
        while (this.lastFree >= 0) {
            Node last = this.nodes[this.lastFree--];
            if (last.key != Constants.NIL) continue;
            return this.lastFree + 1;
        }
        return -1;
    }

    private Node newKey(LuaValue key) {
        if (key.isNil()) {
            throw new IllegalArgumentException("table index is nil");
        }
        if (this.nodes.length == 0) {
            this.rehash(key, false);
            return null;
        }
        Node mainNode = this.nodes[this.hashSlot(key)];
        LuaValue mainKey = mainNode.key();
        if (!mainKey.isNil() && !mainNode.value().isNil()) {
            int freePos = this.getFreePos();
            if (freePos < 0) {
                this.rehash(key, false);
                return null;
            }
            Node freeNode = this.nodes[freePos];
            int otherPos = this.hashSlot(mainKey);
            Node otherNode = this.nodes[otherPos];
            if (otherNode != mainNode) {
                while (this.nodes[otherNode.next] != mainNode) {
                    otherNode = this.nodes[otherNode.next];
                }
                otherNode.next = freePos;
                freeNode.key = mainNode.key;
                freeNode.value = mainNode.value;
                freeNode.next = mainNode.next;
                mainNode.next = -1;
                mainNode.key = Constants.NIL;
                mainNode.value = Constants.NIL;
            } else {
                if (mainNode.next != -1) {
                    freeNode.next = mainNode.next;
                } else assert (freeNode.next == -1);
                mainNode.next = freePos;
                mainNode = freeNode;
            }
        }
        mainNode.key = this.weakKeys ? LuaTable.weaken(key) : key;
        return mainNode;
    }

    private Node rawgetNode(int search) {
        if (this.nodes.length == 0) {
            return null;
        }
        Node node = this.nodes[LuaTable.hashmod(search, this.nodes.length - 1)];
        LuaValue key;
        while (!((key = node.key()) instanceof LuaInteger) || ((LuaInteger)key).v != search) {
            int next = node.next;
            if (next == -1) {
                return null;
            }
            node = this.nodes[next];
        }
        return node;
    }

    private Node rawgetNode(LuaValue search) {
        if (this.nodes.length == 0) {
            return null;
        }
        int slot = this.hashSlot(search);
        Node node = this.nodes[slot];
        LuaValue key;
        while (!(key = node.key()).equals(search)) {
            int next = node.next;
            if (next == -1) {
                return null;
            }
            node = this.nodes[next];
        }
        return node;
    }

    public LuaValue rawget(int search) {
        if (search > 0 && search <= this.array.length) {
            return LuaTable.strengthen(this.array[search - 1]);
        }
        if (this.nodes.length == 0) {
            return Constants.NIL;
        }
        Node node = this.rawgetNode(search);
        return node == null ? Constants.NIL : node.value();
    }

    public LuaValue rawget(LuaValue search) {
        if (search instanceof LuaInteger) {
            return this.rawget(((LuaInteger)search).v);
        }
        Node node = this.rawgetNode(search);
        return node == null ? Constants.NIL : node.value();
    }

    public LuaValue rawget(CachedMetamethod search) {
        LuaValue value;
        int flag = 1 << search.ordinal();
        if ((this.metatableFlags & flag) != 0) {
            return Constants.NIL;
        }
        Node node = this.rawgetNode(search.getKey());
        if (node != null && !(value = node.value()).isNil()) {
            return value;
        }
        this.metatableFlags |= flag;
        return Constants.NIL;
    }

    public void rawset(int key, LuaValue value) {
        Node node;
        LuaInteger valueOf = null;
        do {
            if (key > 0 && key <= this.array.length) {
                this.array[key - 1] = this.weakValues ? LuaTable.weaken(value) : value;
                return;
            }
            if (valueOf == null) {
                valueOf = ValueFactory.valueOf(key);
            }
            if ((node = this.rawgetNode(valueOf)) != null) continue;
            node = this.newKey(valueOf);
        } while (node == null);
        node.value = this.weakValues ? LuaTable.weaken(value) : value;
    }

    public void rawset(LuaValue key, LuaValue value) {
        Node node;
        if (key instanceof LuaInteger) {
            this.rawset(((LuaInteger)key).v, value);
            return;
        }
        do {
            if ((node = this.rawgetNode(key)) != null) continue;
            node = this.newKey(key);
        } while (node == null);
        node.value = this.weakValues ? LuaTable.weaken(value) : value;
        this.metatableFlags = 0;
    }

    private static Object weaken(LuaValue value) {
        switch (value.type()) {
            case 5: 
            case 6: 
            case 8: {
                return new WeakReference<LuaValue>(value);
            }
            case 7: {
                return new WeakUserdata((LuaUserdata)value);
            }
        }
        return value;
    }

    static LuaValue strengthen(Object ref) {
        if (ref instanceof WeakReference) {
            LuaValue value = (LuaValue)((WeakReference)ref).get();
            return value == null ? Constants.NIL : value;
        }
        if (ref instanceof WeakUserdata) {
            return ((WeakUserdata)ref).strongValue();
        }
        return (LuaValue)ref;
    }

    private static final class Node {
        private final boolean weakKey;
        private final boolean weakValue;
        Object value = Constants.NIL;
        Object key = Constants.NIL;
        int next = -1;

        Node(boolean weakKey, boolean weakValue) {
            this.weakKey = weakKey;
            this.weakValue = weakValue;
        }

        public String toString() {
            String main = this.key + "=" + this.value;
            if (this.next >= 0) {
                main = main + "->" + this.next;
            }
            return main;
        }

        LuaValue key() {
            Object key = this.key;
            if (key == Constants.NIL || !this.weakKey) {
                return (LuaValue)key;
            }
            LuaValue strengthened = LuaTable.strengthen(key);
            if (strengthened.isNil()) {
                this.value = Constants.NIL;
            }
            return strengthened;
        }

        LuaValue value() {
            Object value = this.value;
            if (value == Constants.NIL || !this.weakValue) {
                return (LuaValue)value;
            }
            LuaValue strengthened = LuaTable.strengthen(value);
            if (strengthened.isNil()) {
                this.value = Constants.NIL;
            }
            return strengthened;
        }
    }

    private static final class WeakUserdata {
        private WeakReference<LuaValue> ref;
        private final WeakReference<Object> ob;
        private final LuaTable mt;

        private WeakUserdata(LuaUserdata value) {
            this.ref = new WeakReference<LuaUserdata>(value);
            this.ob = new WeakReference<Object>(value.instance);
            this.mt = value.metatable;
        }

        public LuaValue strongValue() {
            LuaValue u = (LuaValue)this.ref.get();
            if (u != null) {
                return u;
            }
            Object o = this.ob.get();
            if (o != null) {
                LuaUserdata ud = ValueFactory.userdataOf(o, this.mt);
                this.ref = new WeakReference<LuaUserdata>(ud);
                return ud;
            }
            return Constants.NIL;
        }
    }
}

