/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.compiler;

import cc.tweaked.internal.cobalt.LuaNumber;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.compiler.CompileException;
import cc.tweaked.internal.cobalt.compiler.LoadState;
import cc.tweaked.internal.cobalt.compiler.LuaC;
import cc.tweaked.internal.cobalt.lib.Utf8Lib;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class Lex {
    private static final int EOZ = -1;
    static final int MAX_INT = 0x7FFFFFFD;
    private static final int POSITION_SHIFT = 32;
    private static final long POSITION_MASK = 0xFFFFFFFFL;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_DO = 259;
    static final int TK_ELSE = 260;
    static final int TK_ELSEIF = 261;
    static final int TK_END = 262;
    static final int TK_FALSE = 263;
    static final int TK_FOR = 264;
    static final int TK_FUNCTION = 265;
    static final int TK_IF = 266;
    static final int TK_IN = 267;
    static final int TK_LOCAL = 268;
    static final int TK_NIL = 269;
    static final int TK_NOT = 270;
    static final int TK_OR = 271;
    static final int TK_REPEAT = 272;
    static final int TK_RETURN = 273;
    static final int TK_THEN = 274;
    static final int TK_TRUE = 275;
    static final int TK_UNTIL = 276;
    static final int TK_WHILE = 277;
    static final int TK_CONCAT = 278;
    static final int TK_DOTS = 279;
    static final int TK_EQ = 280;
    static final int TK_GE = 281;
    static final int TK_LE = 282;
    static final int TK_NE = 283;
    static final int TK_EOS = 284;
    static final int TK_NUMBER = 285;
    static final int TK_NAME = 286;
    static final int TK_STRING = 287;
    private static final String[] tokenNames = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "<eof>", "<number>", "<name>", "<string>"};
    private static final int FIRST_RESERVED = 257;
    private static final int NUM_RESERVED = 21;
    private static final Map<LuaString, Integer> RESERVED;
    private int current;
    final LuaString source;
    private final InputStream z;
    private int lineNumber = 1;
    private int columnNumber = 1;
    private long lastPosition = 0x100000001L;
    private final HashMap<LuaString, LuaString> strings = new HashMap();
    final Token token = new Token();
    final Token lookahead = new Token();
    private byte[] buff = new byte[32];
    private int bufferSize;

    Lex(LuaString source, InputStream z, int current) {
        this.source = source;
        this.z = z;
        this.current = current;
        this.token.token = 0;
        this.lookahead.token = 284;
    }

    private void next() {
        try {
            this.current = this.z.read();
            ++this.columnNumber;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void save(int toSave) {
        if (this.buff == null || this.bufferSize + 1 > this.buff.length) {
            this.buff = LuaC.realloc(this.buff, this.bufferSize * 2 + 1);
        }
        this.buff[this.bufferSize++] = (byte)toSave;
    }

    private boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    private void saveAndNext() {
        this.save(this.current);
        this.next();
    }

    static String token2str(int token) {
        if (token < 257) {
            if (token >= 32 && token <= 126) {
                return "'" + (char)token + "'";
            }
            return "<\\" + token + ">'";
        }
        String name = tokenNames[token - 257];
        return token < 284 ? "'" + name + "'" : name;
    }

    private String txtToken(int token) {
        switch (token) {
            case 285: 
            case 286: 
            case 287: {
                return "'" + LuaString.valueOf(this.buff, 0, this.bufferSize) + "'";
            }
        }
        return Lex.token2str(token);
    }

    CompileException lexError(String msg, int token) {
        LuaString cid = LoadState.getShortName(this.source);
        String message = cid + ":" + this.lineNumber + ": " + msg;
        if (token != 0) {
            message = message + " near " + this.txtToken(token);
        }
        return new CompileException(message);
    }

    CompileException syntaxError(String msg) {
        return this.lexError(msg, this.token.token());
    }

    LuaString newString(byte[] bytes, int offset, int len) {
        LuaString string = LuaString.valueOf(bytes, offset, len);
        LuaString interned = this.strings.get(string);
        if (interned == null) {
            byte[] slice = new byte[len];
            System.arraycopy(bytes, offset, slice, 0, len);
            interned = LuaString.valueOf(slice);
            this.strings.put(interned, interned);
        }
        return interned;
    }

    LuaString newString(String value) {
        LuaString string = LuaString.valueOf(value);
        return this.strings.computeIfAbsent(string, Function.identity());
    }

    private void inclineNumber() throws CompileException {
        int old = this.current;
        assert (this.currIsNewline());
        this.next();
        if (this.currIsNewline() && this.current != old) {
            this.next();
        }
        if (++this.lineNumber >= 0x7FFFFFFD) {
            throw this.lexError("chunk has too many lines", 0);
        }
        this.columnNumber = 1;
    }

    private boolean checkNext(char character) {
        if (this.current == character) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean checkNext(char c1, char c2) {
        if (this.current == c1 || this.current == c2) {
            this.saveAndNext();
            return true;
        }
        return false;
    }

    private LuaNumber parseNumber(String str) throws CompileException {
        if (str.startsWith("0x") || str.startsWith("0X")) {
            try {
                return ValueFactory.valueOf(Long.valueOf(str.substring(2), 16).longValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return ValueFactory.valueOf(Double.parseDouble(str));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.lexError("malformed number", 285);
        }
    }

    private LuaNumber readNumeral() throws CompileException {
        assert (Lex.isDigit(this.current));
        int first = this.current;
        this.saveAndNext();
        int exp1 = 69;
        int exp2 = 101;
        if (first == 48 && this.checkNext('x', 'X')) {
            exp1 = 80;
            exp2 = 112;
        }
        while (true) {
            if (this.checkNext((char)exp1, (char)exp2)) {
                this.checkNext('+', '-');
            }
            if (!Lex.isHex(this.current) && this.current != 46) break;
            this.saveAndNext();
        }
        return this.parseNumber(new String(this.buff, 0, this.bufferSize));
    }

    private int skipSep() {
        int count = 0;
        int s = this.current;
        assert (s == 91 || s == 93);
        this.saveAndNext();
        while (this.current == 61) {
            this.saveAndNext();
            ++count;
        }
        if (this.current == s) {
            return count + 2;
        }
        return count == 0 ? 1 : 0;
    }

    private void readLongString(Token token, int sep) throws CompileException {
        int line = this.lineNumber;
        this.saveAndNext();
        if (this.currIsNewline()) {
            this.inclineNumber();
        }
        block6: while (true) {
            switch (this.current) {
                case -1: {
                    throw this.lexError("unfinished long " + (token != null ? "string" : "comment") + " (started at line " + line + ")", 284);
                }
                case 91: {
                    if (this.skipSep() != sep) continue block6;
                    this.saveAndNext();
                    if (sep != 2) continue block6;
                    throw this.lexError("nesting of [[...]] is deprecated", 91);
                }
                case 93: {
                    if (this.skipSep() != sep) continue block6;
                    this.saveAndNext();
                    if (token != null) {
                        token.value = this.newString(this.buff, sep, this.bufferSize - 2 * sep);
                    }
                    return;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclineNumber();
                    if (token != null) continue block6;
                    this.bufferSize = 0;
                    continue block6;
                }
            }
            if (token != null) {
                this.saveAndNext();
                continue;
            }
            this.next();
        }
    }

    private CompileException escapeError(String message) {
        if (this.current != -1) {
            this.saveAndNext();
        }
        return this.lexError(message, 287);
    }

    private int readHex() throws CompileException {
        this.saveAndNext();
        if (!Lex.isHex(this.current)) {
            throw this.escapeError("hexadecimal digit expected");
        }
        return Lex.hexValue(this.current);
    }

    private int readHexEsc() throws CompileException {
        int r = this.readHex() << 4 | this.readHex();
        this.bufferSize -= 2;
        return r;
    }

    private void readUtf8Esc() throws CompileException {
        long codepoint;
        int i;
        block6: {
            this.saveAndNext();
            if (this.current != 123) {
                throw this.escapeError("mising '{'");
            }
            i = 4;
            codepoint = this.readHex();
            do {
                this.saveAndNext();
                if (!Lex.isHex(this.current)) break block6;
                ++i;
            } while ((codepoint = codepoint << 4 | (long)Lex.hexValue(this.current)) <= 0x10FFFFL);
            throw this.escapeError("UTF-8 value too large");
        }
        if (this.current != 125) {
            throw this.escapeError("missing '}'");
        }
        this.next();
        this.bufferSize -= i;
        if (codepoint < 128L) {
            this.save((int)codepoint);
        } else {
            byte[] buffer = new byte[8];
            for (int j = Utf8Lib.buildCharacter(buffer, codepoint); j > 0; --j) {
                this.save(buffer[8 - j]);
            }
        }
    }

    private int readDecEsc() throws CompileException {
        int i;
        int result = 0;
        for (i = 0; i < 3 && Lex.isDigit(this.current); ++i) {
            result = 10 * result + this.current - 48;
            this.saveAndNext();
        }
        if (result > 255) {
            throw this.escapeError("escape sequence too large");
        }
        this.bufferSize -= i;
        return result;
    }

    private LuaString readString(int del) throws CompileException {
        this.saveAndNext();
        block19: while (this.current != del) {
            switch (this.current) {
                case -1: {
                    throw this.lexError("unfinished string", 284);
                }
                case 10: 
                case 13: {
                    throw this.lexError("unfinished string", 287);
                }
                case 92: {
                    this.saveAndNext();
                    switch (this.current) {
                        case 97: {
                            this.saveEscape(7);
                            continue block19;
                        }
                        case 98: {
                            this.saveEscape(8);
                            continue block19;
                        }
                        case 102: {
                            this.saveEscape(12);
                            continue block19;
                        }
                        case 110: {
                            this.saveEscape(10);
                            continue block19;
                        }
                        case 114: {
                            this.saveEscape(13);
                            continue block19;
                        }
                        case 116: {
                            this.saveEscape(9);
                            continue block19;
                        }
                        case 118: {
                            this.saveEscape(11);
                            continue block19;
                        }
                        case 120: {
                            this.saveEscape(this.readHexEsc());
                            continue block19;
                        }
                        case 117: {
                            this.readUtf8Esc();
                            continue block19;
                        }
                        case 10: 
                        case 13: {
                            --this.bufferSize;
                            this.save(10);
                            this.inclineNumber();
                            continue block19;
                        }
                        case -1: {
                            continue block19;
                        }
                        case 122: {
                            --this.bufferSize;
                            this.next();
                            while (this.current != -1 && Lex.isSpace(this.current)) {
                                if (this.currIsNewline()) {
                                    this.inclineNumber();
                                }
                                this.next();
                            }
                            continue block19;
                        }
                    }
                    if (!Lex.isDigit(this.current)) {
                        --this.bufferSize;
                        this.saveAndNext();
                        continue block19;
                    }
                    int c = this.readDecEsc();
                    --this.bufferSize;
                    this.save(c);
                    continue block19;
                }
            }
            this.saveAndNext();
        }
        this.saveAndNext();
        return this.newString(this.buff, 1, this.bufferSize - 2);
    }

    private void saveEscape(int character) {
        this.next();
        --this.bufferSize;
        this.save(character);
    }

    private int lexToken(Token token) throws CompileException {
        this.bufferSize = 0;
        block12: while (true) {
            token.position = Lex.packPosition(this.lineNumber, this.columnNumber);
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclineNumber();
                    continue block12;
                }
                case 45: {
                    int sep;
                    this.next();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.next();
                    if (this.current == 91) {
                        sep = this.skipSep();
                        this.bufferSize = 0;
                        if (sep >= 2) {
                            this.readLongString(null, sep);
                            this.bufferSize = 0;
                            continue block12;
                        }
                    }
                    while (true) {
                        if (this.currIsNewline() || this.current == -1) continue block12;
                        this.next();
                    }
                }
                case 91: {
                    int sep = this.skipSep();
                    if (sep >= 2) {
                        this.readLongString(token, sep);
                        return 287;
                    }
                    if (sep == 0) {
                        throw this.lexError("invalid long string delimiter", 287);
                    }
                    return 91;
                }
                case 61: {
                    this.next();
                    return this.checkNext('=') ? 280 : 61;
                }
                case 60: {
                    this.next();
                    return this.checkNext('=') ? 282 : 60;
                }
                case 62: {
                    this.next();
                    return this.checkNext('=') ? 281 : 62;
                }
                case 126: {
                    this.next();
                    return this.checkNext('=') ? 283 : 126;
                }
                case 34: 
                case 39: {
                    token.value = this.readString(this.current);
                    return 287;
                }
                case 46: {
                    this.saveAndNext();
                    if (this.checkNext('.')) {
                        if (this.checkNext('.')) {
                            return 279;
                        }
                        return 278;
                    }
                    if (!Lex.isDigit(this.current)) {
                        return 46;
                    }
                    token.value = this.readNumeral();
                    return 285;
                }
                case -1: {
                    return 284;
                }
            }
            if (!Lex.isSpace(this.current)) break;
            this.next();
        }
        if (Lex.isDigit(this.current)) {
            token.value = this.readNumeral();
            return 285;
        }
        if (Lex.isAlpha(this.current) || this.current == 95) {
            do {
                this.saveAndNext();
            } while (Lex.isAlphaNum(this.current) || this.current == 95);
            LuaString ts = this.newString(this.buff, 0, this.bufferSize);
            if (RESERVED.containsKey(ts)) {
                return RESERVED.get(ts);
            }
            token.value = ts;
            return 286;
        }
        int c = this.current;
        this.next();
        return c;
    }

    int lastLine() {
        return Lex.unpackLine(this.lastPosition);
    }

    long lastPosition() {
        return this.lastPosition;
    }

    void skipShebang() {
        if (this.current == 35) {
            while (!this.currIsNewline() && this.current != -1) {
                this.next();
            }
        }
    }

    void nextToken() throws CompileException {
        this.lastPosition = Lex.packPosition(this.lineNumber, this.columnNumber);
        if (this.lookahead.token != 284) {
            this.token.set(this.lookahead);
            this.lookahead.token = 284;
        } else {
            this.token.token = this.lexToken(this.token);
        }
    }

    void lookahead() throws CompileException {
        LuaC._assert(this.lookahead.token == 284);
        this.lookahead.token = this.lexToken(this.lookahead);
    }

    private static boolean isAlphaNum(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private static boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isSpace(int c) {
        return c <= 32;
    }

    private static boolean isHex(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private static int hexValue(int c) {
        return c <= 57 ? c - 48 : (c & 0xF) + 9;
    }

    static long packPosition(int line, int column) {
        return (long)line | (long)column << 32;
    }

    static int unpackLine(long position) {
        return (int)(position & 0xFFFFFFFFL);
    }

    static int unpackColumn(long position) {
        return (int)(position >> 32 & 0xFFFFFFFFL);
    }

    static {
        HashMap<LuaString, Integer> reserved = new HashMap<LuaString, Integer>();
        for (int i = 0; i < 21; ++i) {
            reserved.put(ValueFactory.valueOf(tokenNames[i]), 257 + i);
        }
        RESERVED = Collections.unmodifiableMap(reserved);
    }

    static class Token {
        private int token;
        private LuaValue value;
        private long position;

        Token() {
        }

        private void set(Token other) {
            this.token = other.token;
            this.value = other.value;
            this.position = other.position;
        }

        int token() {
            return this.token;
        }

        int line() {
            return (int)(this.position & 0xFFFFFFFFL);
        }

        long position() {
            return this.position;
        }

        LuaString stringContents() {
            return (LuaString)this.value;
        }

        LuaNumber numberContents() {
            return (LuaNumber)this.value;
        }
    }
}

