/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.function;

import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.function.LibFunction;
import cc.tweaked.internal.cobalt.function.OneArgFunction;
import cc.tweaked.internal.cobalt.function.ThreeArgFunction;
import cc.tweaked.internal.cobalt.function.TwoArgFunction;
import cc.tweaked.internal.cobalt.function.VarArgFunction;
import cc.tweaked.internal.cobalt.function.ZeroArgFunction;

public class RegisteredFunction {
    private final String name;
    private final LibFunction function;

    private RegisteredFunction(String name, LibFunction function) {
        this.name = name;
        this.function = function;
    }

    public LibFunction create(LuaTable env) {
        this.function.name = this.name;
        this.function.env = env;
        return this.function;
    }

    public static void bind(LuaTable env, LuaTable table, RegisteredFunction[] functions) {
        for (RegisteredFunction def : functions) {
            table.rawset(def.name, (LuaValue)def.create(env));
        }
    }

    public static RegisteredFunction of(String name, LibFunction fn) {
        return new RegisteredFunction(name, fn);
    }

    public static RegisteredFunction of(String name, final ZeroArgFunction.Signature fn) {
        return new RegisteredFunction(name, new ZeroArgFunction(){

            @Override
            public LuaValue call(LuaState state) throws LuaError, UnwindThrowable {
                return fn.call(state);
            }
        });
    }

    public static RegisteredFunction of(String name, final OneArgFunction.Signature fn) {
        return new RegisteredFunction(name, new OneArgFunction(){

            @Override
            public LuaValue call(LuaState state, LuaValue arg) throws LuaError, UnwindThrowable {
                return fn.call(state, arg);
            }
        });
    }

    public static RegisteredFunction of(String name, final TwoArgFunction.Signature fn) {
        return new RegisteredFunction(name, new TwoArgFunction(){

            @Override
            public LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError, UnwindThrowable {
                return fn.call(state, arg1, arg2);
            }
        });
    }

    public static RegisteredFunction of(String name, final ThreeArgFunction.Signature fn) {
        return new RegisteredFunction(name, new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2, LuaValue arg3) throws LuaError, UnwindThrowable {
                return fn.call(state, arg1, arg2, arg3);
            }
        });
    }

    public static RegisteredFunction ofV(String name, final VarArgFunction.Signature fn) {
        return new RegisteredFunction(name, new VarArgFunction(){

            @Override
            public Varargs invoke(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
                return fn.invoke(state, args);
            }
        });
    }
}

