/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeDataProvider;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TurtleUpgradeDataProvider
extends UpgradeDataProvider<ITurtleUpgrade, TurtleUpgradeSerialiser<?>> {
    private static final ResourceLocation TOOL_ID = new ResourceLocation("computercraft", "tool");

    public TurtleUpgradeDataProvider(DataGenerator generator) {
        super(generator, "Turtle Upgrades", "computercraft/turtle_upgrades", TurtleUpgradeSerialiser.REGISTRY_ID);
    }

    @Nonnull
    public final ToolBuilder tool(@Nonnull ResourceLocation id, @Nonnull Item item) {
        return new ToolBuilder(id, (TurtleUpgradeSerialiser)this.existingSerialiser(TOOL_ID), item);
    }

    public static class ToolBuilder {
        private final ResourceLocation id;
        private final TurtleUpgradeSerialiser<?> serialiser;
        private final Item toolItem;
        private String adjective;
        private Item craftingItem;
        private Float damageMultiplier = null;
        private TagKey<Block> breakable;

        ToolBuilder(ResourceLocation id, TurtleUpgradeSerialiser<?> serialiser, Item toolItem) {
            this.id = id;
            this.serialiser = serialiser;
            this.toolItem = toolItem;
            this.craftingItem = null;
        }

        @Nonnull
        public ToolBuilder adjective(@Nonnull String adjective) {
            this.adjective = adjective;
            return this;
        }

        @Nonnull
        public ToolBuilder craftingItem(@Nonnull Item craftingItem) {
            this.craftingItem = craftingItem;
            return this;
        }

        public ToolBuilder damageMultiplier(float damageMultiplier) {
            this.damageMultiplier = Float.valueOf(damageMultiplier);
            return this;
        }

        public ToolBuilder breakable(@Nonnull TagKey<Block> breakable) {
            this.breakable = breakable;
            return this;
        }

        public void add(@Nonnull Consumer<UpgradeDataProvider.Upgrade<TurtleUpgradeSerialiser<?>>> add) {
            add.accept(new UpgradeDataProvider.Upgrade(this.id, this.serialiser, s -> {
                s.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.toolItem).toString());
                if (this.adjective != null) {
                    s.addProperty("adjective", this.adjective);
                }
                if (this.craftingItem != null) {
                    s.addProperty("craftItem", ForgeRegistries.ITEMS.getKey((Object)this.craftingItem).toString());
                }
                if (this.damageMultiplier != null) {
                    s.addProperty("damageMultiplier", (Number)this.damageMultiplier);
                }
                if (this.breakable != null) {
                    s.addProperty("breakable", this.breakable.f_203868_().toString());
                }
            }));
        }
    }
}

