/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class ItemToast
implements Toast {
    public static final Object TRANSFER_NO_RESPONSE_TOKEN = new Object();
    private static final long DISPLAY_TIME = 7000L;
    private static final int MAX_LINE_SIZE = 200;
    private static final int IMAGE_SIZE = 16;
    private static final int LINE_SPACING = 10;
    private static final int MARGIN = 8;
    private final ItemStack stack;
    private final Component title;
    private final List<FormattedCharSequence> message;
    private final Object token;
    private final int width;
    private boolean isNew = true;
    private long firstDisplay;

    public ItemToast(Minecraft minecraft, ItemStack stack, Component title, Component message, Object token) {
        this.stack = stack;
        this.title = title;
        this.token = token;
        Font font = minecraft.f_91062_;
        this.message = font.m_92923_((FormattedText)message, 200);
        this.width = Math.max(200, this.message.stream().mapToInt(arg_0 -> ((Font)font).m_92724_(arg_0)).max().orElse(200)) + 24 + 16;
    }

    public void showOrReplace(ToastComponent toasts) {
        ItemToast existing = (ItemToast)toasts.m_94926_(ItemToast.class, this.m_7283_());
        if (existing != null) {
            existing.isNew = true;
        } else {
            toasts.m_94922_((Toast)this);
        }
    }

    public int m_7828_() {
        return this.width;
    }

    public int m_94899_() {
        return 26 + this.message.size() * 10;
    }

    @Nonnull
    public Object m_7283_() {
        return this.token;
    }

    @Nonnull
    public Toast.Visibility m_7172_(@Nonnull PoseStack transform, @Nonnull ToastComponent component, long time) {
        if (this.isNew) {
            this.firstDisplay = time;
            this.isNew = false;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_94893_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.width == 160 && this.message.size() <= 1) {
            component.m_93228_(transform, 0, 0, 0, 64, this.width, this.m_94899_());
        } else {
            int height = this.m_94899_();
            int bottom = Math.min(4, height - 28);
            ItemToast.renderBackgroundRow(transform, component, this.width, 0, 0, 28);
            for (int i = 28; i < height - bottom; i += 10) {
                ItemToast.renderBackgroundRow(transform, component, this.width, 16, i, Math.min(16, height - i - bottom));
            }
            ItemToast.renderBackgroundRow(transform, component, this.width, 32 - bottom, height - bottom, bottom);
        }
        int textX = 8;
        if (!this.stack.m_41619_()) {
            textX += 24;
            component.m_94929_().m_91291_().m_115218_(this.stack, 8, 8 + this.m_94899_() / 2 - 16);
        }
        component.m_94929_().f_91062_.m_92889_(transform, this.title, (float)textX, 8.0f, -11534256);
        for (int i = 0; i < this.message.size(); ++i) {
            component.m_94929_().f_91062_.m_92877_(transform, this.message.get(i), (float)textX, (float)(10 + (i + 1) * 10), -16777216);
        }
        return time - this.firstDisplay < 7000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private static void renderBackgroundRow(PoseStack transform, ToastComponent component, int x, int u, int y, int height) {
        int leftOffset = 5;
        int rightOffset = Math.min(60, x - leftOffset);
        component.m_93228_(transform, 0, y, 0, 32 + u, leftOffset, height);
        for (int k = leftOffset; k < x - rightOffset; k += 64) {
            component.m_93228_(transform, k, y, 32, 32 + u, Math.min(64, x - k - rightOffset), height);
        }
        component.m_93228_(transform, x - rightOffset, y, 160 - rightOffset, 32 + u, rightOffset, height);
    }
}

