/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.pocket;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import javax.annotation.Nonnull;

public class PocketComputerData {
    private final NetworkedTerminal terminal;
    private ComputerState state = ComputerState.OFF;
    private int lightColour = -1;

    public PocketComputerData(boolean colour) {
        this.terminal = new NetworkedTerminal(ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight, colour);
    }

    public int getLightState() {
        return this.state != ComputerState.OFF ? this.lightColour : -1;
    }

    @Nonnull
    public Terminal getTerminal() {
        return this.terminal;
    }

    public ComputerState getState() {
        return this.state;
    }

    public void setState(ComputerState state, int lightColour) {
        this.state = state;
        this.lightColour = lightColour;
    }

    public void setTerminal(TerminalState state) {
        state.apply(this.terminal);
    }
}

