/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;

public class BinaryWritableHandle
extends HandleGeneric {
    private final WritableByteChannel writer;
    final SeekableByteChannel seekable;
    private final ByteBuffer single = ByteBuffer.allocate(1);

    protected BinaryWritableHandle(WritableByteChannel writer, SeekableByteChannel seekable, TrackingCloseable closeable) {
        super(closeable);
        this.writer = writer;
        this.seekable = seekable;
    }

    public static BinaryWritableHandle of(WritableByteChannel channel, TrackingCloseable closeable) {
        SeekableByteChannel seekable = BinaryWritableHandle.asSeekable(channel);
        return seekable == null ? new BinaryWritableHandle(channel, null, closeable) : new Seekable(seekable, closeable);
    }

    public static BinaryWritableHandle of(WritableByteChannel channel) {
        return BinaryWritableHandle.of(channel, new TrackingCloseable.Impl(channel));
    }

    @LuaFunction
    public final void write(IArguments arguments) throws LuaException {
        block4: {
            this.checkOpen();
            try {
                Object arg = arguments.get(0);
                if (arg instanceof Number) {
                    int number = ((Number)arg).intValue();
                    this.single.clear();
                    this.single.put((byte)number);
                    this.single.flip();
                    this.writer.write(this.single);
                    break block4;
                }
                if (arg instanceof String) {
                    this.writer.write(arguments.getBytes(0));
                    break block4;
                }
                throw LuaValues.badArgumentOf(0, "string or number", arg);
            }
            catch (IOException e) {
                throw new LuaException(e.getMessage());
            }
        }
    }

    @LuaFunction
    public final void flush() throws LuaException {
        this.checkOpen();
        try {
            WritableByteChannel writableByteChannel = this.writer;
            if (writableByteChannel instanceof FileChannel) {
                FileChannel channel = (FileChannel)writableByteChannel;
                channel.force(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Seekable
    extends BinaryWritableHandle {
        public Seekable(SeekableByteChannel seekable, TrackingCloseable closeable) {
            super(seekable, seekable, closeable);
        }

        @LuaFunction
        public final Object[] seek(Optional<String> whence, Optional<Long> offset) throws LuaException {
            this.checkOpen();
            return Seekable.handleSeek(this.seekable, whence, offset);
        }
    }
}

