/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class MountWrapper {
    private final String label;
    private final String location;
    private final IMount mount;
    private final IWritableMount writableMount;

    MountWrapper(String label, String location, IMount mount) {
        this.label = label;
        this.location = location;
        this.mount = mount;
        this.writableMount = null;
    }

    MountWrapper(String label, String location, IWritableMount mount) {
        this.label = label;
        this.location = location;
        this.mount = mount;
        this.writableMount = mount;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocation() {
        return this.location;
    }

    public long getFreeSpace() {
        if (this.writableMount == null) {
            return 0L;
        }
        try {
            return this.writableMount.getRemainingSpace();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public OptionalLong getCapacity() {
        return this.writableMount == null ? OptionalLong.empty() : this.writableMount.getCapacity();
    }

    public boolean isReadOnly(String path) {
        return this.writableMount == null;
    }

    public boolean exists(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            return this.mount.exists(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public boolean isDirectory(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            return this.mount.exists(path) && this.mount.isDirectory(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public void list(String path, List<String> contents) throws FileSystemException {
        path = this.toLocal(path);
        try {
            if (!this.mount.exists(path) || !this.mount.isDirectory(path)) {
                throw this.localExceptionOf(path, "Not a directory");
            }
            this.mount.list(path, contents);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public long getSize(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            if (!this.mount.exists(path)) {
                throw this.localExceptionOf(path, "No such file");
            }
            return this.mount.isDirectory(path) ? 0L : this.mount.getSize(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    @Nonnull
    public BasicFileAttributes getAttributes(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            if (!this.mount.exists(path)) {
                throw this.localExceptionOf(path, "No such file");
            }
            return this.mount.getAttributes(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public ReadableByteChannel openForRead(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            if (this.mount.exists(path) && !this.mount.isDirectory(path)) {
                return this.mount.openForRead(path);
            }
            throw this.localExceptionOf(path, "No such file");
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public void makeDirectory(String path) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(path, "Access denied");
        }
        path = this.toLocal(path);
        try {
            if (this.mount.exists(path)) {
                if (!this.mount.isDirectory(path)) {
                    throw this.localExceptionOf(path, "File exists");
                }
            } else {
                this.writableMount.makeDirectory(path);
            }
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public void delete(String path) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(path, "Access denied");
        }
        path = this.toLocal(path);
        try {
            if (this.mount.exists(path)) {
                this.writableMount.delete(path);
            }
        }
        catch (AccessDeniedException e) {
            throw new FileSystemException("Access denied");
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public WritableByteChannel openForWrite(String path) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(path, "Access denied");
        }
        path = this.toLocal(path);
        try {
            String dir;
            if (this.mount.exists(path) && this.mount.isDirectory(path)) {
                throw this.localExceptionOf(path, "Cannot write to directory");
            }
            if (!(path.isEmpty() || (dir = FileSystem.getDirectory(path)).isEmpty() || this.mount.exists(path))) {
                this.writableMount.makeDirectory(dir);
            }
            return this.writableMount.openForWrite(path);
        }
        catch (AccessDeniedException e) {
            throw new FileSystemException("Access denied");
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public WritableByteChannel openForAppend(String path) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(path, "Access denied");
        }
        path = this.toLocal(path);
        try {
            if (!this.mount.exists(path)) {
                String dir;
                if (!(path.isEmpty() || (dir = FileSystem.getDirectory(path)).isEmpty() || this.mount.exists(path))) {
                    this.writableMount.makeDirectory(dir);
                }
                return this.writableMount.openForWrite(path);
            }
            if (this.mount.isDirectory(path)) {
                throw this.localExceptionOf(path, "Cannot write to directory");
            }
            return this.writableMount.openForAppend(path);
        }
        catch (AccessDeniedException e) {
            throw new FileSystemException("Access denied");
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    private String toLocal(String path) {
        return FileSystem.toLocal(path, this.location);
    }

    private FileSystemException localExceptionOf(@Nullable String localPath, @Nonnull IOException e) {
        IOException ex;
        if (!this.location.isEmpty() && e instanceof FileOperationException && ((FileOperationException)(ex = (FileOperationException)e)).getFilename() != null) {
            return this.localExceptionOf(((FileOperationException)ex).getFilename(), ex.getMessage());
        }
        if (e instanceof java.nio.file.FileSystemException) {
            ex = (java.nio.file.FileSystemException)e;
            String message = ((java.nio.file.FileSystemException)ex).getReason().trim();
            return localPath == null ? new FileSystemException(message) : this.localExceptionOf(localPath, message);
        }
        return new FileSystemException(e.getMessage());
    }

    private FileSystemException localExceptionOf(String path, String message) {
        if (!this.location.isEmpty()) {
            path = path.isEmpty() ? this.location : this.location + "/" + path;
        }
        return MountWrapper.exceptionOf(path, message);
    }

    private static FileSystemException exceptionOf(String path, String message) {
        return new FileSystemException("/" + path + ": " + message);
    }
}

