/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaInteger;
import cc.tweaked.internal.cobalt.LuaNumber;
import cc.tweaked.internal.cobalt.LuaValue;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.VarargArguments;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

class TableImpl
implements LuaTable<Object, Object> {
    private final VarargArguments arguments;
    private final cc.tweaked.internal.cobalt.LuaTable table;
    private Map<Object, Object> backingMap;

    TableImpl(VarargArguments arguments, cc.tweaked.internal.cobalt.LuaTable table) {
        this.arguments = arguments;
        this.table = table;
    }

    @Override
    public int size() {
        this.checkValid();
        try {
            return this.table.keyCount();
        }
        catch (LuaError e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int length() {
        return this.table.length();
    }

    @Override
    public long getLong(int index) throws LuaException {
        LuaValue value = this.table.rawget(index);
        if (!(value instanceof LuaNumber)) {
            throw LuaValues.badTableItem(index, "number", value.typeName());
        }
        if (value instanceof LuaInteger) {
            return value.toInteger();
        }
        double number = value.toDouble();
        if (!Double.isFinite(number)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getNumericType(number));
        }
        return (long)number;
    }

    @Override
    public boolean isEmpty() {
        this.checkValid();
        try {
            return this.table.next(Constants.NIL).first().isNil();
        }
        catch (LuaError e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    private LuaValue getImpl(Object o) {
        this.checkValid();
        if (o instanceof String) {
            return this.table.rawget((String)o);
        }
        if (o instanceof Integer) {
            return this.table.rawget((Integer)o);
        }
        return Constants.NIL;
    }

    @Override
    public boolean containsKey(Object o) {
        return !this.getImpl(o).isNil();
    }

    @Override
    public Object get(Object o) {
        return CobaltLuaMachine.toObject(this.getImpl(o), null);
    }

    @Nonnull
    private Map<Object, Object> getBackingMap() {
        this.checkValid();
        if (this.backingMap != null) {
            return this.backingMap;
        }
        this.backingMap = Collections.unmodifiableMap(Objects.requireNonNull((Map)CobaltLuaMachine.toObject(this.table, null)));
        return this.backingMap;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.getBackingMap().containsKey(o);
    }

    @Override
    @Nonnull
    public Set<Object> keySet() {
        return this.getBackingMap().keySet();
    }

    @Override
    @Nonnull
    public Collection<Object> values() {
        return this.getBackingMap().values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.getBackingMap().entrySet();
    }

    private void checkValid() {
        if (this.arguments.closed) {
            throw new IllegalStateException("Cannot use LuaTable after IArguments has been released");
        }
    }
}

