/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.terminal;

import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Terminal {
    protected static final String BASE_16 = "0123456789abcdef";
    protected int width;
    protected int height;
    protected final boolean colour;
    protected int cursorX = 0;
    protected int cursorY = 0;
    protected boolean cursorBlink = false;
    protected int cursorColour = 0;
    protected int cursorBackgroundColour = 15;
    protected TextBuffer[] text;
    protected TextBuffer[] textColour;
    protected TextBuffer[] backgroundColour;
    protected final Palette palette;
    @Nullable
    private final Runnable onChanged;

    public Terminal(int width, int height, boolean colour) {
        this(width, height, colour, null);
    }

    public Terminal(int width, int height, boolean colour, Runnable changedCallback) {
        this.width = width;
        this.height = height;
        this.colour = colour;
        this.palette = new Palette(colour);
        this.onChanged = changedCallback;
        this.text = new TextBuffer[height];
        this.textColour = new TextBuffer[height];
        this.backgroundColour = new TextBuffer[height];
        for (int i = 0; i < this.height; ++i) {
            this.text[i] = new TextBuffer(' ', this.width);
            this.textColour[i] = new TextBuffer(BASE_16.charAt(this.cursorColour), this.width);
            this.backgroundColour[i] = new TextBuffer(BASE_16.charAt(this.cursorBackgroundColour), this.width);
        }
    }

    public synchronized void reset() {
        this.cursorColour = 0;
        this.cursorBackgroundColour = 15;
        this.cursorX = 0;
        this.cursorY = 0;
        this.cursorBlink = false;
        this.clear();
        this.setChanged();
        this.palette.resetColours();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isColour() {
        return this.colour;
    }

    public synchronized void resize(int width, int height) {
        if (width == this.width && height == this.height) {
            return;
        }
        int oldHeight = this.height;
        int oldWidth = this.width;
        TextBuffer[] oldText = this.text;
        TextBuffer[] oldTextColour = this.textColour;
        TextBuffer[] oldBackgroundColour = this.backgroundColour;
        this.width = width;
        this.height = height;
        this.text = new TextBuffer[height];
        this.textColour = new TextBuffer[height];
        this.backgroundColour = new TextBuffer[height];
        for (int i = 0; i < this.height; ++i) {
            if (i >= oldHeight) {
                this.text[i] = new TextBuffer(' ', this.width);
                this.textColour[i] = new TextBuffer(BASE_16.charAt(this.cursorColour), this.width);
                this.backgroundColour[i] = new TextBuffer(BASE_16.charAt(this.cursorBackgroundColour), this.width);
                continue;
            }
            if (this.width == oldWidth) {
                this.text[i] = oldText[i];
                this.textColour[i] = oldTextColour[i];
                this.backgroundColour[i] = oldBackgroundColour[i];
                continue;
            }
            this.text[i] = new TextBuffer(' ', this.width);
            this.textColour[i] = new TextBuffer(BASE_16.charAt(this.cursorColour), this.width);
            this.backgroundColour[i] = new TextBuffer(BASE_16.charAt(this.cursorBackgroundColour), this.width);
            this.text[i].write(oldText[i]);
            this.textColour[i].write(oldTextColour[i]);
            this.backgroundColour[i].write(oldBackgroundColour[i]);
        }
        this.setChanged();
    }

    public void setCursorPos(int x, int y) {
        if (this.cursorX != x || this.cursorY != y) {
            this.cursorX = x;
            this.cursorY = y;
            this.setChanged();
        }
    }

    public void setCursorBlink(boolean blink) {
        if (this.cursorBlink != blink) {
            this.cursorBlink = blink;
            this.setChanged();
        }
    }

    public void setTextColour(int colour) {
        if (this.cursorColour != colour) {
            this.cursorColour = colour;
            this.setChanged();
        }
    }

    public void setBackgroundColour(int colour) {
        if (this.cursorBackgroundColour != colour) {
            this.cursorBackgroundColour = colour;
            this.setChanged();
        }
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public boolean getCursorBlink() {
        return this.cursorBlink;
    }

    public int getTextColour() {
        return this.cursorColour;
    }

    public int getBackgroundColour() {
        return this.cursorBackgroundColour;
    }

    @Nonnull
    public Palette getPalette() {
        return this.palette;
    }

    public synchronized void blit(ByteBuffer text, ByteBuffer textColour, ByteBuffer backgroundColour) {
        int x = this.cursorX;
        int y = this.cursorY;
        if (y >= 0 && y < this.height) {
            this.text[y].write(text, x);
            this.textColour[y].write(textColour, x);
            this.backgroundColour[y].write(backgroundColour, x);
            this.setChanged();
        }
    }

    public synchronized void write(String text) {
        int x = this.cursorX;
        int y = this.cursorY;
        if (y >= 0 && y < this.height) {
            this.text[y].write(text, x);
            this.textColour[y].fill(BASE_16.charAt(this.cursorColour), x, x + text.length());
            this.backgroundColour[y].fill(BASE_16.charAt(this.cursorBackgroundColour), x, x + text.length());
            this.setChanged();
        }
    }

    public synchronized void scroll(int yDiff) {
        if (yDiff != 0) {
            TextBuffer[] newText = new TextBuffer[this.height];
            TextBuffer[] newTextColour = new TextBuffer[this.height];
            TextBuffer[] newBackgroundColour = new TextBuffer[this.height];
            for (int y = 0; y < this.height; ++y) {
                int oldY = y + yDiff;
                if (oldY >= 0 && oldY < this.height) {
                    newText[y] = this.text[oldY];
                    newTextColour[y] = this.textColour[oldY];
                    newBackgroundColour[y] = this.backgroundColour[oldY];
                    continue;
                }
                newText[y] = new TextBuffer(' ', this.width);
                newTextColour[y] = new TextBuffer(BASE_16.charAt(this.cursorColour), this.width);
                newBackgroundColour[y] = new TextBuffer(BASE_16.charAt(this.cursorBackgroundColour), this.width);
            }
            this.text = newText;
            this.textColour = newTextColour;
            this.backgroundColour = newBackgroundColour;
            this.setChanged();
        }
    }

    public synchronized void clear() {
        for (int y = 0; y < this.height; ++y) {
            this.text[y].fill(' ');
            this.textColour[y].fill(BASE_16.charAt(this.cursorColour));
            this.backgroundColour[y].fill(BASE_16.charAt(this.cursorBackgroundColour));
        }
        this.setChanged();
    }

    public synchronized void clearLine() {
        int y = this.cursorY;
        if (y >= 0 && y < this.height) {
            this.text[y].fill(' ');
            this.textColour[y].fill(BASE_16.charAt(this.cursorColour));
            this.backgroundColour[y].fill(BASE_16.charAt(this.cursorBackgroundColour));
            this.setChanged();
        }
    }

    public synchronized TextBuffer getLine(int y) {
        if (y >= 0 && y < this.height) {
            return this.text[y];
        }
        return null;
    }

    public synchronized void setLine(int y, String text, String textColour, String backgroundColour) {
        this.text[y].write(text);
        this.textColour[y].write(textColour);
        this.backgroundColour[y].write(backgroundColour);
        this.setChanged();
    }

    public synchronized TextBuffer getTextColourLine(int y) {
        if (y >= 0 && y < this.height) {
            return this.textColour[y];
        }
        return null;
    }

    public synchronized TextBuffer getBackgroundColourLine(int y) {
        if (y >= 0 && y < this.height) {
            return this.backgroundColour[y];
        }
        return null;
    }

    public final void setChanged() {
        if (this.onChanged != null) {
            this.onChanged.run();
        }
    }

    public static int getColour(char c, Colour def) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 15 - def.ordinal();
    }
}

