/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class NetworkedTerminal
extends Terminal {
    public NetworkedTerminal(int width, int height, boolean colour) {
        super(width, height, colour);
    }

    public NetworkedTerminal(int width, int height, boolean colour, Runnable changedCallback) {
        super(width, height, colour, changedCallback);
    }

    public synchronized void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.cursorX);
        buffer.writeInt(this.cursorY);
        buffer.writeBoolean(this.cursorBlink);
        buffer.writeByte(this.cursorBackgroundColour << 4 | this.cursorColour);
        for (int y = 0; y < this.height; ++y) {
            int x;
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (x = 0; x < this.width; ++x) {
                buffer.writeByte(text.charAt(x) & 0xFF);
            }
            for (x = 0; x < this.width; ++x) {
                buffer.writeByte(NetworkedTerminal.getColour(backColour.charAt(x), Colour.BLACK) << 4 | NetworkedTerminal.getColour(textColour.charAt(x), Colour.WHITE));
            }
        }
        this.palette.write(buffer);
    }

    public synchronized void read(FriendlyByteBuf buffer) {
        this.cursorX = buffer.readInt();
        this.cursorY = buffer.readInt();
        this.cursorBlink = buffer.readBoolean();
        byte cursorColour = buffer.readByte();
        this.cursorBackgroundColour = cursorColour >> 4 & 0xF;
        this.cursorColour = cursorColour & 0xF;
        for (int y = 0; y < this.height; ++y) {
            int x;
            TextBuffer text = this.text[y];
            TextBuffer textColour = this.textColour[y];
            TextBuffer backColour = this.backgroundColour[y];
            for (x = 0; x < this.width; ++x) {
                text.setChar(x, (char)(buffer.readByte() & 0xFF));
            }
            for (x = 0; x < this.width; ++x) {
                byte colour = buffer.readByte();
                backColour.setChar(x, "0123456789abcdef".charAt(colour >> 4 & 0xF));
                textColour.setChar(x, "0123456789abcdef".charAt(colour & 0xF));
            }
        }
        this.palette.read(buffer);
        this.setChanged();
    }

    public synchronized CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("term_cursorX", this.cursorX);
        nbt.m_128405_("term_cursorY", this.cursorY);
        nbt.m_128379_("term_cursorBlink", this.cursorBlink);
        nbt.m_128405_("term_textColour", this.cursorColour);
        nbt.m_128405_("term_bgColour", this.cursorBackgroundColour);
        for (int n = 0; n < this.height; ++n) {
            nbt.m_128359_("term_text_" + n, this.text[n].toString());
            nbt.m_128359_("term_textColour_" + n, this.textColour[n].toString());
            nbt.m_128359_("term_textBgColour_" + n, this.backgroundColour[n].toString());
        }
        this.palette.writeToNBT(nbt);
        return nbt;
    }

    public synchronized void readFromNBT(CompoundTag nbt) {
        this.cursorX = nbt.m_128451_("term_cursorX");
        this.cursorY = nbt.m_128451_("term_cursorY");
        this.cursorBlink = nbt.m_128471_("term_cursorBlink");
        this.cursorColour = nbt.m_128451_("term_textColour");
        this.cursorBackgroundColour = nbt.m_128451_("term_bgColour");
        for (int n = 0; n < this.height; ++n) {
            this.text[n].fill(' ');
            if (nbt.m_128441_("term_text_" + n)) {
                this.text[n].write(nbt.m_128461_("term_text_" + n));
            }
            this.textColour[n].fill("0123456789abcdef".charAt(this.cursorColour));
            if (nbt.m_128441_("term_textColour_" + n)) {
                this.textColour[n].write(nbt.m_128461_("term_textColour_" + n));
            }
            this.backgroundColour[n].fill("0123456789abcdef".charAt(this.cursorBackgroundColour));
            if (!nbt.m_128441_("term_textBgColour_" + n)) continue;
            this.backgroundColour[n].write(nbt.m_128461_("term_textBgColour_" + n));
        }
        this.palette.readFromNBT(nbt);
        this.setChanged();
    }
}

