/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TurtleUtil {
    public static void storeItemOrDrop(ITurtleAccess turtle, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (turtle.isRemoved()) {
            WorldUtil.dropItemStack(stack, turtle.getLevel(), turtle.getPosition(), null);
            return;
        }
        ItemStack remainder = InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
        if (remainder.m_41619_()) {
            return;
        }
        WorldUtil.dropItemStack(remainder, turtle.getLevel(), turtle.getPosition(), turtle.getDirection().m_122424_());
    }

    public static Function<ItemStack, ItemStack> dropConsumer(ITurtleAccess turtle) {
        return stack -> turtle.isRemoved() ? stack : InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
    }

    public static void stopConsuming(ITurtleAccess turtle) {
        Direction direction = turtle.isRemoved() ? null : turtle.getDirection().m_122424_();
        DropConsumer.clearAndDrop(turtle.getLevel(), turtle.getPosition(), direction);
    }
}

