/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;

public final class SidedCaps<T> {
    private final Function<Direction, T> factory;
    private final boolean allowNull;
    private T[] values;
    private LazyOptional<T>[] caps;

    private SidedCaps(Function<Direction, T> factory, boolean allowNull) {
        this.factory = factory;
        this.allowNull = allowNull;
    }

    public static <T> SidedCaps<T> ofNonNull(Function<Direction, T> factory) {
        return new SidedCaps<T>(factory, false);
    }

    public static <T> SidedCaps<T> ofNullable(Function<Direction, T> factory) {
        return new SidedCaps<T>(factory, true);
    }

    public LazyOptional<T> get(@Nullable Direction direction) {
        LazyOptional cap;
        if (direction == null && !this.allowNull) {
            return LazyOptional.empty();
        }
        int index = direction == null ? 6 : direction.ordinal();
        LazyOptional<T>[] caps = this.caps;
        if (caps == null) {
            caps = this.caps = new LazyOptional[this.allowNull ? 7 : 6];
            this.values = new Object[caps.length];
        }
        return (cap = caps[index]) == null ? LazyOptional.of(() -> {
            T[] values = this.values;
            T value = values[index];
            return value == null ? this.factory.apply(direction) : value;
        }) : cap;
    }

    public void invalidate() {
        if (this.caps != null) {
            CapabilityUtil.invalidate(this.caps);
        }
    }
}

