/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;

public class LegsModel
extends HumanoidModel<LivingEntity> {
    public LegsModel(ModelPart part) {
        super(part, RenderType::m_110458_);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102814_, (Object)this.f_102813_);
    }

    public static MeshDefinition createLegs(float delta, CubeListBuilder leftLeg, CubeListBuilder rightLeg) {
        CubeDeformation deformation = new CubeDeformation(delta);
        MeshDefinition mesh = LegsModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        mesh.m_171576_().m_171599_("left_leg", leftLeg.m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        mesh.m_171576_().m_171599_("right_leg", rightLeg.m_171514_(16, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        return mesh;
    }

    public static MeshDefinition createSleevedLegs(float delta, CubeListBuilder leftLeg, CubeListBuilder rightLeg) {
        CubeDeformation deformation = new CubeDeformation(delta + 0.25f);
        leftLeg.m_171514_(0, 16);
        leftLeg.m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation);
        rightLeg.m_171514_(16, 16);
        rightLeg.m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation);
        return LegsModel.createLegs(delta, leftLeg, rightLeg);
    }

    public static MeshDefinition createShoes(float delta, CubeListBuilder leftLeg, CubeListBuilder rightLeg) {
        CubeDeformation deformation = new CubeDeformation(delta, delta / 4.0f, delta / 4.0f);
        leftLeg.m_171514_(0, 16);
        leftLeg.m_171488_(-2.0f, 9.0f + delta * 3.0f / 4.0f, -3.0f - delta * 5.0f / 4.0f, 4.0f, 3.0f, 1.0f, deformation);
        rightLeg.m_171514_(16, 16);
        rightLeg.m_171488_(-2.0f, 9.0f + delta * 3.0f / 4.0f, -3.0f - delta * 5.0f / 4.0f, 4.0f, 3.0f, 1.0f, deformation);
        return LegsModel.createLegs(delta, leftLeg, rightLeg);
    }

    public static MeshDefinition createSlippers(CubeListBuilder leftLeg, CubeListBuilder rightLeg) {
        leftLeg.m_171514_(32, 0);
        leftLeg.m_171481_(-2.5f, 8.51f, -7.01f, 5.0f, 4.0f, 5.0f);
        rightLeg.m_171514_(32, 16);
        rightLeg.m_171481_(-2.5f, 8.51f, -7.0f, 5.0f, 4.0f, 5.0f);
        return LegsModel.createSleevedLegs(0.51f, leftLeg, rightLeg);
    }

    public static MeshDefinition createAquaDashers() {
        CubeListBuilder leftLeg = CubeListBuilder.m_171558_();
        CubeListBuilder rightLeg = CubeListBuilder.m_171558_();
        float delta = 1.25f;
        CubeDeformation deformation = new CubeDeformation(0.0f, delta, delta);
        leftLeg.m_171514_(0, 16);
        leftLeg.m_171488_(2.0f + delta, 0.0f, 1.0f + delta * 3.0f / 2.0f, 0.0f, 12.0f, 4.0f, deformation);
        rightLeg.m_171514_(16, 16);
        rightLeg.m_171488_(-2.0f - delta, 0.0f, 1.0f + delta * 3.0f / 2.0f, 0.0f, 12.0f, 4.0f, deformation);
        return LegsModel.createShoes(delta, leftLeg, rightLeg);
    }

    public static MeshDefinition createBunnyHoppers() {
        CubeListBuilder leftLeg = CubeListBuilder.m_171558_();
        CubeListBuilder rightLeg = CubeListBuilder.m_171558_();
        leftLeg.m_171514_(32, 9);
        leftLeg.m_171481_(-0.5f, 10.0f, -7.5f, 1.0f, 1.0f, 1.0f);
        rightLeg.m_171514_(32, 25);
        rightLeg.m_171481_(-0.5f, 10.0f, -7.5f, 1.0f, 1.0f, 1.0f);
        leftLeg.m_171514_(52, 6);
        leftLeg.m_171481_(-1.0f, 9.0f, 2.0f, 2.0f, 2.0f, 2.0f);
        rightLeg.m_171514_(52, 22);
        rightLeg.m_171481_(-1.0f, 9.0f, 2.0f, 2.0f, 2.0f, 2.0f);
        MeshDefinition mesh = LegsModel.createSlippers(leftLeg, rightLeg);
        mesh.m_171576_().m_171597_("left_leg").m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171481_(-3.15f, 3.51f, -3.01f, 2.0f, 5.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)-0.2617994f, (float)0.0f));
        mesh.m_171576_().m_171597_("right_leg").m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(52, 16).m_171481_(-3.15f, 3.51f, -3.0f, 2.0f, 5.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)-0.2617994f, (float)0.0f));
        mesh.m_171576_().m_171597_("left_leg").m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171481_(1.15f, 3.51f, -3.01f, 2.0f, 5.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)0.2617994f, (float)0.0f));
        mesh.m_171576_().m_171597_("right_leg").m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(58, 16).m_171481_(1.15f, 3.51f, -3.0f, 2.0f, 5.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)0.2617994f, (float)0.0f));
        return mesh;
    }

    public static MeshDefinition createFlippers() {
        CubeListBuilder leftLeg = CubeListBuilder.m_171558_();
        CubeListBuilder rightLeg = CubeListBuilder.m_171558_();
        leftLeg.m_171514_(0, 16);
        leftLeg.m_171481_(-2.0f, 11.5f, -16.0f, 9.0f, 0.0f, 20.0f);
        rightLeg.m_171514_(0, 36);
        rightLeg.m_171481_(-7.0f, 11.5f, -16.0f, 9.0f, 0.0f, 20.0f);
        return LegsModel.createLegs(0.5f, leftLeg, rightLeg);
    }

    public static MeshDefinition createKittySlippers() {
        CubeListBuilder leftLeg = CubeListBuilder.m_171558_();
        CubeListBuilder rightLeg = CubeListBuilder.m_171558_();
        leftLeg.m_171514_(32, 9);
        leftLeg.m_171481_(-2.0f, 7.51f, -4.0f, 1.0f, 1.0f, 2.0f);
        rightLeg.m_171514_(32, 25);
        rightLeg.m_171481_(-2.0f, 7.51f, -4.0f, 1.0f, 1.0f, 2.0f);
        leftLeg.m_171514_(38, 9);
        leftLeg.m_171481_(1.0f, 7.51f, -4.0f, 1.0f, 1.0f, 2.0f);
        rightLeg.m_171514_(38, 25);
        rightLeg.m_171481_(1.0f, 7.51f, -4.0f, 1.0f, 1.0f, 2.0f);
        leftLeg.m_171514_(44, 9);
        leftLeg.m_171481_(-1.5f, 10.51f, -8.0f, 3.0f, 2.0f, 1.0f);
        rightLeg.m_171514_(44, 25);
        rightLeg.m_171481_(-1.5f, 10.51f, -8.0f, 3.0f, 2.0f, 1.0f);
        return LegsModel.createSlippers(leftLeg, rightLeg);
    }

    public static MeshDefinition createRunningShoes() {
        return LegsModel.createShoes(0.5f, CubeListBuilder.m_171558_(), CubeListBuilder.m_171558_());
    }

    public static MeshDefinition createSteadfastSpikes() {
        CubeListBuilder leftLeg = CubeListBuilder.m_171558_();
        CubeListBuilder rightLeg = CubeListBuilder.m_171558_();
        leftLeg.m_171514_(32, 0);
        leftLeg.m_171481_(-1.5f, 9.0f, -7.0f, 1.0f, 3.0f, 5.0f);
        rightLeg.m_171514_(43, 0);
        rightLeg.m_171481_(-1.5f, 9.0f, -7.0f, 1.0f, 3.0f, 5.0f);
        leftLeg.m_171514_(32, 8);
        leftLeg.m_171481_(0.5f, 9.0f, -7.0f, 1.0f, 3.0f, 5.0f);
        rightLeg.m_171514_(43, 8);
        rightLeg.m_171481_(0.5f, 9.0f, -7.0f, 1.0f, 3.0f, 5.0f);
        return LegsModel.createSleevedLegs(0.5f, leftLeg, rightLeg);
    }
}

