/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.HurtSoundModifyingItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.SlotContext;

public class BunnyHoppersItem
extends HurtSoundModifyingItem {
    public BunnyHoppersItem() {
        super(SoundEvents.f_12353_);
        this.addListener(EventPriority.HIGH, LivingFallEvent.class, this::onLivingFall);
        this.addListener(LivingEvent.LivingJumpEvent.class, this::onLivingJump);
    }

    private void onLivingFall(LivingFallEvent event, LivingEntity wearer) {
        if (((Boolean)ModConfig.server.bunnyHoppers.shouldCancelFallDamage.get()).booleanValue()) {
            event.setDamageMultiplier(0.0f);
        }
    }

    private void onLivingJump(LivingEvent.LivingJumpEvent event, LivingEntity wearer) {
        this.damageEquippedStacks(wearer);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        int jumpBoostLevel = (Integer)ModConfig.server.bunnyHoppers.jumpBoostLevel.get() - 1;
        if (!ModConfig.server.isCosmetic(this) && !slotContext.entity().f_19853_.f_46443_ && slotContext.entity().f_19797_ % 15 == 0 && jumpBoostLevel >= 0) {
            slotContext.entity().m_7292_(new MobEffectInstance(MobEffects.f_19603_, 39, jumpBoostLevel, true, false));
        }
    }
}

