/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.container;

import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.container.BaseContainerMenu;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import edivad.extrastorage.blockentity.AdvancedExporterBlockEntity;
import edivad.extrastorage.nodes.AdvancedExporterNetworkNode;
import edivad.extrastorage.setup.Registration;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AdvancedExporterContainerMenu
extends BaseContainerMenu {
    private final AdvancedExporterBlockEntity exporterBlockEntity;
    private boolean hasRegulatorMode;

    public AdvancedExporterContainerMenu(int windowId, Player player, AdvancedExporterBlockEntity exporterBlockEntity) {
        super((MenuType)Registration.ADVANCED_EXPORTER_CONTAINER.get(), (BaseBlockEntity)exporterBlockEntity, player, windowId);
        this.exporterBlockEntity = exporterBlockEntity;
        this.hasRegulatorMode = this.hasRegulatorMode();
        this.initSlots();
    }

    private boolean hasRegulatorMode() {
        return ((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
    }

    public void m_38946_() {
        super.m_38946_();
        boolean updatedHasRegulatorMode = this.hasRegulatorMode();
        if (this.hasRegulatorMode != updatedHasRegulatorMode) {
            this.hasRegulatorMode = updatedHasRegulatorMode;
            this.initSlots();
        }
    }

    public void initSlots() {
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.transferManager.clearTransfers();
        for (int i = 0; i < 4; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getUpgrades(), i, 187, 6 + i * 18));
        }
        boolean hasRegulator = ((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                int x = 8 + 18 * j;
                int y = 20 + 18 * i;
                this.m_38897_((Slot)new FilterSlot((IItemHandler)((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getItemFilters(), index, x, y, hasRegulator ? 1 : 0).setEnableHandler(() -> ((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getType() == 0));
                this.m_38897_((Slot)new FluidFilterSlot(((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getFluidFilters(), index, x, y, hasRegulator ? 1 : 0).setEnableHandler(() -> ((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getType() == 1));
            }
        }
        this.addPlayerInventory(8, 73);
        this.transferManager.addBiTransfer((Container)this.getPlayer().m_150109_(), (IItemHandler)((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getUpgrades());
        this.transferManager.addFilterTransfer((Container)this.getPlayer().m_150109_(), ((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getItemFilters(), ((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode()).getFluidFilters(), ((AdvancedExporterNetworkNode)this.exporterBlockEntity.getNode())::getType);
    }

    public AdvancedExporterBlockEntity getBlockEntity() {
        return this.exporterBlockEntity;
    }
}

