/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class BasicChemicalTank<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IChemicalTank<CHEMICAL, STACK>,
IChemicalHandler<CHEMICAL, STACK> {
    private final Predicate<@NotNull CHEMICAL> validator;
    protected final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract;
    protected final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert;
    @Nullable
    private final ChemicalAttributeValidator attributeValidator;
    private final long capacity;
    protected STACK stored;
    @Nullable
    private final IContentsListener listener;

    protected BasicChemicalTank(long capacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert, Predicate<@NotNull CHEMICAL> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        this.capacity = capacity;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.attributeValidator = attributeValidator;
        this.listener = listener;
        this.stored = this.getEmptyStack();
    }

    @Override
    public STACK getStack() {
        return this.stored;
    }

    @Override
    public void setStack(STACK stack) {
        this.setStack(stack, true);
    }

    protected long getRate(@Nullable AutomationType automationType) {
        return Long.MAX_VALUE;
    }

    @Override
    public void setStackUnchecked(STACK stack) {
        this.setStack(stack, false);
    }

    private void setStack(STACK stack, boolean validateStack) {
        if (((ChemicalStack)stack).isEmpty()) {
            if (((ChemicalStack)this.stored).isEmpty()) {
                return;
            }
            this.stored = this.getEmptyStack();
        } else if (!validateStack || this.isValid(stack)) {
            this.stored = this.createStack(stack, ((ChemicalStack)stack).getAmount());
        } else {
            throw new RuntimeException("Invalid chemical for tank: " + ((ChemicalStack)stack).getTypeRegistryName() + " " + ((ChemicalStack)stack).getAmount());
        }
        this.onContentsChanged();
    }

    @Override
    public STACK insert(@NotNull STACK stack, Action action, AutomationType automationType) {
        if (((ChemicalStack)stack).isEmpty() || !this.isValid(stack) || !this.canInsert.test(((ChemicalStack)stack).getType(), automationType)) {
            return stack;
        }
        long needed = Math.min(this.getRate(automationType), this.getNeeded());
        if (needed <= 0L) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = this.isTypeEqual((CHEMICAL)stack))) {
            long toAdd = Math.min(((ChemicalStack)stack).getAmount(), needed);
            if (action.execute()) {
                if (sameType) {
                    ((ChemicalStack)this.stored).grow(toAdd);
                    this.onContentsChanged();
                } else {
                    this.setStackUnchecked(this.createStack(stack, toAdd));
                }
            }
            return this.createStack(stack, ((ChemicalStack)stack).getAmount() - toAdd);
        }
        return stack;
    }

    @Override
    public STACK extract(long amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1L || !this.canExtract.test(((ChemicalStack)this.stored).getType(), automationType)) {
            return this.getEmptyStack();
        }
        long size = Math.min(Math.min(this.getRate(automationType), this.getStored()), amount);
        if (size == 0L) {
            return this.getEmptyStack();
        }
        STACK ret = this.createStack(this.stored, size);
        if (!((ChemicalStack)ret).isEmpty() && action.execute()) {
            ((ChemicalStack)this.stored).shrink(((ChemicalStack)ret).getAmount());
            this.onContentsChanged();
        }
        return ret;
    }

    @Override
    public boolean isValid(STACK stack) {
        return this.getAttributeValidator().process((ChemicalStack<?>)stack) && this.validator.test(((ChemicalStack)stack).getType());
    }

    @Override
    public long setStackSize(long amount, Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        ((ChemicalStack)this.stored).setAmount(amount);
        this.onContentsChanged();
        return amount;
    }

    @Override
    public long growStack(long amount, Action action) {
        long current = this.getStored();
        if (amount > 0L) {
            amount = Math.min(Math.min(amount, this.getNeeded()), this.getRate(null));
        } else if (amount < 0L) {
            amount = Math.max(amount, -this.getRate(null));
        }
        long newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    @Override
    public boolean isEmpty() {
        return ((ChemicalStack)this.stored).isEmpty();
    }

    @Override
    public long getStored() {
        return ((ChemicalStack)this.stored).getAmount();
    }

    @Override
    public CHEMICAL getType() {
        return ((ChemicalStack)this.stored).getType();
    }

    @Override
    public boolean isTypeEqual(STACK other) {
        return ((ChemicalStack)this.stored).isTypeEqual(other);
    }

    @Override
    public boolean isTypeEqual(CHEMICAL other) {
        return ((ChemicalStack)this.stored).isTypeEqual(other);
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    public ChemicalAttributeValidator getAttributeValidator() {
        return this.attributeValidator == null ? IChemicalTank.super.getAttributeValidator() : this.attributeValidator;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.m_128365_("stored", (Tag)((ChemicalStack)this.stored).write(new CompoundTag()));
        }
        return nbt;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    public STACK getChemicalInTank(int tank) {
        return tank == 0 ? this.getStack() : this.getEmptyStack();
    }

    @Override
    public void setChemicalInTank(int tank, STACK stack) {
        if (tank == 0) {
            this.setStack(stack);
        }
    }

    @Override
    public long getTankCapacity(int tank) {
        return tank == 0 ? this.getCapacity() : 0L;
    }

    @Override
    public boolean isValid(int tank, STACK stack) {
        return tank == 0 && this.isValid(stack);
    }

    @Override
    public STACK insertChemical(int tank, STACK stack, Action action) {
        return tank == 0 ? this.insert(stack, action, AutomationType.EXTERNAL) : stack;
    }

    @Override
    public STACK extractChemical(int tank, long amount, Action action) {
        return tank == 0 ? this.extract(amount, action, AutomationType.EXTERNAL) : this.getEmptyStack();
    }
}

