/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import com.mojang.logging.LogUtils;
import mekanism.api.MekanismAPI;
import mekanism.api.energy.IEnergyConversion;
import org.jetbrains.annotations.VisibleForTesting;

public class EnergyConversionHelper {
    private static IEnergyConversion[] energyConversions;

    private EnergyConversionHelper() {
    }

    @VisibleForTesting
    static IEnergyConversion[] getEnergyConversions() {
        if (energyConversions == null) {
            try {
                Class<?> clazz = Class.forName("mekanism.common.util.UnitDisplayUtils$EnergyUnit");
                ?[] objArray = clazz.getEnumConstants();
                if (objArray instanceof IEnergyConversion[]) {
                    IEnergyConversion[] conversions = (IEnergyConversion[])objArray;
                    energyConversions = conversions;
                } else {
                    MekanismAPI.logger.error(LogUtils.FATAL_MARKER, "Error Energy Units are of the wrong type, Mekanism may be absent, damaged, or outdated.");
                }
            }
            catch (ReflectiveOperationException ex) {
                MekanismAPI.logger.error(LogUtils.FATAL_MARKER, "Error retrieving Energy Units, Mekanism may be absent, damaged, or outdated.");
            }
        }
        return energyConversions;
    }

    public static IEnergyConversion jouleConversion() {
        return EnergyConversions.JOULES.getInternal();
    }

    public static IEnergyConversion feConversion() {
        return EnergyConversions.FORGE_ENERGY.getInternal();
    }

    public static IEnergyConversion euConversion() {
        return EnergyConversions.ELECTRICAL_UNITS.getInternal();
    }

    @VisibleForTesting
    static enum EnergyConversions {
        JOULES,
        FORGE_ENERGY,
        ELECTRICAL_UNITS;

        private IEnergyConversion internal;

        private IEnergyConversion getInternal() {
            IEnergyConversion[] energyUnits;
            if (this.internal == null && (energyUnits = EnergyConversionHelper.getEnergyConversions()) != null) {
                int index = this.ordinal();
                if (index < energyUnits.length) {
                    this.internal = energyUnits[index];
                } else {
                    MekanismAPI.logger.error(LogUtils.FATAL_MARKER, "Error retrieving energy conversion {}, Mekanism may be absent, damaged, or outdated.", (Object)this.name());
                }
            }
            return this.internal;
        }
    }
}

