/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.DoubleConsumer;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GuiSlider
extends GuiElement {
    private static final ResourceLocation SLIDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "smooth_slider.png");
    private final DoubleConsumer callback;
    private double value;
    private boolean isDragging;

    public GuiSlider(IGuiWrapper gui, int x, int y, int width, DoubleConsumer callback) {
        super(gui, x, y, width, 12);
        this.callback = callback;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
        super.renderBackgroundOverlay(matrix, mouseX, mouseY);
        GuiUtils.fill(matrix, this.getButtonX() + 2, this.getButtonY() + 3, this.getButtonWidth() - 4, 6, -11184811);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SLIDER);
        int posX = (int)(this.value * (double)(this.getButtonWidth() - 6));
        GuiSlider.m_93133_((PoseStack)matrix, (int)(this.getButtonX() + posX), (int)this.getButtonY(), (float)0.0f, (float)0.0f, (int)7, (int)12, (int)12, (int)12);
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        this.isDragging = false;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        this.set(mouseX, mouseY);
        this.isDragging = true;
    }

    @Override
    public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        super.m_7212_(mouseX, mouseY, deltaX, deltaY);
        if (this.isDragging) {
            this.set(mouseX, mouseY);
        }
    }

    private void set(double mouseX, double mouseY) {
        this.value = Mth.m_14008_((double)((mouseX - (double)this.getButtonX() - 2.0) / (double)(this.getButtonWidth() - 6)), (double)0.0, (double)1.0);
        this.callback.accept(this.value);
    }
}

