/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BooleanSupplier;
import mekanism.api.functions.ByteSupplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiTeleporterStatus
extends GuiTexturedElement {
    private static final ResourceLocation NEEDS_ENERGY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_needs_energy.png");
    private static final ResourceLocation NO_FRAME = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_frame.png");
    private static final ResourceLocation NO_FREQUENCY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_frequency.png");
    private static final ResourceLocation NO_LINK = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_link.png");
    private static final ResourceLocation READY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_ready.png");
    private final BooleanSupplier hasFrequency;
    private final ByteSupplier statusSupplier;

    public GuiTeleporterStatus(IGuiWrapper gui, BooleanSupplier hasFrequency, ByteSupplier statusSupplier) {
        super(NO_FREQUENCY, gui, 6, 6, 18, 18);
        this.hasFrequency = hasFrequency;
        this.statusSupplier = statusSupplier;
        this.setButtonBackground(GuiElement.ButtonBackground.DEFAULT);
    }

    protected int m_7202_(boolean hovering) {
        return 1;
    }

    @Override
    protected ResourceLocation getResource() {
        if (this.hasFrequency.getAsBoolean()) {
            return switch (this.statusSupplier.getAsByte()) {
                case 1 -> READY;
                case 2 -> NO_FRAME;
                case 4 -> NEEDS_ENERGY;
                default -> NO_LINK;
            };
        }
        return NO_FREQUENCY;
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        GuiTeleporterStatus.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)this.f_93618_, (int)this.f_93619_);
    }

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        this.displayTooltips(matrix, mouseX, mouseY, this.getStatusDisplay());
    }

    private Component getStatusDisplay() {
        if (this.hasFrequency.getAsBoolean()) {
            return switch (this.statusSupplier.getAsByte()) {
                case 1 -> MekanismLang.TELEPORTER_READY.translateColored(EnumColor.DARK_GREEN, new Object[0]);
                case 2 -> MekanismLang.TELEPORTER_NO_FRAME.translateColored(EnumColor.DARK_RED, new Object[0]);
                case 4 -> MekanismLang.TELEPORTER_NEEDS_ENERGY.translateColored(EnumColor.DARK_RED, new Object[0]);
                default -> MekanismLang.TELEPORTER_NO_LINK.translateColored(EnumColor.DARK_RED, new Object[0]);
            };
        }
        return MekanismLang.NO_FREQUENCY.translateColored(EnumColor.DARK_RED, new Object[0]);
    }
}

