/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.List;
import java.util.function.Supplier;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiInfusionGauge;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.gui.element.gauge.GuiSlurryGauge;
import mekanism.client.gui.element.gauge.GuiTankGauge;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.lib.transmitter.TransmissionType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class GuiMergedTankGauge<HANDLER extends IMekanismFluidHandler & IGasTracker & IPigmentTracker>
extends GuiGauge<Void>
implements IJEIIngredientHelper {
    private final Supplier<MergedTank> mergedTankSupplier;
    private final Supplier<HANDLER> handlerSupplier;
    private final GuiFluidGauge fluidGauge;
    private final GuiGasGauge gasGauge;
    private final GuiInfusionGauge infusionGauge;
    private final GuiPigmentGauge pigmentGauge;
    private final GuiSlurryGauge slurryGauge;
    private Component label;

    public GuiMergedTankGauge(Supplier<MergedTank> mergedTankSupplier, Supplier<HANDLER> handlerSupplier, GaugeType type, IGuiWrapper gui, int x, int y, int width, int height) {
        super(type, gui, x, y, width, height);
        this.mergedTankSupplier = mergedTankSupplier;
        this.handlerSupplier = handlerSupplier;
        this.fluidGauge = this.addPositionOnlyChild(new GuiFluidGauge(() -> this.mergedTankSupplier.get().getFluidTank(), () -> ((IMekanismFluidHandler)this.handlerSupplier.get()).getFluidTanks(null), type, gui, x, y, width, height));
        this.gasGauge = this.addPositionOnlyChild(new GuiGasGauge(() -> this.mergedTankSupplier.get().getGasTank(), () -> ((IGasTracker)((Object)((IMekanismFluidHandler)this.handlerSupplier.get()))).getGasTanks(null), type, gui, x, y, width, height));
        this.infusionGauge = this.addPositionOnlyChild(new GuiInfusionGauge(() -> this.mergedTankSupplier.get().getInfusionTank(), () -> ((IInfusionTracker)((Object)((IMekanismFluidHandler)this.handlerSupplier.get()))).getInfusionTanks(null), type, gui, x, y, width, height));
        this.pigmentGauge = this.addPositionOnlyChild(new GuiPigmentGauge(() -> this.mergedTankSupplier.get().getPigmentTank(), () -> ((IPigmentTracker)((Object)((IMekanismFluidHandler)this.handlerSupplier.get()))).getPigmentTanks(null), type, gui, x, y, width, height));
        this.slurryGauge = this.addPositionOnlyChild(new GuiSlurryGauge(() -> this.mergedTankSupplier.get().getSlurryTank(), () -> ((ISlurryTracker)((Object)((IMekanismFluidHandler)this.handlerSupplier.get()))).getSlurryTanks(null), type, gui, x, y, width, height));
    }

    public GuiMergedTankGauge<HANDLER> setLabel(Component label) {
        this.label = label;
        return this;
    }

    @Override
    public GaugeOverlay getGaugeOverlay() {
        return this.getCurrentGauge().getGaugeOverlay();
    }

    @Override
    protected GaugeInfo getGaugeColor() {
        return this.getCurrentGauge().getGaugeColor();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        if (currentGauge == null) {
            return this.fluidGauge.m_6375_(mouseX, mouseY, button) | this.gasGauge.m_6375_(mouseX, mouseY, button) | this.infusionGauge.m_6375_(mouseX, mouseY, button) | this.pigmentGauge.m_6375_(mouseX, mouseY, button) | this.slurryGauge.m_6375_(mouseX, mouseY, button);
        }
        return currentGauge.m_6375_(mouseX, mouseY, button);
    }

    @Override
    protected void applyRenderColor() {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        if (currentGauge != null) {
            currentGauge.applyRenderColor();
        }
    }

    @Override
    @Nullable
    public Object getIngredient(double mouseX, double mouseY) {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        return currentGauge == null ? null : currentGauge.getIngredient(mouseX, mouseY);
    }

    @Override
    public int getScaledLevel() {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        return currentGauge == null ? 0 : currentGauge.getScaledLevel();
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.getCurrentGauge().getIcon();
    }

    @Override
    public List<Component> getTooltipText() {
        return this.getCurrentGauge().getTooltipText();
    }

    @Override
    public Component getLabel() {
        return this.label;
    }

    @Override
    public TransmissionType getTransmission() {
        return this.getCurrentGauge().getTransmission();
    }

    private GuiTankGauge<?, ?> getCurrentGauge() {
        GuiFluidGauge currentGauge = this.getCurrentGaugeNoFallback();
        return currentGauge == null ? this.fluidGauge : currentGauge;
    }

    @Nullable
    private GuiTankGauge<?, ?> getCurrentGaugeNoFallback() {
        MergedTank mergedTank = this.mergedTankSupplier.get();
        return switch (mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> this.fluidGauge;
            case MergedTank.CurrentType.GAS -> this.gasGauge;
            case MergedTank.CurrentType.INFUSION -> this.infusionGauge;
            case MergedTank.CurrentType.PIGMENT -> this.pigmentGauge;
            case MergedTank.CurrentType.SLURRY -> this.slurryGauge;
            default -> null;
        };
    }
}

