/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class MekaSuitEnergyLevel
implements IGuiOverlay {
    private static final ResourceLocation POWER_BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "horizontal_power_long.png");

    public void render(ForgeGui gui, PoseStack poseStack, float partialTicks, int screenWidth, int screenHeight) {
        if (!Minecraft.m_91087_().f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            FloatingLong capacity = FloatingLong.ZERO;
            FloatingLong stored = FloatingLong.ZERO;
            for (ItemStack stack : Minecraft.m_91087_().f_91074_.m_6168_()) {
                IEnergyContainer container;
                if (!(stack.m_41720_() instanceof ItemMekaSuitArmor) || (container = StorageUtils.getEnergyContainer(stack, 0)) == null) continue;
                capacity = capacity.plusEqual(container.getMaxEnergy());
                stored = stored.plusEqual(container.getEnergy());
            }
            if (!capacity.isZero()) {
                int x = screenWidth / 2 - 91;
                int y = screenHeight - gui.leftHeight + 2;
                int length = (int)Math.round(stored.divide(capacity).doubleValue() * 79.0);
                GuiUtils.renderExtendedTexture(poseStack, GuiBar.BAR, 2, 2, x, y, 81, 6);
                RenderSystem.m_157456_((int)0, (ResourceLocation)POWER_BAR);
                GuiComponent.m_93160_((PoseStack)poseStack, (int)(x + 1), (int)(y + 1), (int)length, (int)4, (float)0.0f, (float)0.0f, (int)length, (int)4, (int)79, (int)4);
                gui.leftHeight += 8;
            }
        }
    }
}

