/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.advancements.triggers;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.registries.MekanismDamageSource;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class MekanismDamageTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private final ResourceLocation id;

    public MekanismDamageTrigger(ResourceLocation id) {
        this.id = id;
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.id;
    }

    @NotNull
    protected TriggerInstance createInstance(@NotNull JsonObject json, @NotNull EntityPredicate.Composite playerPredicate, @NotNull DeserializationContext context) {
        String damageType = GsonHelper.m_13906_((JsonObject)json, (String)"damage");
        MekanismDamageSource damageSource = MekanismDamageSource.DAMAGE_SOURCES.stream().filter(source -> source.m_19385_().equals(damageType)).findFirst().orElseThrow(() -> new JsonSyntaxException("Expected damage to represent a Mekanism damage source."));
        return new TriggerInstance(playerPredicate, damageSource, GsonHelper.m_13912_((JsonObject)json, (String)"killed"));
    }

    public void trigger(ServerPlayer player, MekanismDamageSource damageSource, boolean hardcoreTotem) {
        this.m_66234_(player, instance -> {
            if (!instance.killed || player.m_21224_() || hardcoreTotem) {
                return instance.damageType == damageSource;
            }
            return false;
        });
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MekanismDamageSource damageType;
        private final boolean killed;

        public TriggerInstance(EntityPredicate.Composite playerPredicate, MekanismDamageSource damageType, boolean killed) {
            super(MekanismCriteriaTriggers.DAMAGE.m_7295_(), playerPredicate);
            this.damageType = damageType;
            this.killed = killed;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            json.addProperty("damage", this.damageType.m_19385_());
            json.addProperty("killed", Boolean.valueOf(this.killed));
            return json;
        }

        public static TriggerInstance damaged(MekanismDamageSource damageType) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, damageType, false);
        }

        public static TriggerInstance killed(MekanismDamageSource damageType) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, damageType, true);
        }
    }
}

