/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.transmitter;

import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.PipeTier;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;

public class BlockMechanicalPipe
extends BlockLargeTransmitter
implements ITypeBlock,
IHasTileEntity<TileEntityMechanicalPipe> {
    private final PipeTier tier;

    public BlockMechanicalPipe(PipeTier tier) {
        this.tier = tier;
    }

    @Override
    public BlockType getType() {
        return AttributeTier.getPassthroughType(this.tier);
    }

    @Override
    public TileEntityTypeRegistryObject<TileEntityMechanicalPipe> getTileType() {
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case PipeTier.ADVANCED -> MekanismTileEntityTypes.ADVANCED_MECHANICAL_PIPE;
            case PipeTier.ELITE -> MekanismTileEntityTypes.ELITE_MECHANICAL_PIPE;
            case PipeTier.ULTIMATE -> MekanismTileEntityTypes.ULTIMATE_MECHANICAL_PIPE;
            case PipeTier.BASIC -> MekanismTileEntityTypes.BASIC_MECHANICAL_PIPE;
        };
    }
}

