/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkCommand {
    private static final LongSet chunkWatchers = new LongOpenHashSet();

    private ChunkCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        MinecraftForge.EVENT_BUS.register(ChunkCommand.class);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chunk").requires((Predicate)MekanismPermissions.COMMAND_CHUNK)).then(WatchCommand.register())).then(UnwatchCommand.register())).then(ClearCommand.register())).then(FlushCommand.register());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_LOADED);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ChunkCommand.handleChunkEvent((ChunkEvent)event, MekanismLang.COMMAND_CHUNK_UNLOADED);
    }

    private static void handleChunkEvent(ChunkEvent event, ILangEntry direction) {
        if (event.getLevel() == null || event.getLevel().m_5776_()) {
            return;
        }
        ChunkPos pos = event.getChunk().m_7697_();
        if (chunkWatchers.contains(pos.m_45588_())) {
            MutableComponent message = direction.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(pos));
            event.getLevel().m_6907_().forEach(arg_0 -> ChunkCommand.lambda$handleChunkEvent$0((Component)message, arg_0));
        }
    }

    private static Component getPosition(ChunkPos pos) {
        return MekanismLang.GENERIC_WITH_COMMA.translate(pos.f_45578_, pos.f_45579_);
    }

    private static /* synthetic */ void lambda$handleChunkEvent$0(Component message, Player player) {
        player.m_213846_(message);
    }

    private static class WatchCommand {
        private WatchCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"watch").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_WATCH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                return WatchCommand.watch(source, new ChunkPos(new BlockPos(source.m_81371_())));
            })).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(ctx -> {
                ColumnPos column = ColumnPosArgument.m_118992_((CommandContext)ctx, (String)"pos");
                return WatchCommand.watch((CommandSourceStack)ctx.getSource(), column.m_143196_());
            }));
        }

        private static int watch(CommandSourceStack source, ChunkPos chunkPos) {
            chunkWatchers.add(ChunkPos.m_45589_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_));
            source.m_81354_((Component)MekanismLang.COMMAND_CHUNK_WATCH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(chunkPos)), true);
            return 0;
        }
    }

    private static class UnwatchCommand {
        private UnwatchCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unwatch").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_UNWATCH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                return UnwatchCommand.unwatch(source, new ChunkPos(new BlockPos(source.m_81371_())));
            })).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(ctx -> {
                ColumnPos column = ColumnPosArgument.m_118992_((CommandContext)ctx, (String)"pos");
                return UnwatchCommand.unwatch((CommandSourceStack)ctx.getSource(), column.m_143196_());
            }));
        }

        private static int unwatch(CommandSourceStack source, ChunkPos chunkPos) {
            chunkWatchers.remove(ChunkPos.m_45589_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_));
            source.m_81354_((Component)MekanismLang.COMMAND_CHUNK_UNWATCH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, ChunkCommand.getPosition(chunkPos)), true);
            return 0;
        }
    }

    private static class ClearCommand {
        private ClearCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_CLEAR)).executes(ctx -> {
                int count = chunkWatchers.size();
                chunkWatchers.clear();
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)MekanismLang.COMMAND_CHUNK_CLEAR.translateColored(EnumColor.GRAY, EnumColor.INDIGO, count), true);
                return 0;
            });
        }
    }

    private static class FlushCommand {
        private FlushCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)"flush").requires((Predicate)MekanismPermissions.COMMAND_CHUNK_FLUSH)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerChunkCache sp = source.m_81372_().m_7726_();
                int startCount = sp.m_8482_();
                sp.m_201698_(() -> false, false);
                source.m_81354_((Component)MekanismLang.COMMAND_CHUNK_FLUSH.translateColored(EnumColor.GRAY, EnumColor.INDIGO, startCount - sp.m_8482_()), true);
                return 0;
            });
        }
    }
}

