/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.HybridInventorySlot;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class TankMultiblockData
extends MultiblockData
implements IValveHandler {
    @ContainerSync
    public final MergedTank mergedTank;
    @ContainerSync
    @SyntheticComputerMethod(getter="getContainerEditMode")
    public IFluidContainerManager.ContainerEditMode editMode = IFluidContainerManager.ContainerEditMode.BOTH;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private HybridInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private HybridInventorySlot outputSlot;
    private int tankCapacity;
    private long chemicalTankCapacity;
    public float prevScale;

    public TankMultiblockData(TileEntityDynamicTank tile) {
        super(tile);
        IContentsListener saveAndComparator = this.createSaveAndComparator();
        this.mergedTank = MergedTank.create(VariableCapacityFluidTank.create(this, this::getTankCapacity, BasicFluidTank.alwaysTrue, saveAndComparator), MultiblockChemicalTankBuilder.GAS.create(this, this::getChemicalTankCapacity, ChemicalTankBuilder.GAS.alwaysTrue, saveAndComparator), MultiblockChemicalTankBuilder.INFUSION.create(this, this::getChemicalTankCapacity, ChemicalTankBuilder.INFUSION.alwaysTrue, saveAndComparator), MultiblockChemicalTankBuilder.PIGMENT.create(this, this::getChemicalTankCapacity, ChemicalTankBuilder.PIGMENT.alwaysTrue, saveAndComparator), MultiblockChemicalTankBuilder.SLURRY.create(this, this::getChemicalTankCapacity, ChemicalTankBuilder.SLURRY.alwaysTrue, saveAndComparator));
        this.fluidTanks.add(this.mergedTank.getFluidTank());
        this.gasTanks.add(this.mergedTank.getGasTank());
        this.infusionTanks.add(this.mergedTank.getInfusionTank());
        this.pigmentTanks.add(this.mergedTank.getPigmentTank());
        this.slurryTanks.add(this.mergedTank.getSlurryTank());
        this.inventorySlots.addAll(this.createBaseInventorySlots());
    }

    private List<IInventorySlot> createBaseInventorySlots() {
        ArrayList<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
        this.inputSlot = HybridInventorySlot.inputOrDrain(this.mergedTank, this, 146, 21);
        inventorySlots.add(this.inputSlot);
        this.outputSlot = HybridInventorySlot.outputOrFill(this.mergedTank, this, 146, 51);
        inventorySlots.add(this.outputSlot);
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        return inventorySlots;
    }

    @Override
    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        MergedTank.CurrentType type = this.mergedTank.getCurrentType();
        if (type == MergedTank.CurrentType.EMPTY) {
            this.inputSlot.handleTank(this.outputSlot, this.editMode);
            this.inputSlot.drainChemicalTanks();
            this.outputSlot.fillChemicalTanks();
        } else if (type == MergedTank.CurrentType.FLUID) {
            this.inputSlot.handleTank(this.outputSlot, this.editMode);
        } else {
            this.inputSlot.drainChemicalTank(type);
            this.outputSlot.fillChemicalTank(type);
        }
        float scale = this.getScale();
        if (scale != this.prevScale) {
            this.prevScale = scale;
            needsPacket = true;
        }
        return needsPacket;
    }

    @Override
    public void readUpdateTag(CompoundTag tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
        this.mergedTank.readFromUpdateTag(tag);
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundTag tag) {
        super.writeUpdateTag(tag);
        tag.m_128350_("scale", this.prevScale);
        this.mergedTank.addToUpdateTag(tag);
        this.writeValves(tag);
    }

    private float getScale() {
        return switch (this.mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> MekanismUtils.getScale(this.prevScale, this.getFluidTank());
            case MergedTank.CurrentType.GAS -> MekanismUtils.getScale(this.prevScale, this.getGasTank());
            case MergedTank.CurrentType.INFUSION -> MekanismUtils.getScale(this.prevScale, this.getInfusionTank());
            case MergedTank.CurrentType.PIGMENT -> MekanismUtils.getScale(this.prevScale, this.getPigmentTank());
            case MergedTank.CurrentType.SLURRY -> MekanismUtils.getScale(this.prevScale, this.getSlurryTank());
            default -> MekanismUtils.getScale(this.prevScale, 0L, this.getChemicalTankCapacity(), true);
        };
    }

    @ComputerMethod
    public int getTankCapacity() {
        return this.tankCapacity;
    }

    @ComputerMethod
    public long getChemicalTankCapacity() {
        return this.chemicalTankCapacity;
    }

    @Override
    public void setVolume(int volume) {
        if (this.getVolume() != volume) {
            super.setVolume(volume);
            this.tankCapacity = volume * MekanismConfig.general.dynamicTankFluidPerTank.get();
            this.chemicalTankCapacity = (long)volume * MekanismConfig.general.dynamicTankChemicalPerTank.get();
        }
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        long capacity = this.mergedTank.getCurrentType() == MergedTank.CurrentType.FLUID ? (long)this.getTankCapacity() : this.getChemicalTankCapacity();
        return MekanismUtils.redstoneLevelFromContents(this.getStoredAmount(), capacity);
    }

    private long getStoredAmount() {
        return switch (this.mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> this.getFluidTank().getFluidAmount();
            case MergedTank.CurrentType.GAS -> this.getGasTank().getStored();
            case MergedTank.CurrentType.INFUSION -> this.getInfusionTank().getStored();
            case MergedTank.CurrentType.PIGMENT -> this.getPigmentTank().getStored();
            case MergedTank.CurrentType.SLURRY -> this.getSlurryTank().getStored();
            default -> 0L;
        };
    }

    public IExtendedFluidTank getFluidTank() {
        return this.mergedTank.getFluidTank();
    }

    public IGasTank getGasTank() {
        return this.mergedTank.getGasTank();
    }

    public IInfusionTank getInfusionTank() {
        return this.mergedTank.getInfusionTank();
    }

    public IPigmentTank getPigmentTank() {
        return this.mergedTank.getPigmentTank();
    }

    public ISlurryTank getSlurryTank() {
        return this.mergedTank.getSlurryTank();
    }

    public boolean isEmpty() {
        return this.mergedTank.getCurrentType() == MergedTank.CurrentType.EMPTY;
    }

    @ComputerMethod
    public void setContainerEditMode(IFluidContainerManager.ContainerEditMode mode) {
        if (this.editMode != mode) {
            this.editMode = mode;
            this.markDirty();
        }
    }

    @ComputerMethod
    private void incrementContainerEditMode() {
        this.setContainerEditMode((IFluidContainerManager.ContainerEditMode)this.editMode.getNext());
    }

    @ComputerMethod
    private void decrementContainerEditMode() {
        this.setContainerEditMode((IFluidContainerManager.ContainerEditMode)this.editMode.getPrevious());
    }

    @ComputerMethod
    private Object getStored() {
        return switch (this.mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> this.getFluidTank().getFluid();
            case MergedTank.CurrentType.GAS -> (GasStack)this.getGasTank().getStack();
            case MergedTank.CurrentType.INFUSION -> (InfusionStack)this.getInfusionTank().getStack();
            case MergedTank.CurrentType.PIGMENT -> (PigmentStack)this.getPigmentTank().getStack();
            case MergedTank.CurrentType.SLURRY -> (SlurryStack)this.getSlurryTank().getStack();
            default -> FluidStack.EMPTY;
        };
    }

    @ComputerMethod
    private double getFilledPercentage() {
        long capacity = this.mergedTank.getCurrentType() == MergedTank.CurrentType.FLUID ? (long)this.getTankCapacity() : this.getChemicalTankCapacity();
        return (double)this.getStoredAmount() / (double)capacity;
    }
}

