/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.DecomposedRecipeBuilder;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.List;
import java.util.Optional;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.SawmillRecipeManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=SawmillRecipe.class)
public class SawmillRecipeHandler
extends MekanismRecipeHandler<SawmillRecipe> {
    public String dumpToCommandString(IRecipeManager<? super SawmillRecipe> manager, SawmillRecipe recipe) {
        boolean hasSecondary = recipe.getSecondaryChance() > 0.0;
        List<ItemStack> mainOutputDefinition = recipe.getMainOutputDefinition();
        return this.buildCommandString(manager, recipe, recipe.getInput(), mainOutputDefinition.isEmpty() ? SKIP_OPTIONAL_PARAM : mainOutputDefinition, hasSecondary ? recipe.getSecondaryOutputDefinition() : SKIP_OPTIONAL_PARAM, hasSecondary ? Double.valueOf(recipe.getSecondaryChance()) : SKIP_OPTIONAL_PARAM);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super SawmillRecipe> manager, SawmillRecipe recipe, U o) {
        if (!(o instanceof SawmillRecipe)) return false;
        SawmillRecipe other = (SawmillRecipe)o;
        if (!this.ingredientConflicts(recipe.getInput(), other.getInput())) return false;
        return true;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super SawmillRecipe> manager, SawmillRecipe recipe) {
        List<ItemStack> mainOutputDefinition = recipe.getMainOutputDefinition();
        if (mainOutputDefinition.size() > 1) {
            return Optional.empty();
        }
        List<ItemStack> secondaryOutputDefinition = recipe.getSecondaryOutputDefinition();
        if (secondaryOutputDefinition.size() > 1 || secondaryOutputDefinition.isEmpty() == recipe.getSecondaryChance() > 0.0) {
            return Optional.empty();
        }
        if (mainOutputDefinition.isEmpty() && secondaryOutputDefinition.isEmpty()) {
            return Optional.empty();
        }
        DecomposedRecipeBuilder builder = IDecomposedRecipe.builder().with(CrTRecipeComponents.ITEM.input(), (Object)recipe.getInput());
        if (mainOutputDefinition.isEmpty()) {
            builder.with(CrTRecipeComponents.ITEM.output(), CrTUtils.convertItems(secondaryOutputDefinition)).with(CrTRecipeComponents.CHANCE, (Object)recipe.getSecondaryChance());
        } else if (secondaryOutputDefinition.isEmpty()) {
            builder.with(CrTRecipeComponents.ITEM.output(), CrTUtils.convertItems(mainOutputDefinition));
        } else {
            builder.with(CrTRecipeComponents.ITEM.output(), CrTUtils.convertItems(List.of(mainOutputDefinition.get(0), secondaryOutputDefinition.get(0)))).with(CrTRecipeComponents.CHANCE, (Object)recipe.getSecondaryChance());
        }
        return Optional.of(builder.build());
    }

    public Optional<SawmillRecipe> recompose(IRecipeManager<? super SawmillRecipe> m, ResourceLocation name, IDecomposedRecipe recipe) {
        if (m instanceof SawmillRecipeManager) {
            IItemStack secondaryOutput;
            SawmillRecipeManager manager = (SawmillRecipeManager)m;
            ItemStackIngredient input = (ItemStackIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.ITEM.input());
            List outputs = recipe.get(CrTRecipeComponents.ITEM.output());
            if (outputs == null || outputs.isEmpty() || outputs.size() > 2) {
                throw new IllegalArgumentException("Incorrect number of outputs specified. Must be either one or two outputs, and have a secondary chance if two.");
            }
            double chance = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.CHANCE).orElse(0.0);
            if (chance == 0.0 && outputs.size() == 2) {
                throw new IllegalArgumentException("No chance of specified secondary output.");
            }
            IItemStack output = (IItemStack)outputs.get(0);
            if (outputs.size() == 1) {
                if (chance > 1.0 && chance < 2.0) {
                    chance -= 1.0;
                    secondaryOutput = output.copy();
                } else {
                    secondaryOutput = IItemStack.empty();
                }
            } else {
                secondaryOutput = (IItemStack)outputs.get(1);
            }
            if (secondaryOutput.isEmpty()) {
                if (chance == 0.0 || chance == 1.0) {
                    return Optional.of(manager.makeRecipe(name, input, output));
                }
                return Optional.of(manager.makeRecipe(name, input, output, chance));
            }
            return Optional.of(manager.makeRecipe(name, input, output, secondaryOutput, chance));
        }
        return Optional.empty();
    }
}

